//    

/* gcdlib::bivargcd - compute the gcd of bivariate polynomials
  over fields */

gcdlib::bivargcd:=proc(f,g)
local inds,x,y,dx,dy,oldF,F,evpoints,fimages,gimages,ha,fa,ga,a,b,h,j,m,dg,
       q,result,R,bound,yminusyiprod,t,k,oldb;


begin
F:=op(f,3);
oldF:=F;
q:=(if F::constructor=Dom::GaloisField then
	F::size
    elif F::constructor=Dom::IntegerMod then
	F::characteristic
    else
	infinity 
    end_if
    );   
inds:=op(f,2);
x:=op(inds,1);
y:=op(inds,2);
R:=Dom::DistributedPolynomial([y],F);
f:=poly(f,[x],R);
g:=poly(g,[x],R);
result:=gcd(content(f),content(g)); 
f:=polylib::primpart(f); 
g:=polylib::primpart(g); 
dx:=max(degree(f),degree(g));
dy:=max(op(map([coeff(f),coeff(g)],degree))); 
bound:=(2*dx+2)*dy;
j:=0;
repeat 
	j:=j+1 
until 2*bound < q^j-degree(lcoeff(f))-degree(lcoeff(g)) end_repeat; 
if j>1 then
	// extend F in any case 
	F:=Dom::GaloisField(F,j);
	R:=Dom::DistributedPolynomial([y],F);
	f:=subsop(f,3=R);
	g:=subsop(g,3=R);
end_if;
evpoints:=[];
gimages:=[];
fimages:=[];
h:=[];
m:=dx+1;  // m = minimum of degrees of gcd's of images found so far 
repeat
	repeat 
		a:=F::random();
	until not iszero(evalp(lcoeff(f),y=a)) and 
	      not iszero(evalp(lcoeff(g),y=a)) and 
              not has(evpoints,a) end_repeat;
	userinfo(3,"Next interpolation point");
	ga:=poly(mapcoeffs(g,proc() begin evalp(args(1),y=a) end_proc ),[x],F); 
	fa:=poly(mapcoeffs(f,proc() begin evalp(args(1),y=a) end_proc ),[x],F);
	 ha:=multcoeffs(gcd(fa,ga),lcoeff(fa)); 
	if (dg:=degree(ha))=0 then
		return(poly(1,inds,oldF));
	elif dg<m then 
		userinfo(3,"Gcd of smaller degree found, restarting interpolation");
		evpoints:=[a];
		gimages:=[ga];
		fimages:=[fa];
		h:=[ha];
		m:=dg;
		// first interpolation: constant 
		b:=poly(ha,[x],R);
		yminusyiprod:= R(y-expr(a));
		t:=[map([coeff(ha,All)], R)];
		oldb:=FAIL; // no trial division 
	elif dg=m then
		evpoints:=append(evpoints,a);
		gimages:=append(gimages,ga);
		fimages:=append(fimages,fa);
		h:=append(h,ha);
		// improve interpolating polynom 

		t:=append(t,map([coeff(ha,All)], R));
		
		for k from nops(t)-1 downto 1 do
			t[k]:=zip(t[k+1],t[k],
				proc() begin multcoeffs(args(1)-args(2),
				F::_invert(a-evpoints[k]))
				 end_proc );	
		end_for;
		oldb:=b;
		b:=b+multcoeffs(poly([[t[1][j+1],j] $j=0..m],[x],R),
			yminusyiprod);
		yminusyiprod:=yminusyiprod*R(y-expr(a));
	end_if;			

// here b is correct modulo yminusyiprod 
				
until b=oldb and divide(f,polylib::primpart(b),hold(Exact))<>FAIL end_repeat;

// trial division only if modular gcd did not change 

b:=poly(polylib::primpart(b),inds,oldF);

return(multcoeffs(b,1/lcoeff(b))*poly(result,inds,oldF));

end_proc:
