//    

// kg, 30/07/94 

/*--
gcdlib::dom_gcd -- compute gcd of 2 polynomials over a domain

gcdlib::dom_gcd(p1, p2)

p1,p2 - non-zero polynomials over a domain
--*/

gcdlib::dom_gcd:=
proc(aa, bb)
  local x, X, T, g, r, i, j, a, b, aexpr, bexpr, ca, cb;
  save SEED;
begin

  // we use random evaluation points below and want to have reproducible behavior
  SEED:= 1;

  X:= op(aa,2);
  T:= op(aa,3);

  // handle some special domains
  
  if T::hasProp(Dom::IntegerMod)=TRUE then  // mod_gcd is faster 
    r:= IntMod(T::size);
    g:= gcdlib::mod_gcd(poly(aa, r), poly(bb, r));
    return(poly(multcoeffs(g, 1/lcoeff(g)), T));
  end_if;

  if T::hasProp(Dom::Rational)=TRUE then
    g:=gcdlib::special_cases(polylib::primpart(poly(aa, Expr)),
                             polylib::primpart(poly(bb, Expr)),
                             gcdlib::int_gcd, ()->args(1));
    return(poly(multcoeffs(g, 1/lcoeff(g)), T))
  end_if;

  if T::hasProp(Dom::Integer)=TRUE then
    g:=gcdlib::special_cases(poly(aa,Expr), poly(bb,Expr),
                             gcdlib::int_gcd, gcdlib::norm_intp);
    return(poly(g, T))
  end_if;
  
  if T::hasProp(Dom::AlgebraicExtension) = TRUE and
    T::groundField = Dom::Rational and
    expr(T::minpoly) = T::variable^2 + 1 then 
    // we are over Q(I), try a special method
    ca:= map(coeff(aa), coeff@expr);
    cb:= map(coeff(bb), coeff@expr);
    a:= multcoeffs(aa, 1/gcd(ca));
    b:= multcoeffs(bb, 1/gcd(cb));
    aexpr:= subs(poly(a, Expr), T::variable = I);
    bexpr:= subs(poly(b, Expr), T::variable = I);
    r:= gcdlib::gcd_QI(aexpr, bexpr);
    return(poly(subs(r, I = T::variable), X, T)) 
  end_if;  
  
  if T::hasProp(Cat::IntegralDomain) <> TRUE and not op(T::create_dom, 0) = hold(polylib::Poly) then
    error("Coefficient ring must belong to category Cat::IntegralDomain")
  end_if;

  // univariate case? 
  if nops(X) = 1 then
    r:= gcdlib::udom_gcd(aa,bb)
  else
    // reduce to univariate case 
    x:= X[1];
    delete X[1];
    a:= poly(aa, [x], polylib::Poly(X,T));
    b:= poly(bb, [x], polylib::Poly(X,T));
    // try zero evaluation point first 
    // if the modular gcd is 1, the gcd equals the content 
    g:=map([a,b],proc()
                 begin
                   mapcoeffs(args(1),coeff,0)
                 end_proc );
    // set g to list of modular images of a and b 
    if map(g,degree)=map([a,b],degree) then
      if degree(gcd(op(g)))=0 then
        g:=gcd(op(map([a,b],content)));
        userinfo(5,"Trailing coefficients are relatively prime");
        userinfo(5,"gcd cannot depend on ".expr2text(x));
      end_if;
      // try some random evaluation points 
    elif T::random <> FAIL then
      for i from 1 to 3 do  // three evaluation points 
        r:=[ T::random() $j=1..nops(X)];
        g:=map([a,b],proc()
                     begin
                       mapcoeffs(args(1),proc()
                                         begin
                                           evalp(args(1),
                                                 X[j]=r[j] $j=1..nops(X))
                                         end_proc )
               end_proc );
        if degree(gcd(op(g)))=0 and
          map(g,degree)=map([a,b],degree) then
          g:=gcd(op(map(g,content)));
          userinfo(5,"Modular images are relatively prime");
          userinfo(5,"gcd cannot depend on ".expr2text(x));
          break;
        end_if;
      end_for;
    end_if;
    // if no success -> slow method 
    if domtype(g)=DOM_LIST then
      g:= gcdlib::udom_gcd(a,b);
    end_if;
    // convert back to multivariate polynomial 
    X:= [x].X;
    r:= poly(T::zero,X,T);
    for i from 1 to nterms(g) do
      x:= nthcoeff(g,i);
      r:= r + poly(nthterm(g,i),X,T) *
          _plus((poly(nthcoeff(x,j),X,T) *
                 poly(nthterm(x,j),X,T))
                $ j=1..nterms(x));
    end_for;
  end_if;

  // normalize result if possible 
  if T::unitNormalRep <> FAIL then
    x:= T::unitNormalRep(lcoeff(r));
    r:= multcoeffs(r, x[2]);
  end_if;
  r
end_proc:

// end of file 
