
/*  
   gcdlib::extractDenom(a)

   a - polynomial over Expr

   returns [ca, pa] where ca is an expression and pa is a polynomial of the same type as a
   such that a = ca*pa  and the coefficients of pa do not contain fractions 

   Experiments show that it is usually to expensive to divide off the gcd of the numerators of the
   coefficients: that is, we do not guarantee that pa is primitive

*/

gcdlib::extractDenom:=
proc(a: DOM_POLY): DOM_LIST
  local l: DOM_LIST, l1: DOM_LIST, subst: DOM_SET, coeffs: DOM_LIST, 
  expos: DOM_LIST, normalized: DOM_LIST, lcdenom, i: DOM_INT, f: DOM_POLY;
begin
  l:= poly2list(a);
  // rationalize first!
  [l1, subst]:= [rationalize(l)];
  // split
  coeffs:= map(l1, op, 1);
  expos:= map(l1, op, 2);
  // normalize each coefficient
  normalized:= map(coeffs, normal, List);
  lcdenom:= lcm(op(map(normalized, op, 2)));
  
  if lcdenom <> 1 then
    for i from 1 to nops(normalized) do
      normalized[i]:= normalized[i][1] * divide(lcdenom, normalized[i][2], Exact);
      assert(normalized[i] <> FAIL)
    end_for
  else 
    normalized:= map(normalized, op, 1)
  end_if;  
  
  f:= poly([[normalized[i], expos[i]] $i=1..nops(expos)], op(a, 2..3));
  
  
  subs([1/lcdenom, f], subst, EvalChanges) 
end_proc: