gcdlib::gcdexPrimitive:=
proc(A: DOM_POLY, B: DOM_POLY, x)
  local a, b, gca, gcb, gc, s, t, u, v, p, q, r, tmp, h, subst;
begin   
  assert(degree(A) >= degree(B));
  
  
  [r, subst]:= [rationalize([poly2list(A), poly2list(B)], FindRelations = ["_power"], StopOnConstants)];
  A:= poly(r[1], [x]);
  B:= poly(r[2], [x]);
  gc:= gcd(A, B);
  A:= divide(A, gc, Quo); // really an exact division
  B:= divide(B, gc, Quo); // really an exact division
  [gca, A]:= gcdlib::extractDenom(A);
  [gcb, B]:= gcdlib::extractDenom(B);
  
  a:= A;
  b:= B;
  
  s:=a^0; t:=s-s; u:=t; v:=s;
   // loop invariant : a = s*A + t*B, b = u*A + v*B
  while not iszero(b) do
    userinfo(10, "Applying Euclidean step");
    [p, q, r]:= [pdivide(a, b)];
    userinfo(10, expr2text(p)." * ".expr2text(a)." = ".expr2text(b)."*".expr2text(q)." + ".expr2text(r));
    // the loop invariant and p*a = q*b + r imply 
    // p*s*A + p*t*B = p*a = q*b + r = q*u*A + q*v*B + r
    // Thus r = (p*s - q*u)*A + (p*t - q*v)*B         
    a:= b;
    b:= mapcoeffs(r, normal, Expand = FALSE);
    [s, u]:= [u, p*s-q*u];
    [t, v]:= [v, p*t-q*v];
    // loop invariant holds again:
    userinfo(10, expr2text(a)." = ".expr2text(s). "*". expr2text(A)." + ".expr2text(t)."*".expr2text(B));
    // We could do a reduction of the remainder to get the subresultant PRS, 
    // by dividing off g*h^delta (see the source code of polylib::resultant)
    // However, experimentally, it turns out that we have to divide off the
    // content all the time because in quite some examples g*h^delta is not
    // enough to make b primitive
      
    h:= content(b);
    if not iszero(h) and h <> 1 then
      if contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, type(h)) then 
        b:= multcoeffs(b, 1/h)
      else
        b:= mapcoeffs(b, divide, h, Quo) // really an exact division
      end_if;  
      u:= multcoeffs(u, 1/h);      
      v:= multcoeffs(v, 1/h)
    end_if;  
    
  end_while;
  a:= a*gc;
  tmp:= 1/lcoeff(a);
  // we have solved s*a/gca + t*b/gcb = 1; thus 
  // s/gca  * gc*a  + t/gcb * gc*b  = gc
  
  // By convention, we return the monic gcd here 
  op(subs([multcoeffs(a, tmp), multcoeffs(s, tmp/gca), multcoeffs(t, tmp/gcb)], 
     subst, EvalChanges))
 
end_proc:

// end of file