//    

// kg, 09/12/93 

/*--
gcdlib::int_gcd -- compute the gcd of two polynomials over the integers

gcdlib::int_gcd(p1, p2)

p1,p2 - non-zero polynomials of type 'Expr' over the integers

gcdlib::int_gcd computes the gcd of 2 non-zero polynomials over the integers.
The arguments are not checked.
--*/

gcdlib::int_gcd:=
proc(aa, bb)
  local a, b, ca, cb, g, inds, phia, phib, rndgen, rndvec, m, T, dependsOn;
  save SEED;
begin
  SEED:= 1;

  userinfo(2, "Integer gcd called with input in the variables ".
           expr2text(op(aa,2)) );
  userinfo(10, "Input is ".expr2text(aa)." and ".expr2text(bb));

  if iszero(aa) then return(bb) end_if;
  if iszero(bb) then return(aa) end_if;
 
  // remove integer contents
  ca:= icontent(aa);
  cb:= icontent(bb);
  a:= multcoeffs(aa, 1/ca);
  b:= multcoeffs(bb, 1/cb);
  ca:= igcd(ca, cb);

   // special case
  if a=b then
    return(multcoeffs(a, ca));
  end_if;

  
  inds:= op(a,2);

    /* easy check: for polynomials with many indeterminates, 
      try some random homomorphism which does not map both
      lcf(a) and lcf(b) to zero - since lcf(gcd(a,b)) divides
      both of them, this homomorphism won't decrease 
      the degree of the gcd. Therefore test whether gcd of
      images is already 1 : then gcd(a,b) does only depend
      on those variables for which something was inserted .
   */

  g:="undefined";
     
  if nops(inds)>=2 then
    dependsOn:=[];
    rndgen:=random(1000); // should suffice
    for m from 1 to nops(inds) do
      // try zero evaluation point first
      userinfo(15, "Trying zero evaluation point");
      rndvec:=[0 $nops(inds)-1];
      phia:=evalp(a, op(zip([op(inds,1..m-1)
                             ,op(inds,m+1..nops(inds))], rndvec, _equal)));
      phib:=evalp(b, op(zip([op(inds,1..m-1)
                             ,op(inds,m+1..nops(inds))], rndvec, _equal)));
      
      while not (degree(a, op(inds,m)) = degree(phia)
                 and degree(b, op(inds,m)) = degree(phib)) do
        userinfo(15, "Trying random evaluation point");
        rndvec:=[rndgen() $g=2..nops(inds)];
        phia:=evalp(a, op(zip([op(inds,1..m-1)
                               ,op(inds,m+1..nops(inds))], rndvec, _equal)));
        phib:=evalp(b, op(zip([op(inds,1..m-1)
                               ,op(inds,m+1..nops(inds))], rndvec, _equal)))
      end_while;

      userinfo(10, "Found evaluation point");
      userinfo(20, "Evaluation point was: ".expr2text(rndvec));
      
      if degree(gcd(phia,phib))>0 then
        userinfo(4, "gcd probably depends on ".expr2text(inds[m]));
        dependsOn:=append(dependsOn, inds[m])
      else
        userinfo(4, "gcd does not depend on ".expr2text(inds[m]))
      end_if;
    end_for;
	 if dependsOn = [] then
	    return(poly(ca,inds))
	 end_if;
	 if dependsOn <> inds then // remove unnecessary variables 
	    T:=select(inds, proc() begin contains(dependsOn, args(1))=0 end_proc ),
                polylib::Poly(dependsOn);
            gcd(coeff(poly(a,T)), coeff(poly(b,T)) );
            g:= poly(%, inds)
    end_if;
  end_if;

  if g="undefined" then
    // try heuristic and use sparse modular alg. if it fails
    userinfo(2, "Trying heuristic gcd");
    g:= gcdlib::heu_gcd(a, b);
    if domtype(g) <> DOM_POLY then
      userinfo(2, "Using sparse modular gcd-algorithm");
      g:= gcdlib::int_mod_gcd(a, b)
    end_if;
  end_if;
    
  userinfo(8, "Got result ".expr2text(g));
  // normalize result
  if lcoeff(g) < 0 then
    multcoeffs(g, -ca/icontent(g))
  else
    multcoeffs(g, ca/icontent(g))
  end_if
end_proc:

// end of file 
