//       

// stefanw, 26.7.1996 

/*++ 
gcdlib::langemyr -- compute the gcd of univariate polynomials over
		    an algebraic number field Dom::AlgebraicExtension
		    (Dom::Rational,r), using the algorithm of
		    Langemyr and McCallum
		    works best if r is monic with integer coefficients

gcdlib::langemyr(f,g,initialp)
f,g -  univariate polynomials over algebraic number field
initialp - (optional)  lower bound for prime moduli used
++*/

gcdlib::langemyr:=proc(fff,ggg,initialp)
local f, g, F,G,r,delta,x,y,ff,gg,a,b,rj,Rj,rjprod,hstar,hhstar,
gcdxx,hbar,hhh,i,j,k,c,gcdlist,Pprod,dg,p,rr,lcr;

begin
f:=fff;
g:=ggg;
G:=op(f,3);
r:=op(G::minpoly,1);
y:=op(indets(r));
r:=multcoeffs(r,1/icontent(r));
lcr:=lcoeff(r);
r:=subs(r,y=y/lcr);
userinfo(2,"Substituting ".expr2text(y/lcr). " for ".expr2text(y));
r:=multcoeffs(r,1/icontent(r));
F:=Dom::AlgebraicExtension(Dom::Rational,r);
delta:=polylib::resultant(r,diff(r,y));
x:=op(f,[2,1]);
ff:=multcoeffs(f,G::_invert(lcoeff(f)));
gg:=multcoeffs(g,G::_invert(lcoeff(g)));
ff:=expr(ff);
gg:=expr(gg);
ff:=subs(ff,y=y/lcr);
gg:=subs(gg,y=y/lcr);
ff:=multcoeffs(ff,1/icontent(ff));
gg:=multcoeffs(gg,1/icontent(gg));
f:=poly(ff,[x],F);
g:=poly(gg,[x],F);
a:=expr(lcoeff(f));
b:=expr(lcoeff(g));
c:=igcd(a,b)*delta;
userinfo(2,"Working over ".expr2text(F));
userinfo(3,"on input ".expr2text(f)." and ".expr2text(g));
userinfo(4,"delta = ".expr2text(c));

// step 0 

dg:=degree(f)+1; 
if args(0)=3 then
	p:=initialp;
else
	p:= 10^20;    // can be improved 
end_if;

// step 1: compute bound : not necessary 

while TRUE do
	// step 2: modular images 


	repeat
		p:=nextprime(p+1);
	until delta mod p <> 0  and a mod p <> 0 and b mod p <> 0 end_repeat;
	userinfo(2,"Choosing prime ".expr2text(p));

	rr:=poly(r,IntMod(p));
	rj:=factor(rr);
	rj:=[op(rj,2*i) $i=1..nops(rj) div 2];

        userinfo(4,"Homomorphic image is product of ".expr2text(nops(rj)).
		   " fields");
	// step 3 
	/* IntMod(p)[y]/(rr) is isomorphic to the product of all
	 IntMod(p)[y]/rj[i]
  	(Chinese Remainder Theorem)   */

 
	
	
	Rj:=map(rj,proc() begin Dom::GaloisField(p,degree(args(1)),args(1)) end_proc );

	gcdlist:=map(Rj,proc() begin gcd(poly(ff,[x],args(1)),
		poly(gg,[x],args(1)))
		 end_proc );
	gcdlist:=map(gcdlist,proc() begin poly(expr(args(1)),[x,y],IntMod(p)) end_proc );
	/* compute hstar with deg(hstar)<deg(r) solving hstar \equiv gcdlist[i] 
  	\bmod rj[i] (for 1 \leq i \leq nops(rj) ),
	 using several Euclidean algorithms
 	 instead of the Chinese Remainder Algorithm */

	hstar:=op(gcdlist,1); 
	rjprod:=op(rj,1);
	

	for i from 2 to nops(gcdlist) do
		gcdxx:=gcdex(rjprod,rj[i]);
		hhh:=[[rjprod*op(gcdxx,2)*coeff(gcdlist[i],x,j)
			+rj[i]*op(gcdxx,3)*coeff(hstar,x,j),j ]
			 $j= 0..max(degree(gcdlist[i],x),
			degree(hstar,x)) ];	
		hstar:=poly(mapcoeffs(poly(hhh,[x],polylib::Poly([y],IntMod(p))),
			proc() begin divide(args(1),rr,hold(Rem)) end_proc ),[x,y],IntMod(p));
		
		if degree(hstar,x)>dg then break; end_if;
		rjprod:=rjprod*rj[i];
	end_for;

	
	
	hhstar:=poly(multcoeffs(hstar,c),[x,y],Dom::Integer);

	
	if degree(hhstar,x)=dg then
		hhh:=poly(_plus((x^j*y^k*numlib::ichrem
		([coeff(coeff(hbar,x,j),y,k),coeff(coeff(hhstar,x,j),y,k)],
		 [Pprod,p]) 
		$j=0..max(degree(hbar,x),degree(hhstar,x)) ) 
		$k=0..max(degree(hbar,y),degree(hhstar,y)) ),[x,y],
		Dom::Integer);
 	        Pprod:=Pprod*p;
		userinfo(3,"Working modulo ".expr2text(Pprod));
		hhh:=mapcoeffs(hhh,proc() begin mods(args(1),Pprod) end_proc );
	      // test result 
	       if hhh<>hbar then 
			hbar:=hhh;
			userinfo(2,"New hbar:".expr2text(hbar));
	       else 
	      	
			hhh:=poly(hhh,[x],F);	
			userinfo(2,"Trying ".expr2text(hhh));
			if divide(f,hhh,hold(Exact)) <> FAIL then
				if divide(g,hhh,hold(Exact)) <> FAIL then
					// back substitution 
					hbar:=subs(expr(hhh),y=y*lcr);
					hbar:=poly(hbar,[x],G);
					return(multcoeffs(hbar,G::_invert(lcoeff(hbar))));
				end_if;
			end_if;	
			userinfo(2,"Test division failed");
	       end_if;	
	elif degree(hstar,x)<dg then	      		
		      dg:=degree(hstar,x);
                      if dg=0 then return(poly(1,[x],G)); end_if; 
		      userinfo(2,"(Re)-initializing list");
		      userinfo(2,"Degree is ".expr2text(dg));
		      Pprod:=p;	
		      hbar:=hhstar;
		      userinfo(3,"hbar: ".expr2text(hbar));						
	end_if;


end_while;

end_proc:
