//    

// kg, 09/12/93 

/*--
gcdlib::mod_gcd -- compute the gcd of IntMod-polynomials
 
gcdlib::mod_gcd(p1, p2)
 
p1,p2 - non-zero polynomials over IntMod
 
gcdlib::mod_gcd computes the gcd of 2 non-zero polynomials
over IntMod(p). p must be prime. The arguments are not checked further.
The result is not normalized.
--*/
 
// we have few examples where the sparse gcd fails; if it fails, then it always does so 
alias(SPARSETRIES = 3):


gcdlib::mod_gcd:= 
proc(a, b)
    local g, p, tries, vars, n, i, vars2, aa, bb;
begin
  // use Euclidean alg. for univariate polynomials 
  if nops(op(a, 2)) = 1 then
    return(gcdlib::univ_mod_gcd(a, b))
  end_if;
  
  p:= op(a,[3,1]);
  vars:= op(a, 2);
  n:= nops(vars);
  
  // If the degrees in all variables are bounded by d and there
  // are n variables, then we need more than n*d/epsilon evaluation 
  // points to have failure probability < epsilon in the sparse 
  // modular gcd over Zp, the number of evaluation points is p^n.
  // Taking epsilon = 1/4, this gives us 4*n*d < p^n

  if stdlib::max(degree(a, vars[i]) $i=1..n, 
                 degree(b, vars[i]) $i=1..n) * n * 4  < float(p)^n then

    // Experiments suggest that the sparse gcd works best on a permutation 
    // of variables such that the variable x with small value of
    //    min(nterms(coeff(a, x, 0)), nterms(coeff(b, x, 0))) 
    // comes last.
    vars2:= prog::sort(vars, 
                       proc(x) 
                       begin 
                         min(nterms(coeff(a, x, 0)), nterms(coeff(b, x, 0))) 
                       end, 
                       Reverse);
    aa:= poly(a, vars2);
    bb:= poly(b, vars2);
    for tries from 1 to SPARSETRIES do
      g:= gcdlib::mod_sparse_gcd(aa, bb, tries);
      if g <> FAIL then return(poly(g, vars)) end_if;
      if tries = 1 then 
         // the heuristic ordering vars2 of the variables
         // did not work. 
         if vars2 <> vars then // try the original ordering.
           aa:= a;
           bb:= b;
         else // try a cyclic permutation of the variables
           vars2:= [vars2[n], vars2[i] $ i = 1..n-1];
           aa:= poly(a, vars2);
           bb:= poly(b, vars2);
         end_if;
      else
         // last try: the heuristic orderings above
         // did not work. Try yet another ordering.
         aa:= poly(a, revert(vars2));
         bb:= poly(b, revert(vars2));
      end_if;
    end_for;  
  end_if;
  
  gcdlib::mod_dense_gcd(a, b)
end_proc:

// end of file 
