/*
  gcdlib::mod_gcd_QI(a, b)

  a, b - polynomials with complex coefficients

  returns the gcd of a and b

*/


alias(INITIALP = 10^10):

gcdlib::mod_gcd_QI:=
proc(a: DOM_POLY, b: DOM_POLY)
  local p: DOM_INT,
  pprod: DOM_INT,
  lca, lcb,
  gca, gcb,
  aa, bb, g, 
  g1, g2: DOM_POLY,
  roots: DOM_LIST, 
  exponents: DOM_SET,
  resultexponents,
  terms: DOM_LIST,
  result: DOM_POLY,
  ratresult: DOM_POLY,
  reconstruct:DOM_PROC
  ;
begin
  
  reconstruct:=
  proc(z, n)
    local res, res2;
  begin
    res:= numlib::reconstructRational(Re(z), n);
    if res = FAIL then
      FAIL
    else 
      res2:= numlib::reconstructRational(Im(z), n);
      if res2 = FAIL then 
        FAIL
      else
        op(res, 1)/op(res, 2) + I*op(res2, 1)/op(res2, 2)
      end_if
    end_if  
  end_proc;  
  
  gca:= gcd(coeff(a));
  gcb:= gcd(coeff(b));
  a:= multcoeffs(a, 1/gca);
  b:= multcoeffs(b, 1/gcb);
  lca:= lcoeff(a);
  lcb:= lcoeff(b);
  a:= multcoeffs(a, 1/lca);
  b:= multcoeffs(b, 1/lcb);
  
  pprod:= 1; // product of all primes used so far
  
  p:= INITIALP; // start the search for suitable p's here
  
  // main loop: compute the gcd modulo several p, and plug together using the Chinese remainder algorithm
  repeat
    
    // get next suitable prime
    repeat
      p:= nextprime(p+1)
    until 
      modp(p, 4) = 1  
      and 
    // check that lcoeff(a), lcoeff(b) are not zero modulo p
    (Re(lca) mod p <> 0 or Im(lca) mod p <> 0) and (Re(lcb) mod p <> 0 or Im(lcb) mod p <> 0)
    end_repeat;
  
    // compute the gcd over Z_p[X]/(X^2 + 1)
    // do gcds over Z_p[X]/(X^2 + 1) where X^2+1 is reducible
      roots:= numlib::mroots(poly(#X^2+1), p);
      aa:= poly(subs(a, I=roots[1]), IntMod(p));
      bb:= poly(subs(b, I=roots[1]), IntMod(p));
      g1:= gcd(aa, bb);
      aa:= poly(subs(a, I=roots[2]), IntMod(p));
      bb:= poly(subs(b, I=roots[2]), IntMod(p));
      g2:= gcd(aa, bb);
      // the gcd g of a and b over Z_p[X]/(X^2 + 1) satisfies (coeffientwise!)
      // g \equiv g1 (modulo X - roots[1]) and 
      // g \equiv g2 (modulo X - roots[2]) 
      // letting g = u + v*X, this means
      //        u + v*roots[1] = g1
      //        u + v*roots[2] = g2
      // we have to solve this 2x2 - system for u and v; the solution is
      // u = (g2*roots[1] - g1*roots[2])/(roots[1] - roots[2])
      // v = (g1- g2)/(roots[1]-roots[2])
      // since roots[2] = -roots[1], we may express this as
      // u = (g1+g2)/2
      // v = (g1-g2)/(2*roots[1])
      // 
      // get the set of all exponent vectors for which coefficients must be reconstructed
      exponents:= {op(map(poly2list(g1), op, 2))} union {op(map(poly2list(g2), op, 2))};
      terms:= map(exponents,
      proc(expo)
        local c1, c2;
      begin
        c1:= coeff(g1, expo);
        c2:= coeff(g2, expo);
        [modp((c1 + c2)/2, p)  + I* modp((c1 - c2)/2/roots[1], p), expo]
      end_proc
      );
      g:= poly([op(terms)], op(a, 2..3));
      
       
    if pprod > 1 and degreevec(g) <> degreevec(result) then 
      if _plus(op(degreevec(g))) < _plus(op(degreevec(result))) then
        // discard the previous result
        pprod:= 1;
      else
        // discard g
        next
      end_if   
    end_if;    
    
    
    // combine with known gcd using the Chinese remainder theorem
    // this can again be done coefficientwise
    if pprod = 1 then 
      result:= g;
      resultexponents:= exponents;
    else 
      // for the following exponents, the coefficients must be reconstructed:
      resultexponents:= resultexponents union exponents;
      terms:= map(resultexponents, 
      proc(expo)
        local c1, c2, d1, d2;
      begin
        c1:= Re(coeff(result, expo));
        c2:= Im(coeff(result, expo));
        d1:= Re(coeff(g, expo));
        d2:= Im(coeff(g, expo));
        [numlib::ichrem([c1, d1],[pprod, p]) + I*numlib::ichrem([c2, d2],[pprod, p]), expo]
      end_proc
      );
      result:= poly([op(terms)], op(a, 2..3))
    end_if;  
    pprod:= pprod*p;
    ratresult:= mapcoeffs(result, reconstruct, pprod);
    
  until ratresult <> FAIL and divide(a, ratresult, Exact) <> FAIL and divide(b, ratresult, Exact) <> FAIL end_repeat;
  
  ratresult:= multcoeffs(ratresult, gcd(gca, gcb)/gcd(coeff(ratresult)));

  // normalize the leading coefficient such that it lies in he first quadrant (by applying igcd)
  lca:= numer(lcoeff(ratresult));
  multcoeffs(ratresult, igcd(lca)/lca) 

end_proc: