//    

// kg, 30/07/94 

/*--
gcdlib::udom_gcd -- compute gcd of 2 univariate polynomials over a domain

gcdlib::udom_gcd(p1, p2)

p1,p2 - non-zero univariate polynomials over a domain

--*/

gcdlib::udom_gcd:=
proc(aa, bb)
  local a, b, c, ca, cb, gc, n, m, d, s, h, l, t, DD;
begin
  a:=aa;
  b:=bb; // to avoid warnings
  DD:= op(a,3);

  

  if DD::hasProp(Dom::AlgebraicExtension) = TRUE and
    DD::groundField = Dom::Rational then
    // algebraic number field
    ca:= map(coeff(a), coeff@expr);
    cb:= map(coeff(b), coeff@expr);
    a:= multcoeffs(a, 1/gcd(ca));
    b:= multcoeffs(b, 1/gcd(cb));
    
    /*
    // currently done in dom_gcd
    // special case DD = Q(I)
    if expr(DD::minpoly) = DD::variable^2 + 1 then
      c:= gcdlib::heu_gcd_QI(subs(poly(a, Expr), DD::variable = I),
                             subs(poly(b, Expr), DD::variable = I));
      if c <> FAIL and c <> FALSE then
        return(poly(subs(c, I = DD::variable), op(a, 2..3)))
      end_if  
    end_if;
    */
    if max(degree(a),degree(b)) >= 15 then 
      if max(map((ca, cb), specfunc::abs)) > 10^10 then
        // use Langemyr's algorithm
        return(gcdlib::langemyr(a,b))
      end_if;
    end_if
  end_if;  

  // make polynomials primitive
  c:= content(a);
  a:= mapcoeffs(a, DD::_divide, c);
  gc:= content(b);
  b:= mapcoeffs(b, DD::_divide, gc);
  gc:= DD::gcd(c, gc);
  
  
  
  // subresultant gcd
  n:= degree(a);
  m:= degree(b);
  if n < m then
    t:= a; a:= b; b:= t;
    t:= n; n:= m; m:= t;
  end_if;
  s:= DD::one;
  h:= s;
  l:= s;
  
  while not iszero(b) do
    d:= n - m;
    s:= DD::_mult(l, DD::_power(h, d));
    if ((d mod 2) = 0) then
      s:= DD::_negate(s)
    end_if;
    t:= mapcoeffs(pdivide(a, b, Rem), DD::_divide, s);
    a:= b;
    b:= t;
    n:= m;
    m:= degree(b);
    l:= lcoeff(a);
    case d
      of 0 do
        break;
      of 1 do
        h:= l;
        break;
      otherwise
        h:= DD::_divide(DD::_power(l, d), DD::_power(h, d-1));
    end_case;
  end_while;

  // make result primitive
  c:= content(a);
  if iszero(c) then
    poly(0, op(a, 2..3))
  else
    multcoeffs(mapcoeffs(a, DD::_divide, c), gc)
  end_if
end_proc:

// end of file 
