//      

// kg, 29/06/93 

/*++
polylib::Poly -- creates a domain of kernel polynomials

Poly(X [, R])

X - list of indeterminates
R - (optional) coefficient ring 'Expr', 'IntMod(n)' or domain,
    default is 'Expr'

Poly creates a domain of MuPAD kernel polynomials (CAT_POLY) with
indeterminates 'X' over the coefficient ring 'R'. If no ring is
given, 'Expr' is choosen as ring.

The main application of a domain created by Poly is the recursive
representation of polynomials: A domain created by Poly may be used
as a coefficient ring for kernel polynomials. Expressions like

	poly(x*y, [x], Poly([y]))

may be used to define polynomials which have kernel polynomials as
coefficients, giving rise to a recursive representation of polynomials.
(The internal representation of kernel polynomials is a distributive
one.)
++*/

polylib::Poly:=
proc(X, R=Expr)
  local DOM;
  option escape, remember;
begin
  if testargs() then
    if args(0) < 1 or args(0) > 2 then
      error("wrong no of args")
    end_if;
  end_if;

  DOM:= newDomain(hold(polylib::Poly)(X,R));
  if DOM::zero <> FAIL then return(DOM) end_if;
  
  if domtype(R) = DOM_DOMAIN then
    DOM::zero:= poly(R::zero, X, R);
    DOM::one:= poly(R::one, X, R)
  else
    DOM::zero:= poly(0, X, R);
    DOM::one:= poly(1, X, R)
  end_if;
  DOM::create_dom:= DOM::key;
  DOM::indets:= X;
  DOM::freeIndets:= X;
  DOM::coeffRing:= R;
  DOM::_plus:= _plus;
  DOM::_mult:= _mult;
  DOM::_power:= _power;
  DOM::_negate:= _negate;
  DOM::norm:= norm;
  DOM::_divide:=
  proc(x, y)
    name _divide;
  begin
    divide(x, y, hold(Exact))
  end_proc;
  
  DOM::diff:= diff;
  DOM::intmult:= multcoeffs;
  DOM::expr:= expr;
  DOM::gcd:= gcd;
  DOM::convert:=
  proc(p)
    name convert;
  begin
    poly(p, X, R)
  end_proc;

  DOM::new:= DOM::convert;

  DOM::testtype:=
  proc(x, T)
  begin
    bool(domtype(x) = DOM_POLY and
         op(x, 2) = X and
         op(x, 3) = R)
  end_proc:
  
  DOM
end_proc:

// end of file 
