/*

Reduction of resultants over Z to resultants over Z_p 
By experiment, this proves only useful for univariate polynomials 

The literature recommends to accept a small error probability here. 
However, Hadamard's bound proves to be rather sharp in practice, so there is no need for this.

This is the algorithm called CRES by Collins(1971)

*/

// experiments show that it is good to compute modulo rather big primes
// however, taking p too large, the cost of nextprime(p+1) become prohibitive
// so we use a precomputed list of them


polylib::CRES:=
proc(A: DOM_POLY, B: DOM_POLY, bound)
  local p, pprod, result, result1, i;
begin
  i:= 1;
  p:= numlib::primelist511[1];
  result:= polylib::univariateResultantModP(poly(A, IntMod(p)), poly(B, IntMod(p)));
  pprod:= p;
 
  // we do not call this algorithm in cases where a single prime suffices
  // thus we may as well use a repeat-loop
 
  // loop invariant: result = mods(polylib::resultant(A, B), pprod)
  repeat
    if (i:= i+1) <= nops(numlib::primelist511) then
      p:= numlib::primelist511[i]
    else  
     p:= nextprime(p+1)
   end_if;
   userinfo(30, "Computing modulo ".output::ordinal(i)." prime");
   result1:= polylib::univariateResultantModP(poly(A, IntMod(p)), poly(B, IntMod(p)));
    // connect result and result1 by the Chinese Remainder Theorem
   result:= mods(numlib::ichrem([result, result1], [pprod, p]), pprod*p);
   pprod:= pprod*p
    // since the correct result is between -2^bound and 2^bound, we need pprod >= 2* 2^bound
  until  log(2, float(pprod)) > bound + 1  end_repeat;

  result
end_proc:  

// end of file