polylib::euclideanResultant:=
proc(p, q, x, df)
  local c, b, n, m, h, R, one, d, t, g;
begin
  assert(args(0) = 4);
  
  m:= degree(p);
  n:= degree(q);
  
  // compute contents 
  c:= content(p);
  p:= mapcoeffs(p, _divide, c);
  b:= content(q);
  q:= mapcoeffs(q, _divide, b);
  c:= c^n * b^m;
  
  R:= op(p, 3);
  if domtype(R) = DOM_DOMAIN then
    h:= one:= R::one
  else
    h:= one:= 1
  end_if;  
    
  if R = Expr then
    p:= normal(p);
    q:= normal(q)
  end_if;

  // compute subresultant PRS 
  b:= h;
  g:= h;
  while n > 0 do
    d:= m - n;
    if ((m*n) mod 2) = 1 then b:= -b end_if;
    t:= pdivide(p, q, Rem);
    p:= q;
    q:= t;
    m:= n; // degree(p)
    g:= g*h^d;
    if g <> one then 
      q:= mapcoeffs(q, df, g);
    end_if;  
    n:= degree(q); // degree may have become smaller by normalization (df)
    g:= coeff(p, x, m);
    case d
    of 0 do
      break;
    of 1 do
      h:= g; 
      break;
    otherwise
      h:= df(g^d, h^(d-1)); 
      break;
    end_case;
  end_while;
                        
  assert(degree(q) = 0);                     
  q:= coeff(q, 0);
  if m = 1 then 
    c * b * q
  else
    c * b * df(q^m, h^(m-1))
  end_if
end_proc:

// end of file