polylib::univariateResultant:=
proc(p, q, x, df)
  local n, m, R, coefftypes, vars;
begin
  vars:= op(p, 2);
  R:= op(p, 3);
  m:= degree(p);
  n:= degree(q);
  

  // by coefficient ring: Expr, IntMod, or domain
  if R = hold(Expr) then
    coefftypes:= map({coeff(p), coeff(q)}, domtype);
    if coefftypes minus {DOM_INT, DOM_RAT} = {} then
      polylib::rationalResultant(p, q, x)
    else
      assert(FALSE); // NOT REACHED
      polylib::euclideanResultant(p, q, x, df)   
    end_if  
  elif op(R, 0) = hold(IntMod) then
    if isprime(op(R, 1)) then 
      polylib::univariateResultantModP(p, q, x)
    else
      // IntMod(n) for n not a prime: rather irrelevant. 
      // We could use a more elegant method here. However, this works at least.
      expr(polylib::bezoutResultant(p, q, x))
    end_if  
  else // domains 
    polylib::euclideanResultant(p, q, x, df)
  end_if  
end_proc:

// end of file