/*
   polylib::univariateResultantModP(p, q)

   p, q: univariate polynomials over IntMod(P), P prime

   Modulo primes, we use the natural polynomial remainder sequence (and not the subresultant polynomial remainder sequence)
   This is the algorithm CPRES1 in Collins(1971)

*/
polylib::univariateResultantModP:=
proc(pp: DOM_POLY, qq: DOM_POLY)
  local n, m, c, t, x, p, q, P, old;
begin
  p:=pp; q:=qq;   // to avoid warnings 
  // zero polynomials or 0 degree ? 
  if iszero(p) or iszero(q) then
    return(0)
  end_if;
  m:= degree(p);
  n:= degree(q);
 
  assert(op(pp, [3, 0]) = hold(IntMod));
  P:= op(pp, [3, 1]);
  
  x:= op(p, [2,1]);
  
  c:= 1;

  while n>0 do
    if ((m*n) mod 2) = 1 then 
      c:= -c 
    end_if;
    t:= divide(p, q, Rem);
    p:= q;
    q:= t;
    old:= m;
    m:= n;
    n:= degree(q);
    c:= (c*powermod(lcoeff(p), old-n, P)) mod P
  end_while;
  (c * powermod(coeff(q, 0), m, P)) mod P
end_proc:

// end of file
