polylib::discrim :=
proc(p, x)
  name polylib::discrim;
  local a, d;
begin
  if args(0) <> 2 then error("wrong no of args") end_if;
 
    // allow overloading 
  if p::dom::discrim <> FAIL then
    return( p::dom::discrim(args()) )
  end_if;

  if type(p) <> DOM_POLY then
    d:= degree(p, [x]);
    a:= lcoeff(p, [x])
  else
    if op(p, 2) <> [x] then
      error("Only univariate polynomials allowed")
    end_if;
    d:= degree(p, x);
    a:= lcoeff(p)
  end_if;
  normal( (-1)^(d*(d-1)/2)*polylib::resultant(p, diff(p, x), x)/a )
end_proc:
