//    

// Astrid Wiemeyer, 1997 


/* polylib::horner ( ausdr, var, < p > )

   ausdr - univariate polynomial expression

   var   - expression to substitute for the indeterminate of ausdr 

     p   - polynomial in the same indeterminate as var

   
   if ausdr = f(x) and var = g(y), f(g(y)) mod p(y) is computed and
   returned as a polynomial expression

*/

polylib::horner:=proc(ausdr,var,p)
local i, wert,unb, base_field;
begin
    unb        := op(p,[2,1]);
    base_field := op(p,3);
    var        := poly(var,[unb],base_field);

    if degree(ausdr) > 0 then
       wert := divide(poly(coeff(ausdr,degree(ausdr)),[unb],base_field)\
               *var+poly(coeff(ausdr,degree(ausdr)-1),[unb],base_field),
               p,Rem);
       for i from (degree(ausdr)-2) downto 0 do
          wert := divide(wert*var+poly(coeff(ausdr,i),[unb],base_field),
                  p,Rem);
       end_for;
    else
       wert:=poly(ausdr,[unb],base_field);
    end_if;
    return(expr(wert));
end_proc:
