//    


// polylib::makerat


/* transforms an expression or a list or set of expressions
   into a quotient of polynomials (or simply field elements)
   over a suitable extension of the rationals,

   does not do extensions exceeding maxAlgebraicDegree

   returns:
   - numerator polynomial or field element, or list/set of these
   - denominator polynomial or field element, or list set of these
   - list of substitutions

*/


polylib::makerat:=
proc(l, maxAlgebraicDegree = 1: Type::PosInt, GcdMode = FALSE: DOM_BOOL)
  local
  completeSubs: DOM_PROC,
  F:DOM_DOMAIN,
  R,
  newl:DOM_LIST,
  subst:DOM_LIST,
  revsubst:DOM_LIST,
  i:DOM_INT,
  j:DOM_INT,
  d:DOM_INT,
  eq:"_equal",
  RHS, base, expo,
  X: DOM_IDENT,
  inds:DOM_SET,
  f, linears, 
  alpha;
  
begin
  if args(0) = 0 then
    error("makerat called without args")
  end_if;
  
  // argument checking
  
  case type(l)
    of DOM_POLY do
      if op(l,3)<> hold(Expr) then
        error("Polynomial must have coefficient ring Expr")
      end_if;
      newl:=polylib::makerat(expr(l), maxAlgebraicDegree);
      // reorder indets such that the original indets are in front
      inds:=op(l,2);
      if type(op(newl,1))=DOM_POLY then
        inds:= inds.[op({op(op(op(newl,1),2))} minus {op(inds)})];
        F:=op(newl, [1,3]);
      else // l is a unit
        F:=domtype(op(newl,1))
      end_if;
      return(poly(op(newl,1), inds, F), poly(op(newl, 2), inds, F), op(newl, 3))
    of DOM_LIST do  
    of DOM_SET do
      l:= map(l, 
      proc(X) 
        begin 
          if type(X) = DOM_POLY then
            if op(X, 3) <> Expr then
              error("Polynomials must have coefficient ring Expr")
            end_if;
            op(X, 1)
          elif not testtype(X, Type::Arithmetical) then
            error("List or set of polynomials or arithmetical expressions expected")
          else 
            X
          end_if
        end_proc
        );
        break
    otherwise
      if not testtype(l, Type::Arithmetical) then
        error("Arithmetical expression expected")
      end_if
  end_case;
  
  
  
  
  F:=Dom::Rational;
  [newl, subst]:= [rationalize(l, FindRelations = ["_power", "exp"])]; 
  subst:= [op(subst)];



  inds:=indets(newl, RatExpr);
   // the indets of the poly to be generated
   /* initially, these are all identifiers (both
     the previously existing ones and those generated by rationalize) */

  revsubst:=map(subst, s-> op(s,2)=op(s,1));

  for i from nops(subst) downto 1 do
    // for every substitution, try to regard the right hand side
    // as algebraic over F
    // if this succeeds, extend F; the left hand side of the
    // substitution then represents an algebraic number and
    // can thus be removed from the set of indeterminates
    
    // start from behind, because there are the simplest right hand sides
    // e.g. for nested roots, the inner root comes after the outer
    eq:= op(subst, i);
    X:= op(eq, 1);
    case type((RHS:=op(eq,2)))
    of DOM_COMPLEX do
        if not GcdMode then
          // RHS must be I or -I
          assert(RHS = I or RHS = -I); 
          F:=Dom::AlgebraicExtension(F, poly(X^2+1, [X], F));
          inds:=inds minus {X};
        end_if;  
        break
      of "_power" do
        /* The radicand on the right hand side must be an expression that can
           be turned into a rational expression by applying reverse
           substitutions op(revsubst, i+1..nops(subst)) */
        base:= op(RHS,1);
        expo:=op(RHS, 2);
        if type(expo)<>DOM_RAT or op(expo, 2) > maxAlgebraicDegree then
          // only for rational exponents, the extension is algebraic
          break
        end_if;
        if indets(base) <> {} then
          break
        end_if;
        base:= subs(base, op(revsubst, i+1..nops(revsubst)),EvalChanges);
        base:=F::convert(base);
        if base=FAIL then
          // do not handle function field case, i.e. roots
          // involving indeterminates
          break
        else
          d:=denom(expo);
          // to adjoin: a d-th root of base
          f:= factor(poly([[F::one, d], [-base,0]],[X], F));
          // sort the factors
          f:=(sort([op(f, 2*i) $i=1..nops(%) div 2],
                (u,v)-> degree(u)<=degree(v)));
          // test whether the smallest factor is linear
          [linears, f, j]:= split(f, u-> degree(u)=1);
          if nops(linears) > 0 then
            // some d-th roots are already contained in F. 
            
            // local method completeSubs, performing backSubstitution of all symbols introduced so far
              completeSubs:=
              proc(x)
                local y;
              begin
                repeat 
                  y:= x;
                  x:= subs(x, subst)
                until y=x end_repeat;
                y
              end_proc;
              // out of the polynomials x - alpha, extract the -alpha
              linears:= map(linears, coeff, 0);
              // make -alpha into alpha and convert to expression
              linears:= map(linears, _negate@expr);
              // apply substitutions to get expressions
              // find out which choice of alpha agrees
              // with the choices for roots of previous minimal
              // polynomials
              // since denesting radicals is difficult, just use float
              alpha:= FAIL;
              for j from 1 to nops(linears) do
                if numeric::isnonzero(completeSubs(linears[j] - expr(base)^(1/d))) <> TRUE then
                  alpha:= linears[j];
                  break
                end_if 
              end_for;  
              
              if alpha <> FAIL then
                // root found
                // replace current substitution
                // alpha satisfies alpha^d = base
                // i.e. (with n=numer(expo))
                // alpha^n = base^(n/d) = the original right hand side  
                subst[i]:=(X=expr(alpha)^numer(expo, Expand = TRUE));
                // substitute also in newl
                newl:= subs(newl, X=expr(alpha)^numer(expo, Expand = TRUE), EvalChanges)
              else // all linar factors do not match
                   // this should not happen, as base^(1/d) *is* a root of X^d - base
                   // we handle this by treating base^(1/d) as transcendental ...
                   assert(FALSE);
                   break
              end_if  
          else
            f:=op(f,1);
            // field has to be extended
            F:=Dom::AlgebraicExtension(F, f);
            // no new substitution, but the expression
            // newl must be adjusted
            newl:= subs(newl, X=X^numer(expo, Expand = TRUE), EvalChanges);
            subst[i]:= (X= op(RHS, 1)^(1/d));
          end_if; // linears = [] ?
        end_if; // base = FAIL ?
                   
 
        inds:= inds minus {X}; // X is algebraic
          
      // otherwise, the right hand side is considered
      // transcendental: F need not be extended, and
      // the left hand side remains among the indeterminates  
    end_case
  end_for;

    // if no alg. element was found, the computation can go on
    // over Expr instead of the rationals
  if F=Dom::Rational then
    R:= hold(Expr)
  else
    R:= F
  end_if;
  if nops(inds)>0 then
    if type(l)=DOM_LIST or type(l)=DOM_SET then
      if R = hold(Expr) then
        f:= map(newl, normal, Expand = TRUE, List);
        map(map(f, op, 1), poly, [op(inds)], R),
        map(map(f, op, 2), poly, [op(inds)], R),
        subst
      else
        map(map(newl,numer, Expand = TRUE), poly, [op(inds)], R),
        map(map(newl,denom, Expand = TRUE), poly, [op(inds)], R),
        subst
      end_if
    else
      if R = hold(Expr) then
        f:= normal(newl, Expand = TRUE, List);
        poly(f[1], [op(inds)], R),
        poly(f[2], [op(inds)], R),
        subst
      else
        poly(numer(newl, Expand = TRUE), [op(inds)], R),
        poly(denom(newl, Expand = TRUE), [op(inds)], R),
        subst
      end_if;
    end_if
  else
    if type(l)=DOM_LIST or type(l)=DOM_SET then
      map(newl, F::convert), map(newl, F::one), // not really a function call
      subst
    else
      F(newl), F::one, subst
    end_if
  end_if
end_proc:

