/* 
polylib::minpoly(a,n,x) finds a polynomial of degree n in the unknown x
         with integer coefficients which has one root close to a 
         (up to DIGITS digits)

Examples:
>> polylib::minpoly(PI,3,x);

                                    2       3
                   poly(36 x + 114 x  - 37 x  - 91, [x])

>> float(sqrt(2)+sqrt(3));

                                3.146264369


>> polylib::minpoly(%,4,x);

                               4       2
                         poly(x  - 10 x  + 1, [x])
*/

polylib::minpoly:=
proc(a, n:Type::PosInt, x:DOM_IDENT)
  local i;
begin
  if args(0)<>3 then
    error("expecting three arguments")
  end_if;
  a:=float(a);
  if type(a)<>DOM_FLOAT then
    error("float expected")
  end_if;
  
  lllint([[0$i,1,0$(n-i),round(a^(i-1)*10^DIGITS)]$i=0..n]);
  poly(_plus(%[1][i+1]*x^i$i=0..n))
end_proc:
