/*++
polylib::primpart -- primitive part of polynomial

primpart(p)
primpart(e [,ind])

p   - polynomial
e   - expression
ind - list of indets
++*/

polylib::primpart:=
proc(p)
begin
  if args(0) = 0 then
    error("primpart called without argument")
  end_if;

  if p::dom::primpart <> FAIL then
    return(p::dom::primpart(args()))
  end_if;
  
  case args(0)
    of 1 do
      case domtype(p)
        of DOM_POLY do
          if iszero(p) then
            p
          elif domtype(op(p, 3)) = DOM_DOMAIN then
            mapcoeffs(p, slot(op(p, 3), "_divide"),
                      content(p))
          else
            multcoeffs(p, 1/content(p))
    	    end_if;
          break;
        of DOM_INT do
          sign(p);
          break;
        of DOM_RAT do
          sign(p);
          break;
        of DOM_FAIL do
          FAIL;
          break;
        otherwise
          expr(polylib::primpart(poly(p)))
      end_case;
      break;
    of 2 do
      expr(polylib::primpart(poly(args())));
      break;
    otherwise
      error("wrong no of args")
  end_case
end_proc :

