
/*

refineFactorization(l)

takes a list [a1, n1, .., ak, nk]
where the ai are arithmetical expressions and the ni are integers
denoting an object a = a1^n1 * ... * ak^nk


returns a list of the same format, denoting the same a,
but satisfying in addition gcd(ai, aj) for i \neq j 

*/



polylib::refineFactorization:=
proc(l: DOM_LIST, gcdfunc): DOM_LIST
  local i: DOM_INT,
        j: DOM_INT,
        g,
        normalizeSum: DOM_PROC;
  
  
begin
  if args(0) = 1 then
    gcdfunc:= (x,y) -> gcd(numer(x), numer(y))/ gcd(denom(x), denom(y))
  end_if;
  

  // in exponents, avoid sums like 2*n/(2*n+1) + 1/(2*n+1)
  // but do not normalize in general, allow 1/m + 1/n
  // that is, only factor out *all* common factors of negative power if they are the same
  normalizeSum:=
  proc(a, b)
	local fa, fb, isnegpower, den, num;     
  begin
// tests whether u is a negative power
     isnegpower:=
     proc(u)
     begin
        _lazy_and(type(u) = "_power", stdlib::hasmsign(op(u, 2)))
     end_proc;

     if type(a) = "_mult" then
        fa:= [op(a)]
     else
        fa:= [a]
     end_if;
     if type(b) = "_mult" then
        fb:= [op(b)]
     else
        fb:= [b]
     end_if;
     fa:= split(fa, isnegpower);
     fb:= split(fb, isnegpower);
     if fa[1] = fb[1] then
       den:= _mult(op(fa[1])); // common denominator
       num:= _mult(op(fa[2])) + _mult(op(fb[2])); // numerator
       normal(num*den)
     else
        a+b	
     end_if;
  end_proc;

  
  i:=1;
  while i <= nops(l) - 2 do
    // take care that every j > i satisfies gcd(ai, aj) = 1
    // divide off the gcd if necessary
    j:= i + 2;
    while j < nops(l) and l[i]<>1 do
      g:= gcdfunc(l[i], l[j]);
      if g<>1 then
        l[i]:= normal(l[i]/g);
        l[j]:= normal(l[j]/g);
        l:= l.[g, normalizeSum(l[i+1], l[j+1])];
      end_if;
      j:= j+2    
    end_while;
    i:= i+2
  end_while;

  i:=1;
  while i <= nops(l) do
    if l[i] = 1 then
      // delete l[i] and its multiplicity
      delete l[i]; delete l[i];
      i:= i-2;
    end_if;
    i:= i+2;
  end_while;
  
  l

end_proc:

