//    


// Astrid Wiemeyer, 1997 

/*

  polylib::splitFieldIrreducible(p)

  p - polynomial

  returns a list of

  - the splitting field of p (a Dom::AlgebraicExtension of the
    coefficient field)

  - the roots of p (expressed in terms of the primitive element
      of the splitting field)

*/


polylib::splitFieldIrreducible :=
proc(p)

local mipo, roots, newfactors, newmipo, pos, ende, faktoren, nullst, new_nullst,
      K, K1, i,j,k, ausdr, sgR, f_K, num_fac, ggt, unb, new_s, hpol,az_1, az_2,
      initialp,merker,q,base_field,opt;

begin
   
   base_field := op(p,3);
   if degree(p) = 1 then return([base_field,[-coeff(p,0)]]); end_if;
   
   // Initialisierungen 
   // opt = 1  ====> ggt-Berechnung mit Langemyr 
   // opt = 0  ====> ggt-Berechnung mit Eukl. Algo. 

   if degree(p) > 3 then  
      opt := 1;
      initialp := 10^38;
   else                 
      opt := 0; 
   end_if;

   unb    := genident();  
   nullst := op(p,[2,1]);
   K      := Dom::AlgebraicExtension(base_field, p, nullst);
   az_2   := nullst;
   ausdr  := subs(op(p,1),nullst=unb);

   if degree(p) = 2 then
     p        := poly(ausdr,[unb],K);
     q        := poly(unb-nullst,[unb],K);
     faktoren := divide(p,q,hold(Exact));
     if faktoren = FAIL then
        error("Division failed");
     end_if;
     roots    := [nullst,K::expr(-coeff(faktoren,0))];
     K        := Dom::AlgebraicExtension(base_field,ausdr,unb);
     roots    := subs(roots,nullst=unb);
     return([K,roots]);
   end_if;

   p      := poly(ausdr,[unb],base_field);
   mipo   := p;
   newmipo:= p;
   pos    := 1;
   roots  := [];
   faktoren := [subsop(p, 3=K)];
   ende   := FALSE;

   // Verarbeitung solange, bis p vollstaendig in Linearfaktoren zerfaellt 

   while ende = FALSE do
     ende := TRUE;

     //Linearfaktor abspalten 

     faktoren[pos] := divide(faktoren[pos],poly(unb-K::expr(az_2),[unb],K),\
                      hold(Exact));
     if faktoren[pos] = FAIL then
        error("Division failed");
     end_if;

     roots      := roots.[K::expr(az_2)];
     if degree(faktoren[pos]) = 1 then
        roots   := roots.[-K::expr(coeff(faktoren[pos],0))];
        delete faktoren[pos] ;
     end_if;
     newfactors := [];
     k          := 1;

     // alle Faktoren durchlaufen 

     for i from 1 to nops(faktoren) do
       sgR     := polylib::sqrfreeNorm(faktoren[i],K);

       userinfo(10, "Factoring over extension field");

       f_K     := factor(sgR[3]);   // Faktorisierung ueber E 
       f_K     := Factored::convert_to(f_K,DOM_LIST);
       num_fac := (nops(f_K)-1)/2;

       userinfo(10, "Number of factors: ".expr2text(num_fac));

       // Die Faktorisierung lieferte nur einen Faktor

       if num_fac = 1 then
         if degree(f_K[2]) > degree(newmipo) then
            newmipo := f_K[2];
            pos     := k;
            new_s   := sgR[1];
            hpol    := sgR[2];
         end_if;
         newfactors := newfactors.[faktoren[i]];
         ende       := FALSE;
         k          := k + 1;
       else  

         // alle Linearfaktoren in E(nullst) bestimmen 

         for j from 1 to num_fac do
            sgR[2]   := poly(op(sgR[2],1),[unb],K);
            f_K[2*j] := subsop(f_K[2*j],3=K);

	    userinfo(10, "Computing gcd");

            if opt = 0 then
               ggt := gcd(sgR[2],f_K[2*j]);
            else
               ggt := gcdlib::langemyr(sgR[2],f_K[2*j],initialp);
            end_if;
          
            if degree(f_K[2*j]) > degree(newmipo) then
               newmipo := f_K[2*j];
               pos     := k;
               new_s   := sgR[1];
               hpol    := ggt;
            end_if;
         
            sgR[2] := divide (sgR[2],ggt,hold(Exact));
         
            if sgR[2] = FAIL then
               error ("Division failed")
            end_if;
       
            // Lineare Substitution rueckgaengig machen 
            ausdr := subs(op(ggt,1), unb=unb+sgR[1]*K::expr(nullst));
            ggt   := subsop(ggt,1=ausdr);

            if degree(ggt) = 1 then  // Faktorisierung lieferte Linearfaktor 
	       userinfo(15, "Root found");
               roots := roots.[K::expr(K(-1)*K(tcoeff(ggt)))];
            else
               newfactors := newfactors.[ggt];
               ende       := FALSE;
               k          := k + 1;
            end_if;
          
         end_for;
       end_if;
     end_for;
     
     
     if ende = FALSE then
        new_nullst := genident();
        ausdr      := subs(op(newmipo,1),unb=new_nullst); 
        newmipo    := poly(ausdr,[new_nullst],base_field);
        K1         := Dom::AlgebraicExtension(base_field,newmipo,new_nullst);
        mipo       := subsop(mipo,3=K1);
        ausdr      := subs(op(hpol,1),unb=K1::expr(new_nullst));
        ausdr      := subs(ausdr,K::expr(nullst)=unb);
        hpol       := poly(ausdr,[unb],K1);
        
        if opt = 0 then
           ggt  := gcd(mipo,hpol);
        else
           ggt  := gcdlib::langemyr(mipo,hpol,initialp);
        end_if;

        az_1       := -tcoeff(ggt);
        az_2       := K1(new_nullst)-K1(new_s)*az_1; 
        roots:=map(roots,polylib::horner,K1::expr(az_1),newmipo);
      
        for i from 1 to nops(newfactors) do
	  merker:=mapcoeffs(poly(expr(newfactors[i]),[unb],polylib::Poly([nullst],Expr)),
	       	u-> polylib::horner(u,K1::expr(az_1),newmipo));
           newfactors[i]:=poly(expr(merker),[unb],K1);
        end_for;
        
        faktoren := newfactors;
        mipo     := newmipo;
        ausdr    := subs(op(mipo,1),K1::expr(new_nullst)=unb);
        mipo     := poly(ausdr,[unb],base_field);
        nullst   := new_nullst;
        K        := K1;

	userinfo(10, "Current extension is: ".expr2text(K));

     end_if;
   end_while;
   
   return([K,roots]);   
end_proc:
