//    

// Astrid Wiemeyer, 1997 


/*

    polylib::sqrfreeNorm(p)

    p - polynomial over AlgebraicExtension


    With K(alpha) being the coefficient field of p=p(X), some integer s
    is computed such that the norm of p(X-s*alpha) is squarefree.

    The result is a list consisting of

    - the integer s
    - the substituted polynomial p(x-s*alpha)
    - the norm (product of conjugates) of the latter


*/


polylib::sqrfreeNorm :=
proc(p)

local erzp,ausdr,unb,az,s,ende,con_norm,abl,base_field, K;

begin
   userinfo(4, "Squarefree norm called for ".expr2text(p));
   K          := op(p,3);

   base_field := K::groundField;
   erzp       := K::minpoly;
   az         := K::variable;
   unb        := op(p,[2,1]);
   
   erzp       := subsop(erzp,2=[unb,az],3=base_field);
      p       := subsop(p,2=[unb,az],3=base_field);

   s    := 0;
   ende := FALSE;

   repeat 
     userinfo(10, "Trying s=".expr2text(s));
     con_norm := polylib::resultant(erzp,p,az);
     abl      := D(con_norm);
     if (degree(gcd(con_norm,abl)) = 0) then
        ende  := TRUE;
     else
        s     := s+1;
        ausdr := subs(op(p,1),unb=unb-az);
        p     := poly(ausdr,[unb,az],base_field);
     end_if;
   until ende = TRUE end_repeat;
   return([s,p,con_norm]);
end_proc:

