proc()
  option escape;
  local _autoExpansionLimit;
begin
  Pref::autoExpansionLimit := funcenv(
    proc(n)
      local r;
    begin
      case args(0)
        of 0 do
          return(_autoExpansionLimit)
        of 1 do
          if args(1) = NIL then // set default value
            r := _autoExpansionLimit;
            _autoExpansionLimit:= Pref::autoExpansionLimit::default;
            return(r);
          elif (not testtype(n, Type::Real)) or n <= 0 then
            error("expecting a positive real value");
          else
            r := _autoExpansionLimit;
            _autoExpansionLimit:= n;
            return(r);
          end_if
        otherwise
          error("wrong no of arguments. Expecting a real value or NIL)")
        end_case
    end_proc);
  Pref::autoExpansionLimit::info :=
    "Sets the largest integer n such that gamma(n), bernoulli(n) etc. return an explicit numerical value.":
  Pref::autoExpansionLimit::default := 1000:
  _autoExpansionLimit:= Pref::autoExpansionLimit::default:
end_proc():

// end of file 
