/*
 
 
 Pref::autoPlot -- automatically plot graphical objects
                   instead of printing them to the screen.
                   (Typesetting only)
 
*/

proc()
  option escape;
  local status;
begin
  status := FALSE; // by default, behave as 3.0 did
  Pref::autoPlot := funcenv(
    proc(n)
      local r;
    begin
      case args(0) 
        of 0 do
          return(status)
        of 1 do
          if args(1) = NIL then // set default value 
            r := status;
            status := FALSE;
            return(r);
          elif domtype(n) <> DOM_BOOL or n = UNKNOWN then
            error("expecting TRUE or FALSE");
          else
            r := status;
            status := n;
            return(r);
          end_if
        otherwise
          error("wrong number of arguments (expecting TRUE or FALSE)")
        end_case
    end_proc);
  Pref::autoPlot::info := "Automatically plot graphical objects instead of typesetting";
end_proc():

// end of file 
