Pref::floatFormat:=
  funcenv(
           proc(s)
             local oldval, outdec;
           begin
             case args(0)
               of 0 do
                 return(_pref(hold(FloatFormat)))
               of 1 do
                 if args(1) = NIL then // set default value 
                   _pref(hold(SwitchFloatFormat) = 0);
                   s:= _pref(hold(FloatFormat));
                   _pref(hold(FloatFormat) = "g");
                   return(s)
                 elif not contains({"f", "e", "g", "h", "x"}, s) then
                   error("argument must either be \"f\", \"e\", \"g\", \"h\" or \"x\"")
                 else
                   oldval := _pref(hold(FloatFormat));
                   _pref(hold(FloatFormat) = _if(s = "x", "h", s));
                   return(oldval)
                 end_if
               of 2 do
                 outdec := args(2);
                 if domtype(outdec) <> DOM_INT or outdec < 0 or outdec > 2^31 then
                   error("second argument (number of output digits) out of range");
                 end_if;
                 _pref(hold(SwitchFloatFormat)=outdec);
                 return(Pref::floatFormat(s));
             otherwise
               error("wrong number of arguments (expecting \"f\", \"e\", \"g\", \"h\" or \"x\")")
             end_case
           end_proc):

Pref::floatFormat::info := "Controls the output of objects of type DOM_FLOAT.":
Pref::floatFormat::default := "g":