// 

// bij 2002/2003
// analyzes the MuPAD library
//
// !! this short docu must be updated !!
// Defines(filename)   list all objects directly defined in 'filename'
// Contains()
// Find()
// Depends(object)     all (direct) static dependencies
// Loads(object)
// Defines(object)
// Loadprocs(object)
// 
// Files:        list (all) files and inside defined objects
// Objects:      list files where (all) objects are defined
//               -> list additionally defined objects
// Depends:      all static dependencies of
//               - given objetcs
//               - objects defined in files
// Status:       status information about loadprocs/read files

alias(loadProc = stdlib::LoadProc):

prog::analyze:=
  proc(OBJECT)
    local OPT, FirstRead, TC, k, CNTpre, CNTpost,
          // procedures
          check, contain, depends, files, find, loadprocs, makelib, objects, status;
    option hold;
    save shell;
  begin
    // definition of the local methods

    // checks, whether loadproc is pathed for analyzing
    check:=
      proc()
        option noDebug;
        local k;
      begin
        if not _and(contains(stdlib::LoadProc, k)
                    $ k in {"readCounter", "loadCounter", "readTable", "loadTable"}) then
          error("loadproc must be patched, call mupad with -U \"ANALYZE\"")
        end_if;
      end_proc:
    
  
    // list files where (all) objects are defined
    // -> list additionally defined objects
    objects:=
      proc(OPT = hold(None))
      begin
        fprint(Unquoted, 0, "\nObjects, that are defined ", "_" $ TEXTWIDTH - 24);
        output::tableForm(map([op(select(loadProc::readTable,
                                         X -> op(X, [2, 3]) > CNTpre[3] and op(X, [2, 3]) <= CNTpost[3]))],
                              X -> prog::getname(op(X, 1))));
                          //Sort = ((X,Y) -> op(X, [2, 3]) <= op(Y, [2, 3]))/*, Output = prog::Out*/);
        fprint(Unquoted, 0, "Number of objects: ", CNTpost[3] - CNTpre[3]);
      end_proc;
  
    // list all objects, that are created as loadproc when given obj is evaluated
    // -> list additionally defined objects
    loadprocs:=
      proc()
      begin
        fprint(Unquoted, 0, "\nLoadprocs, that are defined ", "_" $ TEXTWIDTH - 28);
        output::tableForm(map([op(select(loadProc::loadTable,
                                         X -> op(X, [2, 3]) > CNTpre[1] and op(X, [2, 3]) <= CNTpost[1]))],
                              X -> prog::getname(op(X, 1))));
                          //Sort = ((X,Y) -> op(X, [2, 3]) <= op(Y, [2, 3]))/*, Output = prog::Out*/);
        fprint(Unquoted, 0, "Number of loadprocs: ", CNTpost[1] - CNTpre[1]);
      end_proc:
    
    // list all files, that are read, when object is evaluated
    files:=
      proc()
      begin
        fprint(Unquoted, 0, "\nFiles, that are read ", "_" $ TEXTWIDTH - 21);
        output::tableForm(map([op(select(loadProc::fileTable,
                                         X -> op(X, [2, 1]) > CNTpre[2] and op(X, [2, 1]) <= CNTpost[2]))],
                               X -> op(X, 1).".mu"));
                          //Sort = ((X,Y) -> op(X, [2, 1]) <= op(Y, [2, 1]));
        fprint(Unquoted, 0, "Number of files: ", CNTpost[2] - CNTpre[2]);
      end_proc:
    
    // list all objects defined inside of the given file
    // only directly assigned objects are returned!
    contain:=
      proc(files)
        //option /*hold,*/ noDebug;
        local file, obj, n, OPT, t;
      begin
        OPT := prog::getOptions(2, [args()], table(hold(Return) = FALSE), TRUE,
                                table(hold(Return)=DOM_BOOL));
        obj := table();
        for n in LIBPATH do
          file := prog::checkFile(n.files, Read, Quiet);
          if file <> FAIL then
            break
          end_if
        end_for;
        if file = FAIL then
          error("cannot open file '".prog::getname(n.files)."'")
        end_if;
    //fprint(0, "file: ", files);
        while (n := finput(file)) <> null() do
    //fprint(0, "line: ", n);
          if op(n, 0) = hold(_assign) or op(n, 0) = hold(Sysassign) // don't evaluate line
             /*type(n) = "_assign" or type(n) = "sysassign"*/ then
    //fprint(0, "obj : ",      op(n, 1) );
    //fprint(0, "type: ", type(op(n, 2)));
            if (t := type(op(n, 2))) = "function" then
              t := prog::getname(op(n, [2, 0]))
            end_if;
            if contains(obj, op(n, 1)) then
              obj[op(n, 1)] := append(obj[op(n, 1)], t)
            else
              obj[op(n, 1)] := [t]
            end_if
            // List : obj := append(obj, [expr2text(op(n, 1)), type(op(n, 2))])
          else
            //fprint(Unquoted, 0, "read ", n, " [", type(n), "]")
          end_if
        end_while;
        fclose(file);
        if OPT[hold(Return)] then
          return(obj)
        else
          fprint(Unquoted, prog::OUT, expr2text(nops(obj))." objects defined in ", files);
          output::tableForm(obj, Output = prog::OUT)
        end_if
      end_proc:
    
    // find the file, where the given object is defined in
    // objects must be given unevaluated
    find:=
      proc()
        local OBJ, n, ret;
      begin
        prog::init(OBJECT);
        OBJ := context(OBJECT);
        for n in loadProc::fileTable do
    //fprint(Unquoted, 0, "is ", expr2text(obj), " in ", {prog::analyze::Files(op(n, 1).".mu", hold(Return))});
          if contains((ret := contain(op(n, 1).".mu", hold(Return))), OBJ)
             /*or contains(map(ret, prog::getname), obj)*/ then
            fprint(Unquoted, prog::OUT, "Object '", expr2text(OBJ), "' defined in file '", op(n, 1), ".mu'",
                   " [type '", op(ret[OBJ]), "']")
          elif contains((ret := contain(op(n, 1).".mu", hold(Return))), OBJECT) then
            fprint(Unquoted, prog::OUT, "Object '", expr2text(OBJECT), "' defined in file '", op(n, 1), ".mu'",
                   " [type '", op(ret[OBJECT]), "']")
          end_if
        end_for;
        null()
      end_proc:
    
    // returns number of loadprocs/loaded files
    status:=
      proc(obj)
        option noDebug;
      begin
        if args(0) = 0 then
          output::tableForm(table("Loadprocs"  = loadProc::loadCounter,
                                  "Read Files" = loadProc::readCounter), ": ",
                            Unquoted, Output = prog::OUT)
        else
          // status of an object
          if contains(loadProc::loadTable, obj) then
            fprint(Unquoted, prog::OUT, prog::getname(obj), " is defined")
          end_if;
          if contains(loadProc::readTable, obj) then
            fprint(Unquoted, prog::OUT, prog::getname(obj), " is read")
          end_if;
        end_if;
        null()
      end_proc:
    
    // // initialize all objects; write out all object names into given file
    // // loadproc must be patched
    // // WriteAllObjects:=
    //   proc()
    //   begin
    //     prog::allFunctions(Domain, Recursive, DB)
    //   end_proc:
    // 
    // // initialize all objects; write out all object names into given file
    // // loadproc must be patched
    // AllFiles:=
    //   proc(OPT = hold(None))
    //     local Ret;
    //   begin
    //     //FILE:= prog::checkFile(FILE, hold(Write));
    //     
    //     //warning("Reading all MuPAD objects, this may take a while...");
    //     prog::init(All, All);
    //     prog::init(All, All);
    //     //Ret:= anames(All);
    //     
    // 
    //     if OPT = hold(Files) then
    //       return(map(stdlib::LoadProc::fileTable, op, 1))
    //     end_if;
    //     
    //   end_proc:
    
    // // list all libraries, that are used in code of object
    // Libraries:=
    //   proc(obj)
    //   begin
    //     Depends(obj, DOM_DOMAIN)
    //   end_proc:
    // 
    // // list all functions, that are used in code of object
    // Functions:=
    //   proc(obj)
    //   begin
    //     Depends(obj, Type::Function)
    //   end_proc:
    // 
    // // list all slot names, that are used in code of object
    // Slots:=
    //   proc(obj)
    //   begin
    //     Depends(obj, "slot", X -> op(obj, X.[2]))
    //   end_proc:
    
    depends:=
      proc(obj, TYPE = hold(All), FUNC = FAIL)
      begin
        if FUNC = FAIL then
          FUNC := (X -> if testtype(X, Type::ListOf(Type::PosInt)) then op(obj, X) else null() end)
        end_if;
        obj := prog::init(obj);
    
        case domtype(obj)
          of DOM_DOMAIN do
            _union(depends(slot(obj, k), TYPE, FUNC) $ k in map(op(obj), op, 1));
            break
          of DOM_FUNC_ENV do
            // !!!! schon prog::find??
            _union(depends(op(obj, k), TYPE, FUNC) $ k = 1..3);
            break
          of DOM_PROC do
          otherwise
            {map(prog::find(obj, TYPE, Type), FUNC)}
        end_case
      end_proc:
    
    // Output:=
    //   proc()
    //     local ind;
    //   begin
    //     // if (ind := strmatch(_pref(hold(UserOptions)), "", hold(Index))) <> FALSE then
    //     //   prog::OUT := prog::checkFile(substring(_pref(hold(UserOptions)), (ind[1] + 7)..ind[2]),
    //     //                                          hold(Append))
    //     // else
    //     //   prog::OUT := 0
    //     // end_if
    //   end_proc:
    
    
    FirstRead:=
      [["", "sysinit"],
       ["STDLIB", "read"],
       ["STDLIB", "alias"],
       ["STDLIB", "unalias"],
       ["STDLIB", "pathname"],
       ["STDLIB", "loadproc"],
       ["LIBFILES", "stdlib"],
       ["LIBFILES", "specfunc"],
       ["LIBFILES", "dom_interval"]]:
    
    // create a specialized library from given objects/testfile
    // ARGS: OBJECT - an object, a list of objects or function calls (reading a testfile)
    //       PATH   - path for writing the new library (permissions must be right)
    // 
    makelib:=
      proc(PATH)
        local k, FILES, IN, OUT, LINE, mkdir, dirs, SEP, Y, UNLOAD;
      begin
        if domtype(PATH) <> DOM_STRING then
          error("please specify a path as string with option 'Path'")
        end_if;
    
        if domtype(shell) <> DOM_DOMAIN then
          module("shell"); // to create directories
          UNLOAD := () -> unloadmod("shell")
        else
          UNLOAD := id
        end_if;
        
        // create directories
        mkdir :=
          proc(DIR)
          begin
            // extract all dirs from filename
            DIR := stringlib::split(DIR, SEP);
            // remove the last string - the file name
            DIR := [op(DIR, 1..nops(DIR)-1)];
            if sysname() = "UNIX" then // error inside module shell
              (if not shell::exist(pathname(op(dirs), op(DIR, 1..k))) and
                  traperror(system("mkdir ".pathname(op(dirs), op(DIR, 1..k)))) = 0 then
                 fprint(Unquoted, 0, "Info: creating directory ",
                        expr2text(pathname(op(dirs), op(DIR, 1..k))))
               elif shell::exist(pathname(op(dirs), op(DIR, 1..k))) = FALSE then
                 UNLOAD();
                 error("cannot create directory ".expr2text(pathname(op(dirs), op(DIR, 1..k))))
               end_if) $ k = 1..nops(DIR)
            else
              (if shell::makeDir(pathname(op(dirs), op(DIR, 1..k))) = TRUE then
                 fprint(Unquoted, 0, "Info: creating directory ",
                        expr2text(pathname(op(dirs), op(DIR, 1..k))))
               elif shell::exist(pathname(op(dirs), op(DIR, 1..k))) = FALSE then
                 UNLOAD();
                 error("cannot create directory ".expr2text(pathname(op(dirs), op(DIR, 1..k))))
               end_if) $ k = 1..nops(DIR)
            end_if
          end_proc;
        
        // keep state
    
        // initialize the content output 
        if sysname() = "MSDOS" then MathContent(sin(hold(x))) end_if;
        // evaluate state after evaluating object
        //FILES := sort(map([op(stdlib::LoadProc::fileTable)], op, 1));
        // append file, that are read in sysinit.mu
        FILES := [map(op(loadProc::fileTable), X -> [op(X, 1), op(X, [2, 2])]),
                      op(map(FirstRead,
                             X -> [pathname(X[1]).X[2], stdlib::LIBPATH.pathname(X[1]).X[2].".mu"]))];
        
        SEP := pathname("");
        dirs := [];
        // first create new path, when non existing
        mkdir(PATH."/"); // last part is removed
        // for creating dirs
        dirs := stringlib::split(PATH, SEP);
        // read/write all files to path
        for k in FILES do
          fprint(Unquoted, 0, "Info: Write file '", k[1].".mu", "' to [", PATH, "]");
          // input - k[2] contains the whole file name with path and extension
          if traperror((IN := fopen(k[2]))) <> 0 or IN = FAIL then
            fprint(Unquoted, 0, "cannot open library file ".expr2text(k[2]));
            next
          end_if;
          // output - k[1] contains the relative path with base file name
          if traperror((OUT := fopen(Text, PATH.SEP.k[1].".mu", Write))) <> 0
             or OUT = FAIL then
            // create directories
            mkdir(k[1]);
            k := PATH.SEP.k[1].".mu";
            if traperror((OUT := fopen(Text, k, Write))) <> 0
               or OUT = FAIL then
              UNLOAD();
              error("cannot open output file ".expr2text(k))
            end_if
          end_if;
          //
          while (LINE := ftextinput(IN)) <> null() do
            if k[1] = "STDLIB/loadproc"
               and traperror((Y := strmatch(LINE, "error\\(\"can't read file "))) = 0
               and Y <> FALSE then
              fprint(Unquoted, OUT, "        error(\"this feature is not available in this special library\")")
            else
              fprint(Unquoted, OUT, LINE)
            end_if
          end_while;
          fclose(IN);
          fclose(OUT)
        end_for;
        
        UNLOAD()
      end_proc;
  
      //////////////////////////////////////////////////////////////////////
      //////////////////////////////////////////////////////////////////////
      
    check(); // check whether loadproc is patched
    
    OPT:= prog::getOptions(2, context([args()]),
                           table(hold(Check) = TRUE,
                                 hold(Contains) = FALSE,
                                 hold(Depends) = FALSE,
                                 hold(Files) = FALSE,
                                 hold(Find) = FALSE,
                                 hold(Loadprocs) = FALSE,
                                 hold(MakeLib) = FALSE,
                                 hold(Objects) = FALSE,
                                 hold(Status) = FALSE,
                                 hold(All) = FALSE,
                                 hold(Path) = FAIL))[1];

    // always check, whether loadproc is patched
    check();

    if OPT[hold(Status)] <> FALSE or args(0) = 0 then
      status();
    end_if;

    // must be enabled, because some procedures are used only when testargs is TRUE
    TC := Pref::typeCheck(Always), testargs(TRUE);
    
    // all other procedures needs to evaluate the first given object
    if OPT[hold(All)] = FALSE then
      CNTpre := [loadProc::loadCounter, loadProc::fileCounter, loadProc::readCounter]
    else
      CNTpre := [0, 0, 0]
    end_if;

    context(OBJECT);

    CNTpost := [loadProc::loadCounter, loadProc::fileCounter, loadProc::readCounter];

    if OPT[hold(Find)] <> FALSE then
      find()
    end_if;
    
    if OPT[hold(Files)] <> FALSE then
      files()
    end_if;
    
    if OPT[hold(Loadprocs)] <> FALSE then
      loadprocs()
    end_if;
    
    if OPT[hold(Objects)] <> FALSE then
      objects()
    end_if;
    
    if OPT[hold(MakeLib)] <> FALSE then
      makelib(OPT[hold(Path)]) // second argument is the path
    end_if;

    Pref::typeCheck(op(TC, 1)), testargs(op(TC, 2));
    null()
    
  end_proc:
