//      

// statement, < Options, ... >
//   MaxDepth
//   Args
//   Tree
//   Exclude

prog::calltree:=
  proc(STMT)
    option hold, escape;
    save GPROF; // identifier for profile file
    local OPT, file, result, ERROR, S, TREE, INDEX, STACKDEPTH, EXCLUDE;
  begin

    if args(0) = 0 then
       return();
    end_if;

    //-------------------- Argumente ---------------------

    OPT := prog::getOptions(2, [FAIL, context(args(2..args(0)))],
                            table(hold(MaxDepth) = infinity,
                                  hold(Args) = FALSE,
                                  hold(Tree) = FALSE,
                                  hold(Exclude) = {}))[1];

    OPT[hold(Exclude)] := OPT[hold(Exclude)] union
                          {/*, "loadproc", "stdlib::syseval", "pathname"*/};
    

    //------------------ Hauptprogramm -------------------

    // eval stmt and create gprof file
    
    file := "call".getpid().".dat";
    if sysname() = "UNIX" then
      file := "/tmp/".file
    else
      if domtype(WRITEPATH) = DOM_STRING then
        file := WRITEPATH.pathname("").file
      end_if
    end_if;

    // call kernel profiler
    delete GPROF;
    if OPT[hold(Args)] then
      ERROR := traperror((result := stdlib::gprof(context(STMT), file, Args, GPROF)));
    else
      ERROR := traperror((result := stdlib::gprof(context(STMT), file, GPROF)));
    end_if;

    fprint(Unquoted, 0, "Create tree ...");

    // Domain for output
    S := newDomain("output".genident("T"));
    S::info := "domain for calltree output";
    S::new := () -> new(S, args());
    S::print := proc(s, ARGS = OPT[hold(Args)]) // determines the out of one tree node
                begin
                  if nops(s) > 3 then
                    "exits with ".stringlib::lower(expr2text(op(s, 4)))
                  elif ARGS then
                    prog::getname(op(s, 2))
                  else
                    prog::getname(op(s, 1))
                  end_if
                end_proc;

    //+TREE := [S("ROOT", STMT, op(bytes(), 1)), FAIL];
    TREE := FAIL;
    INDEX := [1];

    STACKDEPTH := 0;
    EXCLUDE := infinity;

    GPROF :=
      proc(TYP, NAME, TIME, ARGS, MEM = 0)
        option hold;
      begin
        case TYP
          of 0 do // can be removed
            break
          of 1 do // procedure BODY entry
            STACKDEPTH := STACKDEPTH + 1;
            if STACKDEPTH > EXCLUDE or STACKDEPTH > OPT[hold(MaxDepth)] then
              // do nothing 
            elif contains(OPT[hold(Exclude)], prog::getname(NAME)) then
              EXCLUDE := STACKDEPTH;
              TREE := subsop(TREE, INDEX = ([S("...", "", MEM), FAIL], FAIL));
              INDEX := append(INDEX, 2)
            elif STACKDEPTH = OPT[hold(MaxDepth)] then
              // cut tree
              TREE := subsop(TREE, INDEX = ([S("...", "", MEM), FAIL], FAIL));
              INDEX := append(INDEX, 2)
            else
              TREE := subsop(TREE, INDEX = ([S(NAME, ARGS, MEM), FAIL], FAIL));
              INDEX := append(INDEX, 2)
            end_if;
            break
          of 2 do // normal procedure exit
          of 3 do // remember procedure exit
          of 4 do // abnormal procedure exit/error
            STACKDEPTH := STACKDEPTH - 1;
            if STACKDEPTH >= EXCLUDE or STACKDEPTH >= OPT[hold(MaxDepth)] then
              // do nothing
            //elif contains(OPT[hold(Exclude)], prog::getname(NAME))
            //     and EXCLUDE = STACKDEPTH then
            //  EXCLUDE := 0; // end exclusion
            else
              EXCLUDE := infinity; // end exclusion
              TREE := subsop(TREE, INDEX = op([#placeholder,
                                               S(NAME, FAIL, MEM, hold(Remember)),
                                               S(NAME, FAIL, MEM, hold(Error))], TYP - 1));
              INDEX := [op(INDEX, 1..nops(INDEX)-2), op(INDEX, nops(INDEX) - 1) + 1];
            end_if;
            break
          otherwise
            error("wrong type in kernel profiling file")
        end_case;
        TREE := eval(TREE);
      end_proc;


    // read the profile file and evaluate GPROF
    read(file);
    TREE := subs(TREE, #placeholder=null());
    
    // remove temporary file
    stdlib::gprof(NIL, file);

    if type(TREE) <> DOM_LIST then // argument evaluation before function call
      TREE := map([op(TREE)], op)
    end_if;

    if OPT[hold(Tree)] then
      adt::Tree(subs(TREE, FAIL = null(),EvalChanges))
    else
      print(stdlib::Exposed(output::tree(subs(TREE, FAIL = null(),EvalChanges))));
      if ERROR = 0 then
        result
      end_if // else NIL
    end_if
    
  end_proc:
