alias(LOCAL(XXX) = (if prog::OPT[hold(Local)] or prog::OPT[hold(Localf)] then XXX end)):
alias(ASSIGN(XXX) = (if prog::OPT[hold(Assign)] then XXX end)):
alias(GLOBAL(XXX) = (if prog::OPT[hold(Global)] then XXX end)):
alias(DOMENT(XXX) = (if prog::OPT[hold(Domain)] then XXX end)):
alias(SLOT(XXX) = (if prog::OPT[hold(Slot)] then XXX end)):
alias(LEV(XXX) = (if prog::OPT[hold(Level)] then XXX end)):
alias(ENV(XXX) = (if prog::OPT[hold(Environment)] then XXX end)):
alias(SPEC(XXX) = (if prog::OPT[hold(Special)] then XXX end)):
alias(PROT(XXX) = (if prog::OPT[hold(Protect)] then XXX end)):
alias(ESC(XXX) = (if prog::OPT[hold(Escape)] then XXX end)):
alias(COMP(XXX) = (if prog::OPT[hold(Changes)] then XXX end)):
alias(INTERFACE(XXX) = (if prog::OPT[hold(Interface)] then XXX end)):
alias(DEPENDS(XXX) = (if prog::OPT[hold(Depends)] <> FALSE then XXX end)):
alias(FIND(XXX) = (if prog::OPT[hold(Find)] <> FALSE then XXX end)):

// prog::OPT
// 0: Global
// 1:
// 2: Local (unused local variables)
// 3:
// 4:
// 5: Level (level(DOM_VAR))
// 6: Assign (assignment to formal parameters)
// 7:
// 8:
// 9:


prog::check:=
  proc(FUN = hold(All), uinf = 1)
    local GF, DF, INP, OPT, TODO, DONE, allOptions;
    save MAXDEPTH;
  begin
    // options
    allOptions := table(hold(Local) = TRUE,
                        hold(Localf) = FALSE,
                        hold(Assign = FALSE),
                        hold(Global) = TRUE,
                        hold(Save) = TRUE,  // -> Global
                        hold(Domain) = TRUE,
                        hold(Slot) = FALSE, // "refered slot..."
                        hold(Interface) = TRUE,
                        hold(Level) = TRUE,
                        hold(Environment) = FALSE,
                        hold(Special) = FALSE,
                        hold(Protect) = TRUE,
                        hold(Escape) = FALSE,
                        hold(Changes) = FALSE,
                        hold(All) = FALSE,     // all options until here
                        hold(Depends) = FALSE, // Werte: FALSE TRUE 'All'
                        hold(SimplifyDep) = TRUE, // Werte: FALSE TRUE Domains
                        hold(Find) = FALSE,    // Werte: FALSE Object
                        hold(Output) = FALSE):// Werte: FALSE, Table (Tabelle)
    OPT := prog::getOptions(2, [args()], allOptions, FALSE)[1];

    if OPT[hold(All)] = TRUE then
      // switch on all options except for some
      OPT := table(map(op(allOptions), X -> if not contains({hold(Depends), hold(SimplifyDep),
                                                             hold(Find), hold(Output),
                                                             hold(Changes)}, op(X, 1)) then
                                              op(X, 1) = TRUE
                                            else
                                              X // keep
                                            end_if))
    elif OPT[hold(Depends)] <> FALSE then
      // switch on all options except for some
      OPT := table(map(op(allOptions), X -> if not contains({hold(Depends), hold(SimplifyDep),
                                                             hold(Find), hold(Output)}, op(X, 1)) then
                                              op(X, 1) = FALSE
                                            else
                                              X // keep
                                            end_if))
    elif args(0) > 2 or args(0) > 1 and domtype(uinf) <> DOM_INT then
      // special case - option defined per hand, all default options "off"
      // switch off all options, that are not given explicitely
      OPT := table(map(op(allOptions), X -> op(X, 1) = FALSE),
                   map(select(args(2..args(0)), X -> type(X) = "_equal" or type(X) = DOM_IDENT),
                       X -> if type(X) = "_equal" then
                              if contains(allOptions, op(X, 1)) then
                                X
                              else
                                null()
                              end_if
                            else
                              if contains(allOptions, X) then
                                X = TRUE
                              else
                                null()
                              end_if
                            end_if))

    end_if;

    if testtype(uinf, Type::PosInt) then
      sysassign(prog::LEVEL, uinf)
    else
      sysassign(prog::LEVEL, 1)
    end_if;
    // provisorisch SEQ zhlen
    sysassign(prog::SEQ, {});
    // depends
    //
    //if domtype(FUN) = DOM_TABLE
    //   and map(op(FUN), op, 1) = {DOM_PROC, DOM_DOMAIN, DOM_FUNC_ENV} then
    //  sysassign(prog::DEP, FUN);
    //  OPT[hold(Append)] := TRUE
    //else
      sysassign(prog::DEP, table(DOM_PROC = {},
                                 DOM_FUNC_ENV = {},
                                 DOM_DOMAIN = {}));
    //end_if;

//    sysassign(prog::LOCAL, table("level" = -1));
//    sysassign(prog::LOCALuse, table("level" = -1));
//    sysassign(prog::WARNINGS, 0);
    // Reset nach Fehler
    sysassign(prog::init, subsop(prog::init, 5 = NIL));
    sysassign(prog::checkNone, subsop(prog::checkNone, 5 = NIL));

    MAXDEPTH := 1000;

    // read all disabled messages
    prog::checkDisableMessage(hold(All), hold(Quiet));

    if (GF:= fopen("check.globals")) <> FAIL then
      while (INP:= finput(GF)) <> null() do
        prog::init(op(INP, 1));
        prog::setcheck(INP)
      end_while
    end_if;
    if FUN = hold(All) then
      prog::init(All);
      sysassign(prog::Summe, [0, 0]);
      // DOM_PROC /////////////////////////////////////////////////////////////
      prog::PRINT(10, "pre-init all DOM_PROC");
      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_PROC)))],
               (X, Y)->(expr2text(X)<expr2text(Y))),
          prog::init);
      prog::PRINT(10, "checking all DOM_PROC");
      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_PROC)))],
               (X, Y)->(expr2text(X)<expr2text(Y))),
          prog::checkFunc, OPT);
      // DOM_EXEC /////////////////////////////////////////////////////////////
//      prog::PRINT(10, "pre-init all DOM_EXEC");
//      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_EXEC)))],
//             (X, Y)->(expr2text(X)<expr2text(Y))),
//        prog::init, OPT);
//      prog::PRINT(10, "checking all DOM_EXEC");
//      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_EXEC)))],
//             (X, Y)->(expr2text(X)<expr2text(Y))),
//        prog::checkFunc, OPT);
    // DOM_FUNC_ENV /////////////////////////////////////////////////////////
      prog::PRINT(10, "pre-init all DOM_FUNC_ENV");
      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_FUNC_ENV)))],
               (X, Y)->(expr2text(X)<expr2text(Y))),
          prog::init);
      prog::PRINT(10, "checking all DOM_FUNC_ENV");
      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_FUNC_ENV)))],
               (X, Y)->(expr2text(X)<expr2text(Y))),
          prog::checkFunc, OPT);
      // DOM_DOMAIN ///////////////////////////////////////////////////////////
      prog::PRINT(10, "pre-init most DOM_DOMAIN");
      GF:= sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_DOMAIN)))],
                (X, Y)->(expr2text(X)<expr2text(Y)));
      for DF in GF do
        if domtype(DF) = DOM_DOMAIN then
          //if contains(eval(DF), "constructor") then
            prog::init(DF);
            sysdelete(prog::init(DF))
          //end_if
        end_if
      end_for;
      prog::PRINT(10, "checking all DOM_DOMAIN");
      map(sort([op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_DOMAIN)))],
               (X, Y)->(expr2text(X)<expr2text(Y))),
          prog::checkFunc, OPT);
      prog::PRINT(10, "checking all the rest");
      map(anames(All), prog::checkFunc, OPT);
    //            /////////////////////////////////////////////////////////////
      prog::PRINT(1, "*** All warnings: ",
               op(prog::Summe, 1), " (", op(prog::Summe, 2), ") [All] ***");
    //            /////////////////////////////////////////////////////////////
    elif contains({DOM_LIST, DOM_SET}, domtype(FUN)) then
      map((FUN), prog::checkFunc, OPT)
    elif OPT[hold(Depends)] = hold(All) then
      /////////////////////////////////////////////////////////////////////////
      // recursive - AllDepends
      FUN := prog::getname(FUN);
      TODO := {FUN};
      DONE := {};
      while TODO <> {} do
        FUN := op(TODO, 1);
        DONE := DONE union {FUN};
        if domtype(FUN) = DOM_STRING then
          // functions by name
          if traperror((FUN := eval(text2expr(FUN)))) <> 0 then
            TODO := TODO minus {op(TODO, 1)};
            next
          end_if
        end_if;
        prog::PRINT(2, "examine ", prog::getname(FUN));
        prog::checkFunc(FUN, OPT);
        TODO := (TODO
                 union (prog::DEP[DOM_PROC]
                        //union (if OPT[Domains] then prog::DEP[DOM_DOMAIN] else {} end_if) // zuviel...?
                        union prog::DEP[DOM_FUNC_ENV]))
                minus DONE;
      end_while
    else
      prog::init(FUN);
      prog::checkFunc(FUN, OPT)
    end_if;
    sysassign(prog::init, subsop(prog::init, 5 = NIL));
    sysassign(prog::checkNone, subsop(prog::checkNone, 5 = NIL));
//    //sysassign(prog::LOCAL, table("level" = -1));
//    //sysassign(prog::LOCALuse, table("level" = -1));
    if prog::OPT[hold(Depends)] = TRUE then
      if prog::OPT[hold(SimplifyDep)] <> FALSE then
        //DONE := prog::DEP[DOM_DOMAIN];
        sysassign(prog::DEP,
                  prog::simplifyDepends(prog::DEP, bool(prog::OPT[hold(SimplifyDep)] = hold(Domains))))
      end_if;
      if prog::OPT[hold(Output)] = hold(Table) then
        prog::DEP
      else
        // readable output
        fprint(Unquoted, 0, "The given object depends ",
               (if prog::OPT[hold(Depends)] <> hold(All) then "directly " else "recursively " end_if),
               "on the following MuPAD objects");
        fprint(Unquoted, 0, "\nMuPAD domains ", "_" $ TEXTWIDTH - 14);
        if prog::OPT[hold(SimplifyDep)] = hold(Domains) then
          DONE := prog::DEP[DOM_DOMAIN]
                  union map(prog::DEP[DOM_PROC] union prog::DEP[DOM_FUNC_ENV],
                            X -> // validate object X
                                 if traperror(eval(text2expr(X))) = 0
                                   and domtype(eval(text2expr(X))) = DOM_DOMAIN then
                                   X else null() end_if);
          output::tableForm(DONE, "  ", Unquoted)
        else
          output::tableForm(prog::DEP[DOM_DOMAIN], "  ", Unquoted);
          fprint(Unquoted, 0, "\nMuPAD function environments ", "_" $ TEXTWIDTH - 28);
          output::tableForm(prog::DEP[DOM_FUNC_ENV], "  ", Unquoted);
          fprint(Unquoted, 0, "\nMuPAD procedures ", "_" $ TEXTWIDTH - 17);
          output::tableForm(prog::DEP[DOM_PROC], "  ", Unquoted)
        end_if
      end_if
    else
      null()
    end_if
  end_proc:

// this procedure gets a table of sets, sets containing names of procedures
// remove illegal procedures,
//
prog::simplifyDepends:=
  proc(TABLE, DOMAINS = FALSE)
    local SET, IND, n, obj, k;
  begin
    for IND in map(op(TABLE), op, 1) do // indices
      SET := {};
      for n from 1 to nops(TABLE[IND]) do
        // remove several objects
        // remember_
        obj := op(TABLE[IND], n);
        if strmatch(obj, "^remember_") = FALSE
           and strmatch(obj, "^proc in ") = FALSE
           and strmatch(obj, "^_") = FALSE then
          if DOMAINS = TRUE then
            if (IND = DOM_DOMAIN and strmatch(obj, "^DOM_") = FALSE) then
              SET := SET union {obj}
            elif (k := strmatch(obj, "::", Index)) <> FALSE then
              SET := SET union {substring(obj, 1..op(k, 1)-1)}
            end_if
          else
            SET := SET union {obj}
          end_if
        end_if;
      end_for;
      TABLE[IND] := SET
    end_for;
    TABLE
  end_proc:

// Check ///////////////////////////////////////////////////////////////////////
prog::checkFunc:=
  proc(FUN, opt)
    local AE, EN, ENV, NAME, FUNCENV;
  begin
    FUNCENV := eval(FUN);
    NAME:=prog::getname(FUNCENV);
    if testtype(FUNCENV, DOM_FUNC_ENV) then
      if contains(prog::rememberFuncsOrig, expr2text(FUN)) then
        FUNCENV := subsop(FUNCENV, 1=prog::rememberFuncsOrig[expr2text(FUN)]);
      end_if;
      if contains(prog::rememberFuncsOrig, prog::getname(FUN)[11..-1]) then
        FUNCENV := subsop(FUNCENV, 1=prog::rememberFuncsOrig[prog::getname(FUN)[11..-1]]);
      end_if;
    else
      if contains(prog::rememberFuncsOrig, expr2text(FUN)) then
        return(prog::checkFunc(prog::rememberFuncsOrig[expr2text(FUN)], opt));
      end_if;
      if length(NAME) > 10 and NAME[1..10] = "remember::" and
        contains(prog::rememberFuncsOrig, prog::getname(FUN)[11..-1]) then
        return(prog::checkFunc(prog::rememberFuncsOrig[prog::getname(FUN)[11..-1]], opt));
      end_if;
    end_if;
    FUN:= FUNCENV;
    if NAME = hold(F.UN) then
      // helpful for debugging
//      warning("NAME is FUN");
    end_if;
    prog::PRINT(5, "checking ".NAME
                           ." (".expr2text(type(FUN)).")");
    prog::Level(1, 5);
    sysassign(prog::LOCAL, table("level" = -1));
    sysassign(prog::LOCALuse, table("level" = -1));
    prog::warn(0);
    prog::nowarn(0);
    sysassign(prog::GLOV, table()); // global idents
    sysassign(prog::LOV,  table()); // local unused
    sysassign(prog::ASS,  table()); // assignments to formal parameters
    sysassign(prog::LEV,  table()); // level on var's
    sysassign(prog::ESC,  table()); //
    sysassign(prog::SAVE, {});      // saved variables
    sysassign(prog::DOMAINS, {});   // the visited domains

    sysassign(prog::OPT, opt);

    prog::init(FUN);
    case domtype(FUN)
      of DOM_EXEC do
      of DOM_PROC do
        prog::checkNone(FUN); //checkGlobal?
        break
      of DOM_FUNC_ENV do
        prog::path(NAME);
        prog::checkNone(op(FUN, 1));
        prog::checkNone(op(FUN, 2));
        if domtype(op(FUN, 3)) = DOM_TABLE then
          for AE in prog::Entries(FUN) do
            prog::PRINT(14, "slot ".NAME."::".AE);
            prog::PRINT(6..9, "slot ".NAME."::".AE);
            prog::path(NAME."::".AE);
            prog::checkNone(slot(FUN, AE), opt);
            prog::path();
          end_for
        end_if;
        prog::path();
        break
      of DOM_DOMAIN do
        if not contains({AxiomConstructor, CategoryConstructor, DomainConstructor,
                         Dom, Cat, Ax}, FUN) then
          // store FUN as visited domain
          sysassign(prog::DOMAINS, prog::DOMAINS union {FUN});

          // undefined Entries
          INTERFACE(prog::checkInterface(FUN));
          DOMENT(prog::undefEntr(FUN));
          if contains(FUN, "Name") then
            prog::path(expr2text(FUN));
          else
            prog::path(NAME)
          end_if;
          for EN in prog::Entries(FUN) do
            if EN = "patternFSA" or  /* generated pattern matchers */
              EN = "RINT" /* check internal table */  or
              // do not check global objects
              contains(map(anames(All), expr2text),
                       prog::getname(slot(FUN, EN))) or
              // do not check prog::rememberFuncs since this breaks prog::setcheckglobals
              NAME="prog" and EN="rememberFuncs" then
              next;
            end_if;
            // do not decend in already visited domains
            if testtype(slot(FUN, EN), DOM_DOMAIN) and
               contains(prog::DOMAINS, slot(FUN, EN)) then
              next;
            end_if;

            prog::Level(1, 14);
            prog::PRINT(14, "checking entry ".EN." of domain ".expr2text(FUN));
            prog::Level(-1, 14);

            prog::path(prog::getname(hold(slot)(FUN, EN)));
            ENV:= prog::Env(FUN, EN);
            if ENV <> FAIL then
              //prog::PRINT(2, "Use context of ", FUN, " : ", op(ENV, 1));
              sysassign(prog::LOCAL,
                        table(op(prog::LOCAL), "level" = prog::LOCAL["level"] + 1,
                              prog::LOCAL["level"] + 1 = op(ENV, 1),
                              prog::LOCAL["level"] + 1001 = op(ENV, 2)))
            end_if;
            //prog::PRINT(2, "check entry ".EN." of domain ".NAME);
            prog::checkNone(slot(FUN, EN));
            prog::path();

            if ENV <> FAIL then
              sysdelete(prog::LOCAL[prog::LOCAL["level"]]);
              sysdelete(prog::LOCAL[prog::LOCAL["level"] + 1000]);
              sysassign(prog::LOCAL,
                        table(op(prog::LOCAL), "level" = prog::LOCAL["level"] - 1))
            end_if;

          end_for;
          prog::path();
        end_if;
        break
      otherwise
        prog::checkNone(FUN);
    end_case;

    //sysassign(prog::LOCAL, table("level" = -1));
    //sysassign(prog::LOCALuse, table("level" = -1));
    if prog::OPT[hold(Depends)] = FALSE then //
      prog::PRINT(op([2..2, 1], sign(prog::warn() + prog::nowarn()) + 1),
               "Warnings: ", prog::warn(),
               _if(prog::nowarn() > 0, (" (", prog::nowarn(), " Assign)"), ""),
               " [".NAME."]",
                  //provisorisch SEQ zhlen
                  _if(nops(prog::SEQ) > 0, (" *** ", nops(prog::SEQ), " _seq"),
                      ()))
    end_if;
    // reset SEQ
    sysassign(prog::SEQ, {});
    sysassign(prog::Summe, [op(prog::Summe, 1) + prog::warn(),
                            op(prog::Summe, 2) + prog::nowarn()]);
    prog::Level(-1, 5);
    null()
  end_proc:


prog::checkNone:=
  proc(FUN = null())
    local EN, ENV, value;
    save progCheckNoneInCheckOfProc;
  begin
    if domtype(progCheckNoneInCheckOfProc) <> DOM_BOOL then
      sysassign(progCheckNoneInCheckOfProc, FALSE);
    end;
    sysassign(prog::checkNone(args()), "ready");
    prog::init(FUN);
    if FUN = null() or FUN = prog::DOMAINS or
      contains({AxiomConstructor, CategoryConstructor, DomainConstructor,
                Dom, Cat, Ax}, domtype(FUN)) or
      contains({AxiomConstructor, CategoryConstructor, DomainConstructor,
                Dom, Cat, Ax}, FUN) then
      return();
    end_if;
    case domtype(FUN)
      of DOM_EXEC do
        break
      of DOM_PROC do
        sysassign(progCheckNoneInCheckOfProc, TRUE);
        if op(FUN, 4) = FAIL then
          if has({op(FUN, 3)}, hold(noExpose)) then
            prog::PRINT(5, "Info: procedure '".prog::getname(FUN)."' hides its body, not checked ", prog::PATH)
          else
            prog::PRINT(12..14, "Warning: body of procedure '".prog::getname(FUN)."' is 'FAIL' ", prog::PATH)
          end_if
        else
          sysassign(prog::LOCALused, {});
          sysassign(prog::SAVE, {op(FUN, 11)}); // saved variables
          DEPENDS(prog::saveDepends(FUN, DOM_PROC));
          prog::checkGlobal(FUN)
        end_if;
        break
      of DOM_DOMAIN do
        INTERFACE(prog::checkInterface(FUN));
        DOMENT(prog::undefEntr(FUN));
        for EN in prog::Entries(FUN) do
          if EN = "patternFSA" or  /* generated pattern matchers */
            EN = "RINT" /* check internal table */  or
            // do not check global objects
            contains(map(anames(All), expr2text),
                          prog::getname(slot(FUN, EN))) then
            next;
          end_if;
            // do not decend in already visited domains
            if testtype(slot(FUN, EN), DOM_DOMAIN) and
               contains(prog::DOMAINS, slot(FUN, EN)) then
              next;
            end_if;

          prog::Level(1, 14);
          prog::PRINT(14, "checking entry ".EN." of domain ".expr2text(FUN));
          prog::Level(-1, 14);

          if contains(FUN, "Name") then
            prog::path(expr2text(FUN));
          else
            prog::path(prog::getname(FUN))
          end_if;
          ENV:= prog::Env(FUN, EN);
          if ENV <> FAIL then
            //prog::PRINT(2, "Use context of ", FUN, " : ", op(ENV, 1));
            sysassign(prog::LOCAL,
                      table(op(prog::LOCAL), "level" = prog::LOCAL["level"] + 1,
                            prog::LOCAL["level"] + 1 = op(ENV, 1),
                            prog::LOCAL["level"] + 1001 = op(ENV, 2)))
          end_if;
          prog::checkNone(slot(FUN, EN));
          prog::path();

          if ENV <> FAIL then
            sysdelete(prog::LOCAL[prog::LOCAL["level"]]);
            sysdelete(prog::LOCAL[prog::LOCAL["level"] + 1000]);
            sysassign(prog::LOCAL,
                      table(op(prog::LOCAL), "level" = prog::LOCAL["level"] - 1))
          end_if;

        end_for;
        break;
      of DOM_IDENT do
      of DOM_RAT do
      of DOM_COMPLEX do
      of DOM_INT do
      of DOM_FLOAT do
      of DOM_BOOL do
      of DOM_FAIL do
      of DOM_INTERVAL do
      of DOM_STRING do
      of DOM_VAR do
      of DOM_NIL do
      of DOM_PROC_ENV do
      of DOM_NULL do
      of DOM_POLY do
        break;

      of DOM_TABLE do
        // do not map on index expressions
        for EN in map([op(FUN)], DOM_LIST@lhs) do
//          prog::path("table entry ".expr2text(op(EN)));
            // do not decend in e.g. matrix::coeffRing = Dom::ExpressionField()
          value := [eval(hold(_index)(FUN, op(EN)))];
            if testtype(op(value), DOM_DOMAIN) then
              if not strmatch(prog::getname(op(value)),
                              stringlib::maskMeta(prog::PATH[-1])) then
//                fprint(Unquoted, 0, "In '".prog::PATH[-1]."': skipping ".prog::getname(op(value)));
                next;
              end_if;
            end_if;
          prog::checkNone(op(value));
//          prog::path();
        end_for;
        break;

      otherwise
        // map recursively on all container types
        if FUN <> op(FUN) and not progCheckNoneInCheckOfProc then
          map([op(FUN)], prog::checkNone)
        end_if;
    end_case
  end_proc:

prog::checkGlobal:=
  proc(FUN)
    local BODY, UE, FU, STMT, NAME, ENV;
  begin
    //sysassign(prog::checkGlobal(args()), "ready");
    // lokale Variablen + Parameterliste
    if domtype(FUN) <> DOM_PROC then
      error("DOM_PROC expected (".expr2text(domtype(FUN)).")")
    end_if;
    BODY:= op(FUN, 4);               // Rumpf
    if op(FUN, 6) = NIL then
      NAME := stringlib::collapseWhitespace(expr2text(FUN));
      if length(NAME) > 35 then
        NAME := NAME[1..32]."...";
      end;
      sysassign(FUN, subsop(FUN, 6=NAME));
    end_if;
    NAME:= prog::getname(FUN);            // NAME
    prog::path(NAME);
    ENV:= prog::Env(FUN);
    sysassign(prog::LOCAL,
              table(op(prog::LOCAL), "level" = prog::LOCAL["level"] + 1,
                    prog::LOCAL["level"] + 1 = op(ENV, 1),
                    prog::LOCAL["level"] + 1001 = op(ENV, 2)));

    //prog::PRINT(2, "Level up to ", prog::LOCAL["level"]);
    prog::Level(1, 10);
    prog::PRINT(10, "checking ".NAME." ",
                 (subsop(prog::PATH, nops(prog::PATH) = null())));
    if prog::type(BODY) <> "_stmtseq" then BODY:= [BODY] end_if;
    for STMT in BODY do
      // check each statement in body
      prog::indets([STMT], NAME);
    end_for;

    GLOBAL(if contains(prog::GLOV, prog::PATH) then
             prog::PRINT(3, "Global idents: ",
                      prog::GLOV[prog::PATH],
                      " in ", (prog::PATH));
             prog::warn(nops(prog::GLOV[prog::PATH]))
           end_if);
    LOCAL((if contains(prog::LOV, prog::PATH) then
             UE:= map(prog::LOV[prog::PATH], prog::VNM)
           else
             UE:= {}
           end_if;
           UE:= {op(prog::LOCAL[prog::LOCAL["level"]])}
                minus UE // local used
                minus (FU:= _if(/*not contains(prog::OPT, hold(Localf))*/TRUE,
                                _if(prog::LOCAL[prog::LOCAL["level"] + 1000] > 0,
                                    {op(prog::LOCAL[prog::LOCAL["level"]],
                                        (//nops(prog::LOCAL[prog::LOCAL["level"]])
                                        /*-*/ prog::LOCAL[prog::LOCAL["level"] + 1000])..
                                       nops(prog::LOCAL[prog::LOCAL["level"]]))},
                                    {}),
                                {})
                       minus UE);
           UE:= UE minus {hold(procname), hold(dom)};
           if nops(UE) > 0 then
             prog::PRINT(3, "Unused local variables: ", UE, " in ", prog::PATH);
             prog::warn(nops(UE));
             //prog::XV(prog::LOV, prog::PATH) // aufraumen
           end_if;
           if nops(FU) > 0 and prog::OPT[hold(Localf)] then
             if strmatch(prog::getname(FUN), "^remember_") = FALSE then
               prog::PRINT(3, "Unused formal parameters: ", FU, " in ", prog::PATH);
               prog::warn(nops(FU))
             else // exception: formal parameters for printing in remembered procedures
               prog::PRINT(10, "Unused formal parameters: ", FU, " in *remembered* function  ", prog::PATH);
             end_if
             //prog::XV(prog::LOV, prog::PATH) // aufraumen
           end_if));
    ASSIGN(if contains(prog::ASS, prog::PATH) then
             prog::PRINT(5, "Assignments to formal parameters: ",
                      (prog::ASS[prog::PATH]),
                      " in ", (prog::PATH));
//           prog::warn(nops(prog::ASS[prog::PATH]));
//           prog::nowarn(nops(prog::ASS[prog::PATH]));
             if contains(prog::ASS, prog::PATH.["W"]) then
               if contains(prog::ASS[prog::PATH.["W"]], TRUE) then
                 prog::PRINT(3, "Critical assignments to formal parameters: ",
                          (prog::ASS[prog::PATH]),
                          " in ", (prog::PATH));
                 prog::warn(nops(prog::ASS[prog::PATH]));
                 prog::nowarn(nops(prog::ASS[prog::PATH]));
                 prog::PRINT(3, "Usage of 'args' after assignment to formal parameters in ",
                          prog::PATH);
                 //prog::warn(1);
               end_if
             end_if;
             //prog::XV(prog::ASS, prog::PATH.["W"]); // aufraumen
             //prog::XV(prog::ASS, prog::PATH) // aufraumen
           end_if);
    LEV(if contains(prog::LEV, prog::PATH) then
          prog::PRINT(3, "Function 'level' applied to variables: ",
                   (prog::LEV[prog::PATH]),
                   " in ", (prog::PATH));
          prog::warn(nops(prog::LEV[prog::PATH]));
          //prog::XV(prog::LEV, prog::PATH) // aufraumen
        end_if);
    ESC(if contains(prog::ESC, prog::PATH) then
          prog::warn(1);
          prog::PRINT(3, "Procedure environment of [".
                   op(prog::ESC[prog::PATH]).
                   "] used by [".
                   op(zip(prog::PATH, [", " $ nops(prog::PATH) - 1], _concat, "")).
                   "]")
          //prog::XV(prog::LEV, prog::PATH) // aufraumen
        end_if);
    //prog::XV(prog::LOV, prog::PATH);
    //prog::PRINT(2, "Level down to ", prog::LOCAL["level"] - 1);
    prog::Level(-1, 10);
    prog::path();
    sysdelete(prog::LOCAL[prog::LOCAL["level"]]);
    sysdelete(prog::LOCAL[prog::LOCAL["level"] + 1000]);
    sysassign(prog::LOCAL,
              table(op(prog::LOCAL), "level" = prog::LOCAL["level"] - 1));
  end_proc:

//        //////////////////////////////////////////////////////////////////////
prog::indets:=
  proc(STMT, NAME, MSG = "")
    //option hold;
    local i, PT, REC;
  begin
    STMT:= op(STMT);
    REC:= TRUE;
//fprint(0, ">>", prog::getname(STMT), domtype(STMT));
    FIND((//print("Find ", STMT = prog::OPT[hold(Find)] or prog::getname(STMT) = prog::OPT[hold(Find)]);
          if STMT = prog::OPT[hold(Find)] or prog::getname(STMT) = prog::OPT[hold(Find)]
             or prog::getname(STMT) = prog::getname(prog::OPT[hold(Find)]) then
            prog::PRINT(1, "object found in [".NAME."]")
          end_if));
    case domtype(STMT)
      of DOM_IDENT do
        COMP(if contains(prog::changeSet(prog::Changes::removed, hold(Sysvar)), STMT) then
               prog::warning(1, "Environment variable '".prog::getname(STMT)."' does not longer exist!");
               break
             end_if);
        GLOBAL(if not prog::isGlobal(STMT) then
                 if not prog::OPT[hold(Save)]
                   or not contains(prog::SAVE, STMT) then
                   prog::PRINT(5, "Global variable '".prog::getname(STMT).
                                 "'".(if MSG <> "" then " in ".MSG else "" end_if)." in [".NAME."]");
                   prog::XV(prog::GLOV, prog::PATH, prog::getname(STMT));
                   // provisorisch: _seq.. zhlen
                   if MSG <> "" and stringlib::contains(MSG, "_seq") then
                     sysassign(prog::SEQ, prog::SEQ union {[STMT, prog::PATH]})
                   end_if;
                 end_if
               end_if);
        DEPENDS(prog::saveDepends(eval(STMT)));
        break
      of DOM_PROC do
        DEPENDS(prog::saveDepends(STMT, DOM_PROC));
        prog::checkGlobal(STMT); break
      of DOM_FUNC_ENV do
        DEPENDS(prog::saveDepends(STMT, DOM_FUNC_ENV));
        break
      of DOM_DOMAIN do
        DEPENDS(prog::saveDepends(STMT, DOM_DOMAIN));
        break
      of DOM_VAR do
        LOCAL((PT:= prog::PATH;
               prog::XV(prog::LOV, PT, /*prog::VNM*/([op(STMT)]));
               if op(op(STMT), 1) > 0 then
                 PT:= subsop(PT, nops(PT) - i = null() $ i = 0..(op(op(STMT), 1) - 1));
                 prog::XV(prog::LOV, PT, /*prog::VNM*/([0, op(STMT, 2)]))
               end_if)); // local used
        ESC((if op(STMT, 1) > 0 then
               PT:= prog::PATH;
               (PT:= subsop(PT, nops(PT) = null())) $ i = 1..op(STMT, 1);
               if nops(PT) > 1 then
                 PT:= _concat(op(zip(PT, [", " $ nops(PT) - 1], _concat, "")))
               else
                 PT:= _concat(op(PT))
               end_if;
               prog::XV(prog::ESC, prog::PATH, PT)
             end_if));
        break
      of DOM_INT do
      of DOM_RAT do
      of DOM_FLOAT do
      of DOM_COMPLEX do
      of DOM_STRING do
      of DOM_BOOL do
      of DOM_NIL do
      of DOM_NULL do
      of DOM_FAIL do
        break;
      of DOM_SET do
      of DOM_LIST do
      of DOM_EXPR do

        if domtype(op(STMT, 0)) = DOM_EXPR then
          prog::indets([op(STMT, 0)], NAME, MSG)
        else
          case prog::type(STMT)
            of "block" do
            of "blockIdents" do
            of "blockTransparent" do
            of "hold" do
            of "sysdelete" do
              REC:= FALSE;
              //nichts
              break
            of "DOM_VAR" do
              prog::indets([op(STMT, 0)], NAME, MSG);
              break
            of "slot" do
              // check, whether the first operand is a valid domain
              if (prog::type(op(STMT, 1)) = DOM_DOMAIN or prog::type(op(STMT, 1)) = DOM_IDENT
                                                      and prog::type(eval(op(STMT, 1))) = DOM_DOMAIN) then
                if not hastype(op(STMT, 2), DOM_VAR) and
                  traperror(contains(eval(op(STMT, 1)), op(STMT, 2))) = 0 then
                  if contains(eval(op(STMT, 1)), op(STMT, 2)) then
                    DEPENDS(prog::saveDepends(eval(STMT), "slot"));
                  else
                    if prog::type(op(STMT, 1)) <> "DOM_VAR" and prog::type(op(STMT, 2)) <> "DOM_VAR"
                      and strmatch(expr2text(op(STMT, 2)), "DOM_VAR") = FALSE
                      and strmatch(prog::getname(op(STMT, 1)), "DOM_VAR") = FALSE then
                      SLOT(prog::PRINT(5, "Referred slot ", expr2text(op(STMT, 2)),
                                          " is not defined in domain '", op(STMT, 1), "' ", prog::PATH))
                    end_if
                  end_if
                end_if
              end_if;
              break
            of "function" do
              prog::indets([op(STMT, 0)], NAME, MSG);
              break
            of "_seqin" do
              if op(STMT, 0) = hold(_seqin) or op(STMT, 0) = _seqin then
                if nops(STMT) = 3 and type(op(STMT, 2)) = DOM_IDENT then
                  REC:= FALSE;
                  // remove undeclared variables
                  //prog::indets([subs(op(STMT, 1), op(STMT, 2) = FAIL, Unsimplified)], NAME, MSG);
                  prog::indets([op(STMT, 1)], NAME, "_seqin");
                  prog::indets([op(STMT, 3)], NAME, "_seqin")
                else
                  prog::indets([op(STMT, 0)], NAME, "_seqin")
                end_if
              else
                prog::indets([op(STMT, 0)], NAME, "_seqin")
              end_if;
              break
            of "_seqgen" do
              if nops(STMT) = 3 and type(op(STMT, 2)) = DOM_IDENT then
                REC:= FALSE;
                // remove undeclared variables
                //prog::indets([subs(op(STMT, 1), op(STMT, 2) = FAIL, Unsimplified)], NAME, MSG);
                prog::indets([op(STMT, 1)], NAME, "_seqgen");
                prog::indets([op(STMT, 3)], NAME, "_seqgen");
              end_if;
              break
              // I do not want to see sys*assign warnings (tonner)
//            of "sysassign" do
//            of "sysevalassign" do
            of "_assign" do
            of "evalassign" do
              ENV((prog::envAss(op(STMT, 1), NAME)));
              PROT((prog::protAss(op(STMT, 1), NAME)));
              SPEC(prog::specAss(op(STMT, 1), op(STMT, 2), NAME)
                   );
              ASSIGN(prog::localAss(op(STMT, 1), NAME)); break
            of "level" do
              LEV(if domtype(op(STMT, 1)) = DOM_VAR then
                    prog::warning(0, "Critical usage of 'level' on local variable '",
                                  prog::VNM(op(STMT, 1)), "' in ", [NAME]);
                    prog::XV(prog::LEV, prog::PATH, prog::VNM(op(STMT, 1)))
                  end_if);
              break
            of "args" do
              if contains(prog::ASS, prog::PATH.["W"]) then
                if not(contains(prog::ASS[prog::PATH.["W"]], TRUE)) then
                  prog::warning(0, "Usage of 'args' after assignment to formal parameters in ", [NAME]);
                  prog::XV(prog::ASS, prog::PATH.["W"], TRUE)
                end_if
              end_if;
              break
            otherwise
              prog::indets([op(STMT, 0)], NAME);
          end_case;
        end_if;
        if REC then
          for i from 1 to nops(STMT) do
            if domtype(op(STMT, i)) = DOM_PROC and op(STMT, [i, 6]) = NIL then
              // set default name 'anonymous' for unnamed procedures in the static scope
              prog::indets([subsop(op(STMT, i), 6 = "proc in '".NAME."'")], NAME, MSG)
            else
              prog::indets([op(STMT, i)], NAME, MSG)
            end_if
          end_for;
          REC:= FALSE
        end_if;
        break
      otherwise
//        GLOBAL(map(indets(STMT),
//                 (X)->(if not prog::isGlobal(X) then
//                         prog::warning(0, "Global variable '".expr2text(X).
//                                       "' in ".NAME);
//                         prog::XV(prog::GLOV, prog::PATH, X)
//                       end_if)));
    end_case
  end_proc:

// returns a set produced from a table
prog::changeset:=
  proc(TAB, LIB)
    local RET;
  begin
    RET:= select(TAB, X -> op(X, [1, 1]) = LIB);
    {op(map(RET, op, [1, 2]))}
  end_proc:

// local ///////////////////////////////////////////////////////////////////////
// Variablen, die nur in geschachtelten Prozeduren verwendet werden
prog::localUsed:=
  proc(PATH)
    local AU, FN;
  begin
    if nops(PATH) > 1 then FN:= op(PATH, nops(PATH)) else FN:= op(PATH) end_if;
    AU:= select(prog::LOV, (X->bool(contains(op(X, 1), FN) > 0)));
    {}
  end_proc:

prog::localAss:=
  proc(VAR, NAME)
  begin
    if prog::isFormal(VAR) then
      prog::XV(prog::ASS, prog::PATH.["W"], UNKNOWN);
      prog::warning(3, "Assignment to FORMAL parameter '".prog::VNM(VAR)."' in [".NAME."]");
      prog::XV(prog::ASS, prog::PATH, prog::VNM(VAR))
    end_if
  end_proc:

prog::isFormal:=
  proc(VAR)
    local IND;
  begin
    if domtype(VAR) = DOM_VAR then
      IND:= prog::LOCAL["level"] + 1000 - op(VAR, 1);
      if not contains(prog::LOCAL, IND) then
      else
        if prog::LOCAL[IND] < op(VAR, 2) + 2 then
          return(TRUE)
        end_if
      end_if
    end_if;
    FALSE
  end_proc:

prog::protAss:=
  proc(VAR, NAME)
  begin
    if domtype(VAR) = DOM_IDENT then
      if (not prog::isCheckedProtectedAssignment(VAR)) then
        if protected(VAR) <> hold(None) then
          prog::warning(3, "Assignment to PROTECTED identifier '".expr2text(VAR)."' in [".NAME."]")
        end_if
      end_if
    end_if:
  end_proc:

prog::envAss:=
  proc(VAR, NAME)
  begin
    if contains(level(stdlib::ENVIRONMENT_VARIABLES, 1), VAR) then
      if not prog::isSaved(VAR) then
        prog::warning(1, "Assignment to ENVIRONMENT variable '".expr2text(VAR)."' in [".NAME."]")
      end_if
    end_if
  end_proc:

prog::isSaved:=
  proc(VAR)
  begin

    FALSE
  end_proc:

prog::specAss:= // Spezialflle
  proc(VAR, EX, NAME)
  begin
    case VAR
      of hold(HIS).hold(TORY) do
        if not contains({DOM_INT, "DOM_VAR"}, prog::type(EX)) then
          prog::warning(1, "Illegal argument assigned to 'HISTORY' in [".NAME."]")
        end_if
    end_case
  end_proc:

//prog::chkStmt:=
//  proc(STMT, NAME)
//    local i;
//  begin
//    i:= 0;
//    case prog::type(STMT)
//      of "level" do
//      //prog::PRINT(5, "** level in use");
//      if domtype(op(STMT, 1)) = DOM_VAR then
//        prog::warning(0, "Critical using of 'level' on local variable ".
//                      prog::VNM(op(STMT, 1))." [".NAME."]" )
//      end_if;
//      otherwise
//      //if domtype(STMT) = DOM_EXPR #and nops(STMT) > 1# then
//      prog::chkStmt(op(STMT, i), NAME) $ i = 1..nops(STMT)
//      //end_if
//    end_case;
//    null()
//  end_proc:

// undefined Entries
prog::undefEntr:=
  proc(DOM)
    local AE;
  begin
    if (AE:= (DOM)::undefinedEntries()) <> FAIL and
      AE <> {} and DOM <> stdlib::Undefined then
      prog::warning(1, "Undefined entries ".expr2text(AE)." in ".prog::getname(DOM), 3)
    end_if
  end_proc:

// Interface of a domain
prog::checkInterface:=
  proc(DOM)
    local n;
  begin
    if DOM::interface = FAIL then
      prog::PRINT(5, "Domain ".prog::getname(DOM)." has no interface");
      return()
    elif domtype(DOM::interface) <> DOM_SET then
      prog::warning(1, "Interface '".expr2text(DOM::interface)."' is not a set", 3)
    else
      for n in DOM::interface do
        if domtype(n) <> DOM_IDENT then
          prog::warning(1, "Interface entry '".expr2text(n)."' is not an identifier in ".prog::getname(DOM), 3)
        end_if
      end_for
    end_if;
    for n in sort([op(map(DOM::interface, expr2text))]) do
      prog::PRINT(10, "check interface entry ".n." of domain ".prog::getname(DOM));
      if slot(DOM, n) = FAIL then
        prog::warning(1, "Interface entry '".n."', but no definition in ".prog::getname(DOM), 3)
      end_if
    end_for
  end_proc:

////////////////////////////////////////////////////////////////////////////////
// Hilfsfunktionen
////////////////////////////////////////////////////////////////////////////////

prog::warning:=
  proc(NWARN, MSG, LEV = 5)
    local k;
  begin
    if nops(prog::PATH) > 1 then
      MSG:= MSG." [".
            _concat((op(prog::PATH, k), ", ") $ k=1..nops(prog::PATH) - 2).
            op(prog::PATH, nops(prog::PATH) - 1)."]";
    else
      MSG:= MSG/*." []"*/;
    end_if;
    if contains(prog::NMSG, MSG) or contains(prog::NMSG, "Warning: ".MSG) then
      if prog::LEVEL > 14 then
        prog::PRINT(LEV, MSG, " -disabled-")
      end_if
    else
      prog::PRINT(LEV, MSG);
      if NWARN > 0 then
        prog::warn(NWARN)
      end_if
    end_if
  end_proc:

prog::warn:=
  proc(X = null())
  begin
    if args(0) > 0 then
      if X = 0 then
        sysassign(prog::WARNINGS, 0)
      else
        sysassign(prog::WARNINGS, prog::WARNINGS + X)
      end_if
    else
      prog::WARNINGS - prog::NWARNINGS
    end_if
  end_proc:

prog::nowarn:=
  proc(X = null())
  begin
    if args(0) > 0 then
      if X = 0 then
        sysassign(prog::NWARNINGS, 0)
      else
        sysassign(prog::NWARNINGS, prog::NWARNINGS + X)
      end_if
    else
      prog::NWARNINGS
    end_if
  end_proc:

prog::VNM:=
  proc(VAR)
  begin
    if not contains(prog::LOCAL, prog::LOCAL["level"] - op(VAR, 1)) then
      prog::warning(1, "*** a problem with context of DOM_VAR(".expr2text(op(VAR)).")");
      FAIL
    else
      op(prog::LOCAL[prog::LOCAL["level"] - op(VAR, 1)], op(VAR, 2) + 1)
    end_if
  end_proc:

// prog::VNMM:=
//   proc(VAR)
//   begin
//     prog::PRINT(2, "VNMM ".expr2text(domtype(eval(VAR)), VAR));
//     case domtype(VAR)
//       of DOM_VAR do
//         if prog::VNM(VAR) <> FAIL then
//           prog::VNM(VAR)
//         else
//           expr2text(VAR)
//         end_if;
//         break
//       of DOM_STRING do
//         expr2text(prog::VNMM(eval(text2expr(VAR))));
//         break
//       otherwise
//         VAR
//     end_case
//   end_proc:

//initialized in prog.mu
//prog::PATH:= []:

prog::path:=
  proc(OBJ)
  begin
    if args(0) = 0 then
      sysassign(prog::PATH, subsop(prog::PATH, nops(prog::PATH) = null()))
    else
      sysassign(prog::PATH,
                append(prog::PATH, OBJ))
    end_if
  end_proc:

// LV, GV, AS
prog::XV:=
  proc(CON, FUN, ID = null())
    option hold;
  begin
    if args(0) = 2 then
      sysdelete(context(CON)[context(FUN)])
    else
      if contains(context(CON), context(FUN)) then
        sysevalassign(CON[context(FUN)], _union(context(CON[context(FUN)]), {context(ID)}), 2)
      else
        sysevalassign(CON[context(FUN)], {context(ID)}, 2)
      end_if
    end_if
  end_proc:

prog::type:=
  proc(EXPR = null())
  begin
    if domtype(EXPR) = DOM_EXPR then
      if domtype(op(EXPR, 0)) = DOM_EXPR then
        prog::type(op(EXPR, 0))
      elif hastype(op(EXPR, 0), DOM_VAR) then
        "DOM_VAR"
      elif contains({hold(block), hold(blockIdents), hold(blockTransparent)},
                    op(EXPR, 0)) then
        "".op(EXPR, 0)
      else
        type(EXPR)
      end_if
    else
      type(EXPR)
    end_if
  end_proc:

prog::Env:=
  proc(FUN, EN = null())
    local FRM, DOM, LOC;
  begin
    case domtype(FUN)
      of DOM_DOMAIN do
        if not contains({AxiomConstructor, CategoryConstructor, DomainConstructor,
                         Dom, Cat, Ax, Axiom, Category}, FUN) then
          DOM:= FUN::whichEntry(EN);
          if DOM <> FAIL then
            if not contains({Category, Axiom}, type(DOM)) then
              if contains(DOM, "constructor") then
                return(prog::Env(DOM::constructor))
              end_if
            else
              FUN:= op(extop(DOM, 1), 1)
            end_if
          end_if
        end_if;
        break
      of DomainConstructor do
        FUN:= op(FUN, 1);
        break
      of CategoryConstructor do
        FUN:= op(FUN, 1);
        break
    end_case;
    if domtype(FUN) <> DOM_PROC then
      return(FAIL)
    end_if;
    FRM:= subs(op(FUN, 2), NIL = null(), FAIL = null())/*, hold(procname), hold(dom)*/;
    LOC:= subs(op(FUN, 1), NIL = null(), FAIL = null());
    if (DOM:= {FRM} intersect {LOC}) <> {} then
      prog::PRINT(3, "Duplicate parameter or variable ", DOM, " in ", prog::PATH);
      prog::warn(1)
    end_if;
    // save
    if (DOM:= {op(FUN, 11)} minus {NIL, FAIL}) <> {} then
      prog::setcheck(FUN, DOM)
    end_if;
    // DOM_PROC_ENV
    // Achtung: Konnte Daten uberschreiben!?
    if type((DOM:= op(FUN, 12))) = DOM_PROC_ENV then
      sysassign(prog::LOCAL,
                table(op(prog::LOCAL), //"level" = prog::LOCAL["level"] + 1,
                      prog::LOCAL["level"] = [hold(procname), hold(dom),
                                                  op(DOM, [1, 2]), op(DOM, [1, 1])],
                      prog::LOCAL["level"] + 1000 = nops([op(DOM, [1, 2]), op(DOM, [1, 1])]) + 3))
    end_if;

    return([hold(procname), hold(dom), FRM, LOC], nops(FRM) + 1 + 2) // procname, dom
  end_proc:

prog::indent := 0:

prog::Level:=
  proc(n = 0, L = 0)
  begin
    if L <= prog::LEVEL then
      sysassign(prog::indent, prog::indent + n);
      assert(prog::indent >= 0);
      if prog::indent < 0 then
        sysassign(prog::indent, 0)
      end_if
    end_if
  end_proc:

// NAME, TYPE, WHERE
// NAME  - name of the found object
// TYPE  - type of the found object
prog::saveDepends:=
  proc(NAME, TT)
    local TYPE;
  begin
    TYPE := domtype(NAME);
    NAME := prog::getname(NAME);
    //if TYPE <> TT then
    //  fprint(Unquoted, 0, "Warning: ", expr2text(TYPE)." <> ".expr2text(TT)." [".NAME."]")
    //end_if;
    if contains({DOM_DOMAIN, DOM_FUNC_ENV, DOM_PROC}, TYPE) then
      //if not contains(prog::DEP, TYPE) then
      //  sysassign(prog::DEP[TYPE], {})
      //end_if;
      sysassign(prog::DEP[TYPE], prog::DEP[TYPE] union {NAME})
    //else
    //  TYPE := type(STMT);
    //  if not contains(prog::DEP, TYPE) then
    //    sysassign(prog::DEP[TYPE], {})
    //  end_if;
    //  sysassign(prog::DEP[TYPE], prog::DEP[TYPE] union {NAME})
    end_if;

    // select the last procedure/domain, skip 'proc in ...'
    //WHERE := prog::PATH;
    //while nops(WHERE) > 1 and strmatch(WHERE[nops(WHERE)], "^proc in ") do
    //  WHERE := subsop(WHERE, nops(WHERE) = null())
    //end_while;
    //if nops(WHERE) > 0 then
    //  WHERE := WHERE[nops(WHERE)]
    //else
    //  WHERE := hold(Global)
    //end_if;
    //if not contains(prog::DEP, WHERE) then
    //  sysassign(prog::DEP[WHERE], {})
    //end_if;

    //sysassign(prog::DEP[WHERE], prog::DEP[WHERE] union {NAME});
    prog::PRINT(5, "Found '", NAME, "' (", TYPE, ") in ", prog::PATH)
  end_proc:

prog::PRINT:=
    proc(LEV = 0)
    begin
      case type(LEV)
        of DOM_INT do
          if LEV <= prog::LEVEL then
            fprint(Unquoted, NoNL, 0, ("  " $ prog::indent), args(2..args(0)), "\n")
          end_if;
          break
        of "_range" do
          if op(LEV, 1) <= prog::LEVEL and op(LEV, 2) >= prog::LEVEL then
            fprint(Unquoted, NoNL, 0, ("  " $ prog::indent), args(2..args(0)), "\n")
          end_if;
          break
        otherwise
          fprint(Unquoted, NoNL, 0, ("  " $ prog::indent), args(2..args(0)), "\n")
      end_case
    end_proc:
