// 

// bij 2002
//
// checkFile(FILE, <DIRECTION>, <Quiet>)
//   FILE      - filename as string or filehandle as integer
//   DIRECTION - Read or Write or Append, Close to close the file/end reading
//   Quiet     - FAIL instead of error

// this table keeps the status of each opened/used file
// each file in this table is assumed to be opened
// entries:       id   mode
//    filename = [int, read ]
//    fileid   = [int,      ]
prog::checkFILES := table():


prog::checkFile :=
  proc(FILE : Type::Union(DOM_STRING, Type::PosInt))
    local OPT, res;
  begin
    // options
    OPT := prog::getOptions(2, [args()],
                            table(Read=TRUE,   // default read
                                  // options for fopen 
                                  Write=FALSE,  Append=FALSE,
                                  Text=FALSE,   Bin=FALSE,
                                  Raw=FALSE,
                                  // close current file
                                  hold(Close)=FALSE,
                                  // no error on output problems
                                  Quiet=FALSE),
                            FALSE,
                            table(Read=DOM_BOOL,
                                  Write=DOM_BOOL,  Append=DOM_BOOL,
                                  Text=DOM_BOOL,   Bin=DOM_BOOL,
                                  Raw=DOM_BOOL,
                                  hold(Close)=DOM_BOOL,
                                  Quiet=DOM_BOOL))[1];
                            
    // filename
    if domtype(FILE) = DOM_STRING then
      if OPT[hold(Close)] then
        // close file
        if contains(prog::checkFILES, FILE) then
          
          fclose(prog::checkFILES[FILE][1]); // id
          sysdelete(prog::checkFILES[FILE])
        else
          
          return(FAIL)
        end_if
      elif not contains({OPT[Write], OPT[Append]}, TRUE) then
        // reading
        // inspect REAPATH?? -> todo
        if (res := fopen(FILE)) <> FAIL then
          return(res)
        elif OPT[Quiet] then
          return(FAIL)
        else
          context(hold(error)("cannot open file '".FILE."' for reading"))
        end_if
      else
        // writing
        // WRITEPATH??
        if (res := fopen(FILE, op(map({op(select(OPT, has, TRUE))}, op, 1) intersect
                                  {Bin, Text, Raw, Write, Append}))) <> FAIL then
          return(res)
        elif OPT[Quiet] then
          return(FAIL)
        else
          context(hold(error)("cannot open file '".FILE."' for writing"))
        end_if
      end_if
    // file descriptor of open file
    elif domtype(FILE) = DOM_INT then
      if OPT[hold(Close)] then
        // close file
        fclose(FILE)
      elif not contains({OPT[Write], OPT[Append]}, TRUE) then
        return(FILE)
      else
        // writing
        // WRITEPATH??
        if traperror(fprint(hold(NoNL), FILE, "")) = 0 then
          return(FILE)
        elif OPT[Quiet] then
          return(FAIL)
        else
          context(hold(error)("cannot write to given file"))
        end_if
      end_if
    else
      FAIL
    end_if
  end_proc:
