
////////////////////////////////////////////////////////////////////////////////
// Interface: setcheckglobals
////////////////////////////////////////////////////////////////////////////////

// MSG : DOM_STRING - warning "MSG"" is not displayed by 'prog::check'
// MSG = hold(All)  - file "PROG/checkDisableMessages.txt" is red line by line
//                    and each line must contain a message without quotes
//                    message is quoted and this procedure called with each message
// OPT = quiet      - no warning message is printed, if the requested file cannot be opened
prog::checkDisableMessage:=
  proc(MSG = "", OPT = FAIL)
    local file, k, p;
  begin
    if MSG = hold(All) then
      for p in LIBPATH do
        if (file:= fopen(p.pathname("PROG")."checkDisableMessages.txt")) <> FAIL then // open message file
          while (k:= ftextinput(file)) <> null() do
            while k <> "" and (k[1] = " " or k[1] = "\t") do
              k:= k[2..-1]
            end_while;
            while k <> "" and (k[length(k)] = " " or k[length(k)] = "\t") do
              k:= k[1..-2]
            end_while;
            if k <> "" and k[1] <> "#" and (length(k) > 1 and k[1..2] <> "//") then
              prog::checkDisableMessage(k)
            end_if
          end_while;
          fclose(file)
        elif OPT <> hold(Quiet) then
          fprint(Unquoted, 0, "Info: cannot find '".
                              p.pathname("PROG")."checkDisableMessages.txt' [prog::check]")
        end_if
      end_for
    else
      sysassign(prog::NMSG, prog::NMSG union {MSG})
    end_if
  end_proc:

prog::setcheckglobals:=
  proc(FUN = null(), GLOBAL = null())
  begin
    if FUN = null() then
      prog::getcheckglobals()
    elif GLOBAL = null() then
      prog::getcheckglobals(FUN)
    else
      userinfo(Text, 6..9, "set global for ".prog::getname(FUN).": ".expr2text(GLOBAL));
      userinfo(Text, 14, "set global for ".prog::getname(FUN).": ".expr2text(GLOBAL));
      sysassign(prog::globalIdents,
		table(op(prog::globalIdents), prog::getname(FUN) = GLOBAL));
      null()
    end_if
  end_proc:

prog::getcheckglobals:=
  proc(FUN = null())
    //option hold;
    local i;
  begin
    if FUN = null() then
      if nops(prog::PATH) > 0 then 
	_union(prog::getcheckglobals(op(prog::PATH, i))
	       $ i=1..nops(prog::PATH),
	       prog::getcheckglobals(hold(All)))
      else
	{}
      end_if
    else
      if contains(prog::globalIdents, prog::getname(FUN)) then
	prog::globalIdents[prog::getname(FUN)]
      else
        {}
      end_if
    end_if
  end_proc:

// Sorgt dafür, dass das Setzen von geschützen Bezeichnern
// zu keinen Warnungen in prog:check() führt
// LIBRARY: Die Library (Domain) oder die Funktionsumgebung in der
//          die geschütze Bezeichner einer Wert erhält
// IDENT:   Die Menge der geschützte Bezeichner die einen Wert erhalten
prog::setCheckedProtectedAssignments:=
proc(LIBRARY, IDENTS)
  option noDebug;
begin
  if ( args(0) <> 2) then
    error("two arguments expected");
  end_if:
  if (domtype(IDENTS) <> DOM_SET) then
    error("Second argument must be a set of identifiers") ;
  end_if:
  sysassign(prog::protectedIdents,
		table(op(prog::protectedIdents), prog::getname(LIBRARY) = IDENTS ));
end:

// Testet ob ein Bezeichner obwohl der geschützt ist, (durch
// prog::setCheckedProtectedAssignments()) zum Überschreiben
// "freigegeben" ist.
// IDENT:   Der zu untersuchende Bezeichner
prog::isCheckedProtectedAssignment:=
proc(IDENT)
begin
  _or(op(map(prog::PATH,
             X -> _if(contains(prog::protectedIdents, X),
                      contains(level(prog::protectedIdents[X],1), IDENT),
                      FALSE)))):
end:
