//   

// Tabelle mit Zuordnungen Fehler-Nummer -> Fehler-Text

alias(MEVC_ILLEGAL_OPERAND           = 1001):
alias(MEVC_STMT_IN_EXPR              = 1002):
alias(MEVC_CANT_EVAL_BOOL            = 1003):
alias(MEVC_WRONG_NUMBER_OF_ARGS      = 1004):
alias(MEVC_ILLEGAL_ARGUMENT          = 1005):
alias(MEVC_REAL_NUMBER_EXPECTED      = 1006):
alias(MEVC_IO_WRITE_ERROR            = 1007):
alias(MEVC_ERROR                     = 1008):
alias(MEVC_SIGN_ERROR                = 1009):
alias(MEVC_RECURSIV_DEFINITION       = 1010):
alias(MEVC_INVALID_ASSIGNMENT        = 1011):
alias(MEVC_OUT_OF_RANGE              = 1012):
alias(MEVC_INTEGER_NUMBER_EXPECTED   = 1013):
alias(MEVC_SYSTEM_ERROR              = 1014):
alias(MEVC_OPERAND_DOES_NOT_EXIST    = 1015):
alias(MEVC_INVALID_RANGE             = 1016):
alias(MEVC_INVALID_INDEX             = 1017):
alias(MEVC_SUBSTITUTION_NOT_ALLOWED  = 1018):
alias(MEVC_INVALID_FUNCTION          = 1019):
alias(MEVC_STRING_TOO_LONG           = 1020):
alias(MEVC_IO_READ_ERROR             = 1021):
alias(MEVC_INDEX_RANGE               = 1022):
alias(MEVC_INDEX_TYP                 = 1023):
alias(MEVC_DIMENSION                 = 1024):
alias(MEVC_DIVISION_BY_ZERO          = 1025):
alias(MEVC_POS_INTEGER_EXPECTED      = 1026):
alias(MEVC_RESET_IN_USER_PROC        = 1027):
alias(MEVC_USER_DEFINED_ERROR        = 1028):
alias(MEVC_INTEGER_TOO_LARGE         = 1029):
alias(MEVC_UNKNOWN_OPTION            = 1030):
alias(MEVC_NO_INDETS                 = 1031):
alias(MEVC_ILLEGAL_INDET             = 1032):
alias(MEVC_NO_POLYNOMIAL             = 1033):
alias(MEVC_UNKNOWN_TYPE              = 1034):
alias(MEVC_NOT_IMPLEMENTED           = 1035):
alias(MEVC_MISSING_DOM_ATTR          = 1036):
alias(MEVC_CONTEXT_NOT_ALLOWED       = 1037):
alias(MEVC_RETURNVALUE_NOT_ALLOWED   = 1038):
alias(MEVC_IDENTIFIER_EXPECTED       = 1039):
alias(MEVC_EXPONENT_OVERFLOW         = 1040):
alias(MEVC_WRONG_EXEC                = 1041):
alias(MEVC_POSITIVE_VALUE_EXPECTED   = 1042):
alias(MEVC_BAD_UNKNOWN               = 1043):
alias(MEVC_WATCHDOG                  = 1044):
alias(MEVC_ARGUMENT_FAILED           = 1045):
alias(MEVC_WRITE_PROTECED_ASSIGNMENT = 1046):
alias(MEVC_IDENT_HAS_VALUE           = 1047):
alias(MEVC_NO_ATOMAR_TYPE            = 1048):
alias(MEVC_ILLEGAL_VAR               = 1049):
alias(MEVC_ILLEGAL_VAR_WITH_NAME     = 1050):
alias(MEVC_SINGULARITY               = 1051):

alias(MEVC_UNKNOWN_MCODE_OBJECT      = 1060):
alias(MEVC_UNKNOWN_MCODE_REFERENCE   = 1061):
alias(MEVC_WRONG_MCODE_OBJECT        = 1062):

alias(MEVC_DELETE_PARENT_FRAME       = 1070):

alias(MEVC_ILLEGAL_COEFFRING         = 1080):

alias(MEVC_UNKNOWN_EXTERN_OBJECT     = 1100):
alias(MEVC_UNKNOWN_OPERATOR          = 1101):
alias(MEVC_INTERUPTED_BY_USER        = 1102):
alias(MEVC_INTERNAL_ERROR            = 1103):
alias(MEVC_ILLEGAL_CONTEXT           = 1104):
alias(MEVC_COEFF_RING                = 1105):
alias(MEVC_FATAL_ERROR               = 1106):
alias(MEVC_SECURITY_ALERT            = 1107):
alias(MEVC_NON_NEG_INTEGER           = 1108):
alias(MEVC_DUPLICATE_DOMAIN_KEY      = 1109):
alias(MEVC_ILLEGAL_DOMAIN_KEY        = 1110):
alias(MEVC_NUMERICAL_SORTKEY_EXPECTED= 1111):
alias(MEVC_ILLEGAL_PARSER_CONFIG     = 1113):
alias(MEVC_ILLEGAL_VAR_CONTEXT       = 1114):
alias(MEVC_NOT_AVAILABLE             = 1115):
alias(MEVC_NO_CLIENT                 = 1116):
alias(MEVC_UNKNOWN_SLOT              = 1117):
alias(MEVC_UNKNOWN_NAMED_SLOT        = 1118):
alias(MEVC_INDEX_DIMENSION           = 1119):
alias(MEVC_NO_MOD_INVERSE            = 1120):
alias(MEVC_NO_PROTOCOL               = 1121):
alias(MEVC_MISSING_TCOV_MODE         = 1122):
alias(MEVC_ILLEGAL_ASSIGNMENT        = 1123):
alias(MEVC_OUTPUT_ERROR              = 1124):

alias(MEVC_OWN_ERR_MESS              = 1202):

alias(MEVC_OUT_OF_MEMORY             = 1300):
alias(MEVC_OUT_OF_MEMORY_INTERN      = 1301):
alias(MEVC_OUTPUT_RECURSION          = 1302):
alias(MEVC_TIME_EXEEDED              = 1320):

alias(MEVC_THROW_LASTERROR           = 1400):

alias(MEVC_PA_EOF                    =  2000):
alias(MEVC_PA_NO_EOF                 =  2001):
alias(MEVC_PA_ILLEGAL_CHAR           =  2002):
alias(MEVC_PA_DELETED                =  2003):
alias(MEVC_PA_INSERTED               =  2004):
alias(MEVC_PA_ILLEGAL_LHS            =  2005):
alias(MEVC_PA_PROC_OPTION            =  2006):
alias(MEVC_PA_PROC_2NAMES            =  2007):
alias(MEVC_PA_DOM_2INHERITS          =  2008):
alias(MEVC_PA_CONTINUATION           =  2009):
alias(MEVC_PA_ALIAS_PROBLEM          =  2010):

alias(MEVC_WARN_VAR_INIT             =  -1000):
alias(MEVC_WARN_QUIT                 =  -1001):
alias(MEVC_WARN_DEBUG                =  -1002):
alias(MEVC_WARN_LEX_PE               =  -1003):
alias(MEVC_WARN_DEAD_PE              =  -1004):
alias(MEVC_USER_DEFINED_WARNING      =  -1005):

alias(MEVC_WARN_DUMB_TERMINAL        =  -1201):

alias(MEVC_WARN_PA_ESCAPED_CHAR      =  -2001):
alias(MEVC_WARN_PA_ENVVAR            =  -2002):


prog::error:=
  proc(x)
    local k;
  begin
    if type(x) = DOM_INT then
      if contains(prog::errorMessages, x) then
        prog::errorMessages[x]
//      elif x > 0 and x < 1000 then
//        "PARI error"
      else
        FAIL
      end_if
    elif type(x) = DOM_STRING then
      for k in prog::errorMessages do
        if x = op(k, 2) then
          return(op(k, 1))
        end_if
      end_for;
      FAIL
    else
      error("illegal argument")
    end_if
  end_proc:

prog::errorMessages:=
  table(
        MEVC_USER_DEFINED_ERROR       = "",
        MEVC_ILLEGAL_OPERAND          = "Illegal operand",
        MEVC_STMT_IN_EXPR             = "Expression expected",
        MEVC_CANT_EVAL_BOOL           = "Can't evaluate to boolean",
        MEVC_WRONG_NUMBER_OF_ARGS     = "Wrong number of arguments",
        MEVC_ILLEGAL_ARGUMENT         = "Illegal argument",
        MEVC_REAL_NUMBER_EXPECTED     = "Real number expected",
        MEVC_IO_WRITE_ERROR           = "Can't write to file \"%s\"",
        MEVC_IO_READ_ERROR            = "Can't read from file \"%s\"",
        MEVC_ERROR                    = "Unknown error",
        MEVC_SIGN_ERROR               = "Invalid sign",
        MEVC_RECURSIV_DEFINITION      = "Recursive definition",
        MEVC_INVALID_ASSIGNMENT       = "Invalid left-hand side",
        MEVC_OUT_OF_RANGE             = "Argument out of range",
        MEVC_INVALID_RANGE            = "Incompatible arguments in range",
        MEVC_INDEX_RANGE              = "Index out of range",
        MEVC_INDEX_DIMENSION          = "Index dimension mismatch",
        MEVC_INDEX_TYP                = "Illegal index type",
        MEVC_INTEGER_NUMBER_EXPECTED  = "Integer expected",
        MEVC_POS_INTEGER_EXPECTED     = "Positive integer expected",
        MEVC_SYSTEM_ERROR             = "Internal system failure",
        MEVC_OPERAND_DOES_NOT_EXIST   = "Specified operand doesn't exist",
        MEVC_INVALID_INDEX            = "Invalid index",
        MEVC_SUBSTITUTION_NOT_ALLOWED = "Substitution not allowed",
        MEVC_STRING_TOO_LONG          = "String too long",
        MEVC_INVALID_FUNCTION         = "Invalid function",
        MEVC_UNKNOWN_OPERATOR         = "Unknown operator",
        MEVC_DIMENSION                = "Array dimension not a positive integer",
        MEVC_DIVISION_BY_ZERO         = "Division by zero",
        MEVC_INTEGER_TOO_LARGE        = "Integer too large in context",
        MEVC_UNKNOWN_OPTION           = "Unknown option",
        MEVC_NO_INDETS                = "No indeterminates",
        MEVC_ILLEGAL_INDET            = "Illegal indeterminate",
        MEVC_NO_POLYNOMIAL            = "Polynomial expected",
        MEVC_UNKNOWN_TYPE             = "Unknown type",
        MEVC_CONTEXT_NOT_ALLOWED      = "Function call not allowed on interactive level",
        MEVC_RETURNVALUE_NOT_ALLOWED  = "Returned value has illegal type",
        MEVC_NOT_IMPLEMENTED          = "Not yet implemented",
        MEVC_MISSING_DOM_ATTR         = "Domain attribute \"%s\" missing",
        MEVC_DELETE_PARENT_FRAME      = "Cannot delete the current or a parent frame",
        MEVC_UNKNOWN_EXTERN_OBJECT    = "Unknown external object",
        MEVC_INTERUPTED_BY_USER       = "Computation aborted",
        MEVC_IDENTIFIER_EXPECTED      = "Identifier expected (check aliases)",
        MEVC_RESET_IN_USER_PROC       = "Can't 'reset' in procedures",
        MEVC_OUT_OF_MEMORY            = "Out of memory",
        MEVC_OUT_OF_MEMORY_INTERN     = "Out of memory",
        MEVC_UNKNOWN_MCODE_OBJECT     = "Unknown MCODE object \"%d\" in object \"%s\"= ",
        MEVC_UNKNOWN_MCODE_REFERENCE  = "Unknown reference reading MCODE",
        MEVC_WRONG_MCODE_OBJECT       = "Reading wrong MCODE object expecting a \"%s\" object",
        MEVC_EXPONENT_OVERFLOW        = "Exponent overflow",
        MEVC_WRONG_EXEC               = "Wrong type of DOM_EXEC object",
        MEVC_POSITIVE_VALUE_EXPECTED  = "Positive value expected",
        MEVC_INTERNAL_ERROR           = "Internal error. Please visit the web page http://www.mathworks.com/support/contact_us/index.html for technical support",
        MEVC_FATAL_ERROR              = "Internal failure can't resume! Kernel stopped",
        MEVC_ILLEGAL_CONTEXT          = "Illegal context",
        MEVC_COEFF_RING               = "Illegal coefficient ring \"%s\" missing",
        MEVC_ILLEGAL_COEFFRING        = "Illegal coefficient ring",
        MEVC_BAD_UNKNOWN              = "Unexpected boolean UNKNOWN",
        MEVC_WATCHDOG                 = "Watchdog reset",
        MEVC_ARGUMENT_FAILED          = "Evaluation of argument failed",
        MEVC_WRITE_PROTECED_ASSIGNMENT= "Identifier '%s' is protected",
        MEVC_NO_ATOMAR_TYPE           = "No atomar type",
        MEVC_ILLEGAL_VAR              = "Invalid variable",
        MEVC_ILLEGAL_VAR_WITH_NAME    = "Invalid variable \"%s\"",
        MEVC_SINGULARITY              = "Singularity",
        MEVC_SECURITY_ALERT           = "Secure engine, permission denied",
        MEVC_NON_NEG_INTEGER          = "Non-negative integer expected",
        MEVC_DUPLICATE_DOMAIN_KEY     = "Domain key already exists",
        MEVC_ILLEGAL_DOMAIN_KEY       = "Empty or duplicate domain key",
        MEVC_NUMERICAL_SORTKEY_EXPECTED= "Numerical sort key expected",
        MEVC_ILLEGAL_PARSER_CONFIG    = "Illegal parser configuration",
        MEVC_ILLEGAL_VAR_CONTEXT      = "Illegal variable context",
        MEVC_NOT_AVAILABLE            = "Function not available for this client",
        MEVC_NO_CLIENT                = "No such client",
        MEVC_UNKNOWN_SLOT             = "Unknown slot",
        MEVC_UNKNOWN_NAMED_SLOT       = "Unknown slot \"%s\"",
        MEVC_IDENT_HAS_VALUE          = "Identifier has a value",
        MEVC_OWN_ERR_MESS             = "%s",
        MEVC_PA_EOF                   = "Unexpected end of input in %s",
        MEVC_PA_NO_EOF                = "End of input expected",
        MEVC_PA_ILLEGAL_CHAR          = "Illegal character '%c'",
        MEVC_PA_DELETED               = "Unexpected '%s'",
        MEVC_PA_INSERTED              = "'%s' expected",
        MEVC_PA_PROC_OPTION           = "Unknown procedure option '%s'",
        MEVC_PA_ILLEGAL_LHS           = "Invalid left-hand side in assignment",
        MEVC_PA_PROC_2NAMES           = "Multiple procedure names ignored",
        MEVC_PA_DOM_2INHERITS         = "Multiple inherited domains ignored",
        MEVC_PA_CONTINUATION          = "Unexpected character after \\",
        MEVC_PA_ALIAS_PROBLEM         = "Aliased identifier illegal at this place",
        MEVC_OUTPUT_RECURSION         = "Infinite recursion in output detected",
        MEVC_PATTERN_ERROR            = "%s in pattern",
        MEVC_NO_MOD_INVERSE           = "Modular inverse does not exist",
        MEVC_NO_PROTOCOL              = "protocol only supported in terminal version",
        MEVC_MISSING_TCOV_MODE        = "Kernel must be started in test coverage mode (option -t)",
        MEVC_ILLEGAL_ASSIGNMENT       = "Illegal assignment to loop variable",
        MEVC_OUTPUT_ERROR             = "Unrecoverable output problem",

/* Warnungen */
        
        MEVC_WARN_VAR_INIT            = "Uninitialized variable '%s' used",
        MEVC_WARN_QUIT                = "Quit the engine via the user interface",
        MEVC_WARN_DEBUG               = "Debugging is not supported",
        MEVC_WARN_PA_ESCAPED_CHAR     = "Unexpected escape character '\\%c' in string",
        MEVC_WARN_PA_ENVVAR           = "Former environment variable '%s' used as local",
        MEVC_WARN_LEX_PE              = "Procedure '%s' is referring outer lexical closure",
        MEVC_WARN_DEAD_PE             = "Found dead closure of procedure '%s'",
        MEVC_WARN_DUMB_TERMINAL       = "Dumb terminal: Plot data saved in binary file save.mp",
        MEVC_TIME_EXEEDED             = "Execution time exceeded",
        MEVC_USER_DEFINED_WARNING     = ""
        ):
