//    

// kg, 14/02/95 

/*++
prog::makeBinLib -- make binary library

prog::makeBinLib(path, fnam)
prog::makeBinLib(path)
prog::makeBinLib()

path - path name (string)
fnam - file name (string)

prog::makeBinLib(p, f) creates the binary library file for file p.f.".mu" and
stores it in p.f.".mb".

prog::makeBinLib() creates all binary library files (.mb files). In each
subdirectory of the library there must be a file 'INDEX' containing the
subdirectories and files contained in that directory. INDEX must be a text
file where each line has one of the forms

d:<dirname>	-- directory
f:<filename>	-- .mu-file

Note that there must not be any white space. The name of a subdirectory must
not contain a seperator like /. The filename must not contain the extension
.mu. (This implies that only  files having the extension .mu may be read.)

The files given by the INDEX file are read and thereby a binary file is
created. 

prog::makeBinLib(p) creates the binary library files for the files given by the
INDEX file contained in the directory given by p.
++*/

prog::makeBinLib:= proc()
    local makeall, compile, sep, 
          path, binf, txtf, preff;
    save PRETTYPRINT;
begin
    if args(0) > 2 then error("wrong no of args") end_if;
    PRETTYPRINT:= FALSE;

    // compile - compile text into binary file 
    compile:= proc(txtf, binf)
        local ex;
    begin
        print(Unquoted, "creating ".binf);
        unalias(); // delete all aliases 
        ex:= fopen(txtf);
        if ex=FAIL then 
           print(Unquoted,"Warning: file ".txtf." not found");
           return();
        end_if;
        txtf:=ex;
        ex:= fopen(binf, Write);
        if ex=FAIL then
           error("Cannot write in ".binf.".")
        end_if;
        binf:=ex;
        while ((ex:= finput(txtf))) <> null() do
            // evaluate alias and unalias statements 
            if domtype(ex) = DOM_EXPR then
                if (contains({hold(alias), hold(unalias), hold(operator)}, op(ex,0)) or
                  op(ex,0) = hold(export) and op(ex,2) = hold(Alias)) and
                   not contains({op(ex)}, hold(Global))
                  then
                    ex;
                    eval(%);
                    next
                end_if
            end_if;
            fprint(binf, ex)
        end_while;
        fclose(binf);
        fclose(txtf);
    end_proc;
    
    /* makeall - reads index file INDEX from directory dir and either
      recurses through subdirectories or reads files, thereby creating
      binary files */
    makeall:= proc(path)
        local idx, l, binf, txtf;
    begin
    	if args(0) = 0 then
	    txtf:= preff.sep."INDEX";
    	else
	    txtf:= preff.pathname(args())."INDEX";
    	end_if;
    	idx:= fopen(txtf);
	if idx = FAIL then
	    error("could not open ".txtf)
	end_if;
    	while ((l:= ftextinput(idx))) <> null() do
    	    l:= text2list(l, [":"]);
    	    if nops(l) <> 3 then next end_if;
    	    if l[1] = "d" then
    	    	makeall(args(), l[3])
    	    elif l[1] = "f" then
    	        l:= l[3];
		if args(0) = 0 then
		    txtf:= preff.sep.l.".mu";
		    binf:= preff.sep.l.".mb";
		else
		    txtf:= preff.pathname(args()).l.".mu";
    	            binf:= preff.pathname(args()).l.".mb";
		end_if;
		compile(txtf, binf);
    	    end_if
    	end_while;
    	fclose(idx);
    end_proc;
    
    // create binary files 
    if args(0) = 0 then
        if sysname() = "MACOS" then sep:= ":" else sep:= "" end_if;
	for preff in LIBPATH do
	    makeall();
	end_for;
    elif args(0) = 1 then
        preff:= args(1);
        if sysname() = "MACOS" then 
            sep:= ":";
            if preff[-1] = ":" then
                preff:= preff[1..-2]
            end_if
        else 
            sep:= "" 
        end_if;
        makeall();
    else
        case sysname()
        of "MACOS" do sep:= ":"; break;
        of "MSDOS" do sep:= "\\"; break;
        of "UNIX" do  sep:= "/";
        end_case;
        
        path:= args(1);
        txtf:= args(2);
	if path[-1] <> sep then
	    path:= path.sep
	end_if;
	binf:= path.txtf.".mb";
	txtf:= path.txtf.".mu";
	compile(txtf, binf);
    end_if;
end_proc:

// end of file 
