/*++
prog::test -- test function

prog::test()
prog::test(a)
prog::test(a, b)
prog::test(a, b, <c>, <Priority = prio_name>, // general status
                      <Priority(failed_result) = status_name ...> // one errors status 
                      <Message(failed_result) = string ...>)    // one errors message

a, b - expressions
c    - string

prog::test prints - depending upon the parameters - the current function
and test number onto the test results file 'test.res'. This signals
an error in the current test.

prog::test() prints the current function and test number unconditional.

prog::test(a) prints the current function and test number if a is not
equal to TRUE or if an error occures during the evaluation of a.

prog::test(a, b) prints the current function and test number if a is not
equal to b (in the sense of _equal) of if an error occures during the
evaluation of a or b.

prog::test(a,b,c) works like prog::test(a, b) but append string c to 
the output.
++*/

prog::acceptedErrors := {"singularity",
                         "Could not open \"INTLIB",
                         "intlib::algebraic::rde has no entry",
                         "not yet supported",
                         "not supported",
                         "no more tokens",
                         // from PseudoTensor
                         "unable to define matrix over Dom::ExpressionField()",
                         "degree too large:",
                         "contains method does not return TRUE or FALSE",
                         "Cannot solve the transformation",
                         "subresultant computation takes too long",
                         "not an ordinary homogeneous linear differential equation over the rational functions",
                         "expecting range x=a..b",
                         "illegal parameters [hypergeom]",
                         "Cannot evaluate indefinite integral at a particular value of the integration variable",
                         "there is no RootOf(...) to apply [ode::applyRootOf]",
                         "dimensions do not match [(Dom::Matrix(Dom::ExpressionField()))::_mult2]",
                         // used inside int as communication
                         "bad result from intlib::algebraic::fieldTower! [intlib::algebraic::int]",
                         "bad substitution [intlib::tryChangeVar]",
                         // generated in intlib
                         "^not a semi-reduced representative! \\[\\(intlib::algebraic::Divisor\\(\\[.+",
                         // used internally in series, after this error it tries the same call with higher order
                         "order too small",
                         // thrown and trapped in series as communication
                         "invalid composition [Series::Puiseux::_fconcat]",
                         // trapped internally in series
                         "illegal substitution: exactly one indeterminate expected [Series::Puiseux::subs]",
                         // trapped in ode::denomAnsatz
                         "argument must be a polynomial in Q[x]. [solvelib::iroots]",
                         // trapped in solve while validating results
                         "Second argument must be integer [surd]",
                         // trapped in testeq when making random substitutions 
                         "1st argument must not be negative [orthpoly::legendre]",
                         "whittakerM is not defined for these parameter values [whittakerM]",
                         "the meijerG function is not defined for the given parameters [meijerG]",
                         "the base must be an identifier, an indexed identifier, or a number of type Type::Positive [log]",
                         "the base must be greater than zero and not equal one [log]",
                         // trapped in solve when floating results (happens if input contains floats)
                         "symbolic parameters not allowed in non-polynomial equations [numeric::solve]",
                         // happens in piecewise::evalAssuming:
                         "Inconsistent properties detected. [property::_setAssumptions]",
                         "Inconsistent assumptions detected. [property::_setgroup]",
                         // trapped in numeric::fsolve
                         "cannot evaluate function at left boundary [numeric::realroot]",
                         // ode calls groebner::poly with illegal coefficients
                         "coefficients must be rational [groebner::test_poly]",
                         // ignore singularities
                         "whittakerM is not defined for these parameter values [whittakerM::float]",
                         // NUMERIC/TEST/cSpline.tst
                         "expecting a specification [nonnegative integer]  for the derivative, received [0.0 ... 0.0] [S]",
                         "expecting a specification [nonnegative integer]  for the derivative, received [1.0 ... 1.0] [S]",
                         "expecting a specification [nonnegative integer]  for the derivative, received [2.0 ... 2.0] [S]",
                         "expecting a specification [nonnegative integer]  for the derivative, received [3.0 ... 3.0] [S]",
                         "expecting a specification [nonnegative integer]  for the derivative, received [4.0 ... 4.0] [S]",
                         // MathXMLContent
                         "\"row\" -> MuPAD: not yet implemented",
                         // Matrix constructor is called in hope of a usefeul result
                         "invalid argument [(Dom::MatrixGroup(2, 2, Dom::Integer))::new]"
                         }:

prog::test:=
  proc(stmt, result = TRUE)
    option hold;
    local
          deleteName,        // to delete unwanted procedure names
          r,                 // evaluated stmt
          res,               // evaluated result
          ERR,               // error while evaluating stmt
          ERRes,             // error while evaluating result
          printMessage, TE, printTeX,
          TIME,              // time for evaluation of stmt
          OLDMEM,            // memory usage at the beginning
          OPTS,              // table collecting options
          Priorities,        // all valid priorities
          allOptions,        // valid option names
          method,            // comparison function
          compare,           // compare of stmt and res
          v,                 // variable to print
          index,             // for trimming down error strings
          warnings,          // for collecting
          warningsOK,        // do observed and expected warnings (patterns) match?
          replaceSpecials,   // method for replacing \n, \t, \ b, \r in a string
          i;                 // loop variable
    save warning, error;
  begin
    // all valid status strings
    Priorities := {"Low", "Medium", "High"}:
    // valid option names
    allOptions := table(Message=FAIL, 
                        TrapError=FAIL, 
                        Timeout=FAIL, 
                        Method=FAIL, 
                        Baseline = FALSE,
                        Priority=FAIL,
                        Developers=FAIL,
                        BugId=FAIL,
                        ExpectedWarnings=[],
                        Enhancement=#progTestInternal):
  
    replaceSpecials := x -> stringlib::subs(x, "\n"="\\n", "\b"="\\b", "\t"="\\t", "\r"="");

    // procedure to decide whether a typeset formula
    // should appear in the HTML output and to print it in this case
    printTeX :=
    proc(typ, ex)
    begin
      if strmatch(Pref::userOptions(), ",TEXOUTPUT=TRUE") and
        not type(ex) in {DOM_INT, DOM_FLOAT, DOM_BOOL, DOM_STRING} and
        not(type(ex) = "_equal" and op(ex, 1) = TrapError) then
        fprint(Unquoted, 0, typ, "/TeX: ",
          replaceSpecials(generate::TeX(ex)));
      end_if;
    end_proc;
      
    // procedure to print out error messages
    printMessage:=
      proc(input, expected, eval_expected, got, expectedWarnings, gotWarnings, ok)
        option hold; // to allow null()
        name prog::test;
        local baseline, enhancement, enhancementDone, k;
        // uses OPTS, ERR, and ERRes from outer procedure
      begin
        input := context(input);
        expected := context(expected);
        eval_expected := context(eval_expected);
        got := context(got);
        expectedWarnings := context(expectedWarnings);
        gotWarnings := context(gotWarnings);
        ok := context(ok);
        
        baseline := OPTS[Baseline];
        enhancement := bool(OPTS[Enhancement] <> #progTestInternal);
        enhancementDone := _lazy_and(enhancement,
          bool(got = OPTS[Enhancement]));
        if enhancementDone then
          ok := TRUE;
        end_if;
        
        if bool(ok)=TRUE then
          // doesn't look like an error
          if baseline or enhancement then
            if baseline then
              fprint(Unquoted, 0, "Error fixed: ", 
                prog::TestFunc, " ", prog::TestNo);
            elif enhancementDone then
              fprint(Unquoted, 0, "Enhancement done: ", 
                prog::TestFunc, " ", prog::TestNo);
            else
              sysassign(prog::TestEnhancementCount, prog::TestEnhancementCount + 1);
              fprint(Unquoted, 0, "Enhancement request: ",
                prog::TestFunc, " ", prog::TestNo);
            end_if;
            fprint(Unquoted, 0, "Input: ", 
              stringlib::collapseWhitespace(expr2text(input)));
            fprint(Unquoted, 0,   "Got:       ", // Spaces for alignment with Expected:/Requested:
              replaceSpecials(expr2text(got)));
            printTeX("Got", got);
            if enhancement then
              fprint(Unquoted, 0, "Requested: ",
                replaceSpecials(expr2text(OPTS[Enhancement])));
              printTeX("Requested", OPTS[Enhancement]);
            end_if;
            for k in [Timeout, Method, Priority, Message, Developers, BugId] do
              v := null();
              if contains(OPTS, k(got)) then
                v := OPTS[k(got)];
              elif OPTS[k] <> FAIL then
                v := OPTS[k];
              end_if;
              if v <> null() then
                if v::dom in {DOM_PROC, DOM_FUNC_ENV} and
                  eval(text2expr(prog::getname(v))) = v then
                  v := prog::getname(v)
                end_if;
                if k = Timeout then
                  v := expr2text(round(v, 3))." (".round(v/prog::ntime(), 3)."*prog::ntime())"
                end_if;
                fprint(Unquoted, 0, k, ": ", v);
              end_if;
            end_for;
            if prog::TestFunc <> "interactive" then
              fprint(Unquoted, 0, "Near line: ", stdlib::src_line());
            end_if;
            if TIME > 50 then
              fprint(Unquoted, 0, "Used Time: ".round(TIME/1000, 3)." (".round(TIME/1000/prog::ntime(), 3)."*prog::ntime())");
            end_if;
            if domtype(INPUTLINENO) = DOM_INT and INPUTLINENO>0 then
              fprint(Unquoted, 0, "Line: ", INPUTLINENO);
            end_if;
            fprint(Unquoted, 0, "");
          end_if;
        else
          sysassign(prog::TestErrorCount, prog::TestErrorCount + 1); // count errors
          // got <> expected, error
          if baseline then
            sysassign(prog::TestBaseErrorCount, prog::TestBaseErrorCount + 1); // count baseline errors
          end_if;
          fprint(Unquoted, 0,
            if baseline then "Baseline " end_if,
            "Error in test ", 
            prog::TestFunc, " ", prog::TestNo);
          fprint(Unquoted, 0, "Input: ",
            stringlib::collapseWhitespace(expr2text(input)));
          fprint(Unquoted, 0, "Expected:  ",
            replaceSpecials(expr2text(eval_expected)));
          printTeX("Expected", eval_expected);
          fprint(Unquoted, 0, "Got:       ", // Spaces for alignment with Expected:/Requested:
            replaceSpecials(expr2text(got)));
          printTeX("Got", got);
          if expectedWarnings <> gotWarnings then
            fprint(Unquoted, 0, "Expected warnings: ",
              expr2text(expectedWarnings));
            fprint(Unquoted, 0, "Got warnings:      ",
              expr2text(gotWarnings));
          end_if;          
          for k in [Timeout, Method, Priority, Message, Developers, BugId] do
            v := null();
            if contains(OPTS, k(got)) then
              v := OPTS[k(got)];
            elif OPTS[k] <> FAIL then
              v := OPTS[k];
            end_if;
            if v <> null() then
              if v::dom in {DOM_PROC, DOM_FUNC_ENV} and
                eval(text2expr(prog::getname(v))) = v then
                v := prog::getname(v)
              end_if;
              if k = Timeout then
                v := expr2text(round(v, 3))." (".round(v/prog::ntime(), 3)."*prog::ntime())"
              end_if;
              fprint(Unquoted, 0, k, ": ", v);
            end_if;
          end_for;
          if prog::TestFunc <> "interactive" then
            fprint(Unquoted, 0, "Near line: ", stdlib::src_line());
          end_if;
          if TIME > 50 then
            fprint(Unquoted, 0, "Used Time: ".round(TIME/1000, 3)." (".round(TIME/1000/prog::ntime(), 3)."*prog::ntime())");
          end_if;
          if domtype(INPUTLINENO) = DOM_INT and INPUTLINENO>0 then
            fprint(Unquoted, 0, "Line: ", INPUTLINENO);
          end_if;
          if // not baseline and
// WRITENEWFAILURES is still only used in Test 2.0, but not in Test 3.0
            strmatch(Pref::userOptions(), "WRITENEWFAILURES") then
            fprint(Unquoted, 0, "----- input start -----");
            traperror((
            // write(0); // write in text mode is badly broken
            for v in anames(All, User) minus {INPUTLINENO} do
              if [eval(v)] = expr([eval(v)]) then
                fprint(Unquoted, 0, v, " := hold(", expr2text(eval(v)), "):\n");
              else
                fprint(Unquoted, 0, "// ", v, " = ", eval(v),
                  "\nstdlib::from64(", expr2text(eval(hold(stdlib::to64)(v))), "):\n");
              end_if;
            end;
        
            v := showprop(anames(Properties));
            if v <> [] then
              fprint(Unquoted, 0, "assume(", expr2text(_and(op(v))), "):\n");
            end;

            context(hold(fprint(Unquoted, 0, "prog::test(".expr2text(args()).")")))));
            fprint(Unquoted, 0, "----- input end -----");
          end_if;
          fprint(Unquoted, 0, "");
        end_if;
      end_proc;
      
    // no name for test
    if prog::TestFunc = FAIL then
      userinfo(10, "test function not defined (interactive mode)");
      sysassign(prog::TestFunc, "interactive");
      sysassign(prog::TestNo, 1)
    end_if;
    
    // global test counter
    userinfo(Text, 10, "count the test '", stmt = result, "'");
    sysassign(prog::TestCount, prog::TestCount + 1);

    //////////////////////////////////////////////////////////////////////
    // collect and check additional arguments
    // evaluate additional arguments
    [OPTS, r]:= prog::getOptions(3, context([FAIL, FAIL, args(3..args(0))]), allOptions);
    for i in r do
      if testtype(i, DOM_STRING) then
      // append single comment (without 'Message = comment')
        OPTS[Message]:= i;
      elif testtype(i, "_equal") and testtype(op(i, 1), DOM_EXPR) and
           op(i, [1, 0]) = Message then
        OPTS[op(i, 1)]:= op(i, 2);
      else
        error("wrong type of additional arguments");
      end_if;
    end_for;
    
    if type(result) = "_equal" and context(op(result, 1)) = hold(TrapError) then
      TE:= context(op(result, 2));
    else
      TE:= 0
    end_if;

    // init time and results
    TIME:= 0; r:= FAIL; res:= FAIL;
    OLDMEM := bytes()[1];
    userinfo(Text, 1, "testing '", prog::TestFunc, "' ", prog::TestNo);
    if args(0) = 0 then
      // support obsolete behaviour
      print(prog::TestNo);
      sysassign(prog::TestNo, prog::TestNo - 1)
    else // standard
      userinfo(Text, 2,"  for ",stmt," = ",_if(TE > 0,  "Error No. ".expr2text(TE), result));
      
      if OPTS[Timeout] <> FAIL and
         not testtype(OPTS[Timeout], Type::PosInt) then
        traperror((OPTS[Timeout] := float(OPTS[Timeout])));
        if not testtype(OPTS[Timeout], Type::Positive) then
          error("Timeout value has to be a positive value");
        end_if;
      end_if;
      
      // collect warnings, to compare
      warnings := [];
      sysassign(warning, proc(str)
                         begin
                           warnings := warnings.[str];
                           null();
                         end_proc);

      // evaluate stmt and result and keep
      // result, time and error code if it fails
      if testtype(OPTS[Timeout], Type::Positive) then
        ERR:= traperror((TIME:= time((r:= context(stmt)))), ceil(1.3*OPTS[Timeout]));
        if ERR <> 0 then ERR := getlasterror(); 
        elif TIME/1000.0 > OPTS[Timeout] then
          ERR := [1320, "minor timeout: took ".round(TIME/1000.0, 3)." sec (".round(TIME/(1000.0*prog::ntime()), 3)."*prog::ntime())"];
///        elif TIME/1000.0 < 0.4*OPTS[Timeout] and OPTS[Timeout] > 5 then
///          warnings := warnings.["Timeout overly gracious: only needed ".round(TIME/1000.0, 3)." sec (".round(TIME/(1000.0*prog::ntime()), 3)."*prog::ntime())"];
        end;
        ERRes:= traperror((res:= context(result)), ceil(OPTS[Timeout]));
        if ERRes <> 0 then ERRes := getlasterror(); end;
      else
        ERR:= traperror((TIME:= time((r:= context(stmt)))));
        if ERR <> 0 then ERR := getlasterror(); end;
        ERRes:= traperror((res:= context(result)));
        if ERRes <> 0 then ERRes := getlasterror(); end;
      end_if;
      
      if ERR <> 0 then
        index := strmatch(ERR[2], ";[\r\n ]*while reading file ", Index);
        if index <> FALSE then
          ERR[2][index[1]..-1] := "";
        end_if;
      end_if;
      if ERRes <> 0 then
        index := strmatch(ERRes[2], ";[\r\n ]*while reading file ", Index);
        if index <> FALSE then
          ERRes[2][index[1]..-1] := "";
        end_if;
      end_if;

      if ERR <> 0 then
        // we don't want to see a warning if we already see the corresponding error
        warnings := select(warnings,
                           x -> (if strmatch(x, "^got error: ") then
                                   x := x[12..-1];
                                 end_if;
                                 not strmatch(stringlib::subs(ERR[2], "\r"=""),
                                              stringlib::maskMeta(x))))
      end_if;
      
      // local procedure deleteName
      // this is to handle the following problem:
      // if stmt is a procedure without name, assigning context(stmt)
      // to some local var r will change the name, such that
      // prog::test(x -> x, x -> x)
      // might not work
      deleteName :=
      proc(flist, originallist)
        local f, original;
      begin
        f:= op(flist);
        original:= op(originallist);
        if domtype(f) = DOM_PROC and domtype(original) = DOM_PROC then
          subsop(f, 6 = op(original, 6))
        else
          f
        end_if
      end_proc;
      
      if domtype(OPTS[ExpectedWarnings]) <> DOM_LIST then
        error("ExpectedWarnings must be a list of strings.");
      end_if;
      
      warningsOK := TRUE;
      if nops(warnings) <> nops(OPTS[ExpectedWarnings]) then
        warningsOK := FALSE;
      else
        zip(warnings, OPTS[ExpectedWarnings],
          (w, ex) -> if w <> ex and not strmatch(w, "^".ex."$") then warningsOK := FALSE end_if);
      end_if;
      
      if domtype(ERR) = DOM_LIST and domtype(TE) = DOM_LIST then
        if ERR[2] <> TE[2] and (strmatch(ERR[2], "^".stringlib::maskMeta(TE[2])."( \\[anonymous\\])?$") or strmatch(ERR[2], "^".TE[2]."( \\[anonymous\\])?$")) then TE[2] := ERR[2]; end_if;
      end_if;
      
      if ERR <> TE and not (domtype(ERR)=DOM_LIST and ERR[1] = TE) then
        printMessage(stmt, result, res, TrapError = ERR, OPTS[ExpectedWarnings], warnings, FALSE);
      elif ERRes <> 0 then
        printMessage(stmt, result,
          stdlib::Exposed("Error evaluating expected result: ".ERRes),
          stdlib::Exposed("Error evaluating expected result: ".ERRes),
          OPTS[ExpectedWarnings], warnings, FALSE);
      elif (ERR = TE or (domtype(ERR)=DOM_LIST and ERR[1] = TE)) and ERR <> 0 then
        printMessage(stmt, TrapError = TE, TrapError = TE, TrapError = ERR,
          OPTS[ExpectedWarnings], warnings, warningsOK);
      else
        if testtype(OPTS[Method], Type::Function) then
          method := OPTS[Method];
        elif prog::testmethod() <> FAIL then
          method := prog::testmethod();
        else
          method := _equal;
        end_if;
        if ((TE := traperror((compare := method(deleteName([r], [stmt]), // remove name from procedures
                                                deleteName([res], [result])))))) <> 0 then
          printMessage(stmt, result, res,
            stdlib::Exposed("Error while comparing: ".TE),
            OPTS[ExpectedWarnings], warnings, FALSE);
        else
          printMessage(stmt, result, res, r,
            OPTS[ExpectedWarnings], warnings,
            compare and warningsOK);
        end_if
      end_if;
    end_if;
    
    sysassign(prog::TestNo, prog::TestNo + 1);
    sysassign(prog::TestTime, prog::TestTime + TIME);

    prog::clearRememberFuncs();

    /* Heuristic to find good timeout values based on latest experiments 
       in 'ode'. Values should be double-checked on arch win32 for further 
       adjustment.  
    
    TIME:= TIME/(1000*prog::ntime());
    if TIME < 1 then 
      TIME:= 10.0;
    elif TIME < 10 then 
      TIME:= 20;
    elif TIME < 50 then 
      TIME:= 1.6*TIME;
    else
      TIME:= 1.3*TIME;
    end_if;
    print((Timeout = ceil(TIME)*hold(prog::ntime)()));
    
    */

    
    
    null()
  end_proc:

prog::setcheckglobals(prog::test, {hold(INPUTLINENO)}):
