/*
prog::testexit -- exit testing

prog::testexit()

Close test results file.
*/

prog::testexit:=
  proc()
    local TIME, ntime, ntimearg, F, exitHandler;
  begin
    exitHandler := Pref::callOnExit():
    if domtype(exitHandler) = DOM_LIST then
      exitHandler := select(exitHandler, `<>`, prog::testexit());
    else
      exitHandler := NIL;
    end_if;
    Pref::callOnExit(exitHandler);
    
    Pref::maxMem(0);
    
    // move new table with error states to the default place
    sysassign(prog::TestErrorTable, prog::TestErrorTableNew);
    sysassign(prog::TestErrorTableNew, table());
    
    if contains({prog::TestInitTime, prog::TestTime}, FAIL) then
      error("prog::testexit used without prior call of prog::testinit");
    end_if;
    
    TIME:= time() - prog::TestInitTime; // gesamte Test-Zeit
    F:= X -> stringlib::formatf(float(X), 1);

    // normalized time factor
    ntime:= prog::ntime();
    
    if debug() = TRUE then // kernel is running in debug mode
      ntime := ntime*1.1
    end_if;

    // difference between whole test time and testtime inside of 'prog::test'
    if (TIME + prog::TestTime) > 0 and TIME/(TIME + prog::TestTime) > 0.66 then // 2 times long
      fprint(Unquoted, 0, "Info: time used outside of 'prog::test' takes ".
                          expr2text(trunc(TIME/(TIME + prog::TestTime)*100)) ."%")
    end_if;
    // take whole test time instead of netto time using by all 'prog::test' calls
    // if option 'All' is given
    if prog::TestFullTime = TRUE then
      sysassign(prog::TestTime, TIME) // whole test time
    end_if;
    
    ntimearg:= prog::TestExpectedTime; // expected time given to 'prog::testinit'

    // interaktiv: Meldung ausgeben
      //Info: somelib::funct - 26 examples,  2 errors, 12 warnings, time: 18.10 s (expected: 25.00 s)
      fprint(Unquoted, 0, "Info: ",
             expr2text(prog::TestCount),
             " test"._if(prog::TestCount = 1, "", "s").", ",
             expr2text(prog::TestErrorCount),
             " error"._if(prog::TestErrorCount = 1, "", "s"),
             if prog::TestBaseErrorCount > 0 then
             " (".prog::TestBaseErrorCount." baseline)"
             end_if,
             if prog::TestEnhancementCount > 0 then
             " (".prog::TestEnhancementCount." enhancement)"
             end_if,
             ", runtime factor ", F(prog::TestTime/1000/ntime),
             _if(ntimearg <> 0,
                 ("  (expected ", F(ntimearg/1000), ")"),
                 "  (nothing expected)")
             //," (testing and loading overhead", F((TIME - prog::TestTime)/1000/ntime), ")"
            );
    fprint(Unquoted, 0, "Info: CPU time: ", F(time()/1000), " s");

    fprint(Unquoted, 0, "Info: Memory allocation ".(bytes()[3])." bytes [prog::testexit]");

    // reset all global values for next test
    sysassign(prog::TestNo, 1);
    sysassign(prog::TestFunc, FAIL);
    sysassign(prog::TestErrorCount, 0);
    sysassign(prog::TestCount, 0);
    sysassign(prog::TestExpectedTime, 0);
    sysassign(prog::TestFullTime, FALSE);
    null()
  end_proc:

