// 

// 07/2003
// utility to print error message for the test mechanism
// -undocumented-

prog::timererror :=
  proc(today, expected = 1.0)
  local mywarning, info;
  begin
    mywarning:= warning;
    mywarning:= txt -> fprint(Unquoted, 0, txt);
    if domtype(today) = DOM_STRING then
      info:= today;
      if strmatch(today, "faster") <> FALSE then
        today := .3;
        info:= ""; // switching off the "faster" warnings
      elif strmatch(today, "slower") <> FALSE then
        today := 3
      else
        today := 1;
        fprint(Unquoted, 0, "Error*Timer* ".info)
      end_if
    else
      info:= "";
    end_if;
    if today >= 2*expected then
      // slower than expected
      if prog::TestQuiet <> TRUE then
        // interactive message
        if length(info) > 0 then
         mywarning(info);
        else
         mywarning("'".(if prog::TestFunc <> FAIL then
                          prog::getname(prog::TestFunc)
                        else
                          "tested function"
                        end_if).
                   "' slower than expected")
        end_if;
      end_if
    elif today <= 0.5*expected then
      // faster than expected
      if prog::TestOldErrors <> FAIL then
        // called from Test
        fprint(Unquoted, 0, "Error*Timer* ".info)
      end_if;
      if prog::TestQuiet <> TRUE then
        // interactive message
        if length(info) > 0 then
          mywarning(info);
        else
/* switching off the 'faster' warnings
         mywarning("'".(if prog::TestFunc <> FAIL then
                          prog::getname(prog::TestFunc)
                        else
                          "tested function"
                        end_if).
                "' faster than expected")
*/
         end_if;
      end_if
    end_if;
    null()
  end_proc:
