/*  */

/* cond2set.mu
 * Eine Bedingung in eine Obermenge fr einen Bezeichner umschreiben
 */

property::_cond2set := proc( cond, ident, constant=TRUE, setlookup=table() )
  option remember;
  local X, res, i, v,
    lb, rb, mb, A, solve_equal, solve_leequal, solve_less, solve_real,
    reduce_X_in_set, p;
begin
  /* if ident is identifier substitute ident by a genident */
  if type(ident)<>DOM_IDENT then
    X := genident();
    cond := subsex( cond, ident=X, Unsimplified );
    if indets(cond) intersect indets(ident) minus Type::ConstantIdents <> {} then return(FAIL); end_if;
    ident := X;
  end_if;

  if not has(cond,ident) then return( FAIL ); end_if;

  /* TODO: Remove this block, see property::_insertAssumption. */
  if contains( {"_less","_leequal", "_equal", "_unequal"}, type(cond) ) then
    if contains( {"_less","_leequal", "_equal", "_unequal"}, type(op(cond,1)) ) then
      v := select( { property::_cond2set( op(cond,1), ident, constant, setlookup ), property::_cond2set( subsop(cond,1=op(cond,[1,2])), ident, constant, setlookup ) }, _unequal, FAIL );
      if nops(v)=0 then return( FAIL ); else return( op(v) ); end_if;
    end_if;
    if contains( {"_less","_leequal", "_equal", "_unequal"}, type(op(cond,2)) ) then
      v := select( { property::_cond2set( op(cond,2), ident, constant, setlookup ), property::_cond2set( subsop(cond,2=op(cond,[2,1])), ident, constant, setlookup ) }, _unequal, FAIL );
      if nops(v)=0 then return( FAIL ); else return( op(v) ); end_if;
    end_if;
  end_if;

  reduce_X_in_set := proc( xpr, set, X )
    local lin, p, a, b, c, v,
      s;
  begin
    if xpr=X then return([set]); end_if;
    if not has(xpr,X) then
      if not testtype(xpr,Type::Constant) then return( [] ); end_if;
      case property::_decide( xpr in set )
        of FALSE do
          return( [{}] );
        of TRUE do
        of UNKNOWN do
          return( [] );
      end_case;
    end_if;

    /* check if xpr is linear in X */
    if type(X)=DOM_IDENT and ( lin := Type::Linear( xpr, [X] ) )<>FALSE then
      if lin[1]<>0 then
        if indets(lin) minus Type::ConstantIdents={} or type(set)=DOM_SET and indets(lin[1]) minus Type::ConstantIdents={} then
          return( [(set-lin[2])/lin[1]] );
        else
          return([]);
        end_if;
      end_if;
    end_if;

    /* check if xpr is quadratic */
    if type(X)=DOM_IDENT and ( p := poly( xpr, [X] ) )<>FAIL then
      if not has(coeff(p,0),X) and degree(p)=2 then
        // a x^2 + b x + c in set
        a := coeff(p,2);
        b := coeff(p,1);
        c := coeff(p,0);
        // ( x+ b/2a )^2 + c/a - b^2/a^2/4 in set/a
        v := set/a -c/a + b^2/a^2/4;
        if type(v)=DOM_SET and iszero(a)=FALSE and indets(a) minus Type::ConstantIdents = {} then
          return(reduce_X_in_set(X+b/2/a, sqrt(v) union -sqrt(v), X));
        end_if;
      end_if;
    end_if;

    case type(xpr)
      of "Im" do
        if set={0} then
          return(reduce_X_in_set( op(xpr), R_, X ));
        end_if;
        break;
      of "Re" do
        if set={0} then
          return(reduce_X_in_set( op(xpr), I*R_, X ));
        end_if;
        break;
      of "_mod" do
        if type(op(xpr,2))<>DOM_INT then break; end_if;
        return( reduce_X_in_set( op(xpr,1), set + op(xpr,2)*Z_, X ) );
      of "_plus" do
        s := split( xpr, Y->not has( Y, X ) );
        assert( s[3]=0 );
        if s[1]<>0 then
          return( reduce_X_in_set( s[2], set - s[1], X ) );
        end_if;
        break;
      of "_mult" do
        s := split( xpr, Y->not has( Y, X ) );
        assert( s[3]=1 );
        if s[1]<>1 and s[1]<>0 and indets(s[1]) minus Type::ConstantIdents={} then
          return( reduce_X_in_set( s[2], set / s[1], X ) );
        end_if;
        break;
      of "_power" do
        if type(op(xpr,2))=DOM_INT then
          if op(xpr,2)=-1 then
            return( reduce_X_in_set( op(xpr,1), 1/set, X ) );
          end_if;
        end_if;
        break;
    end_case;

    return( [] );
  end_proc:

  solve_equal := proc( xpr, target )
    local X;
  begin
    return( reduce_X_in_set( xpr, {0}, target ) );
  end_proc:

  solve_less := proc( xpr, target )
    local lhs, rhs, greater,
      lin, rem;
  begin
    greater := FALSE;
    if not has(op(xpr,1),target) then
      greater := TRUE;
      lhs := op(xpr,2);
      rhs := op(xpr,1);
    elif not has(op(xpr,2),target) then
      lhs := op(xpr,1);
      rhs := op(xpr,2);
    else
      lhs := op(xpr,1)-op(xpr,2);
      rhs := 0;
    end_if;
    if lhs=target then
    elif ( lin := Type::Linear( lhs, [target] ) )<>FALSE then
      if iszero(lin[1]) then
        /* lin[1] = 0 means, the identifier does not appear in the term
         * if the value is positive (resp. negative), this means we have a condition like 42<0 */
        lhs := lhs-rhs;
        if contains({DOM_RAT, DOM_FLOAT, DOM_INT}, type(lhs)) and
          (greater and lhs<0 or not greater and lhs>0) then
          return([{}]);
        end_if;
        return([]);
      end_if;
      case property::_decide(lin[1]> 0, table("Constant"=TRUE))
        of TRUE do
          break;
        of FALSE do
          if property::_decide(lin[1] < 0, table("Constant"=TRUE)) = TRUE then
            greater := not greater;
            break;
          end_if;
          return([])
        of UNKNOWN do
          return( [] );
      end_case;
      rhs := (rhs-lin[2])/lin[1];
    else
      if property::_typereal( rhs )=FALSE then return( [] ); end_if;
      if not greater then
        return( reduce_X_in_set( lhs, Dom::Interval( -infinity, rhs ), target ) );
      else
        return( reduce_X_in_set( lhs, Dom::Interval( rhs, infinity ), target ) );
      end_if;
    end_if;
    if property::_typereal( rhs )=FALSE then return( [] ); end_if;
    if not greater then
      [Dom::Interval( -infinity, rhs )];
    else
      [Dom::Interval( rhs, infinity )];
    end_if;
  end_proc;

  solve_leequal := proc( xpr, target )
    local lhs, rhs, greater,
      lin;
  begin
    greater := FALSE;
    if not has(op(xpr,1),target) then
      greater := TRUE;
      lhs := op(xpr,2);
      rhs := op(xpr,1);
    elif not has(op(xpr,2),target) then
      lhs := op(xpr,1);
      rhs := op(xpr,2);
    else
      lhs := op(xpr,1)-op(xpr,2);
      rhs := 0;
    end_if;
    if lhs=target then
    elif ( lin := Type::Linear( lhs, [target] ) )<>FALSE then
      if lin[1]=0 then
        /* lin[1] = 0 means, the identifier does not appear in the term
         * if the value is positive (resp. negative), this means we have a condition like 42<0 */
        lhs := lhs-rhs;
        if contains({DOM_RAT, DOM_FLOAT, DOM_INT}, type(lhs)) and
          (greater and lhs<0 or not greater and lhs>0) then
          return([{}]);
        end_if;
        return([]);
      end_if;
      // lin[1] <> 0
      case property::_decide(lin[1]>0, table("Constant"=TRUE))
        of TRUE do
          break;
        of FALSE do
          if property::_decide(lin[1] < 0, table("Constant"=TRUE)) = TRUE then
            greater := not greater;
            break;
          end_if;
          return([])
        of UNKNOWN do
          return( [] );
      end_case;
      rhs := (rhs-lin[2])/lin[1];
    else
      if property::_typereal( rhs )=FALSE then return( [] ); end_if;
      if not greater then
        return( reduce_X_in_set( lhs, Dom::Interval( -infinity, [rhs] ), target ) );
      else
        return( reduce_X_in_set( lhs, Dom::Interval( [rhs], infinity ), target ) );
      end_if;
    end_if;
    if property::_typereal( rhs )=FALSE then return( [] ); end_if;
    if not greater then
      [Dom::Interval( -infinity, [rhs] )];
    else
      [Dom::Interval( [rhs], infinity )];
    end_if;
  end_proc;

  solve_real := proc( xpr, target )
    local s, ready;
  begin
    repeat
      ready := TRUE;
      if xpr=target then return( [R_] ); end_if;
      case type(xpr)
        of DOM_IDENT do
          return( [] );
        of "abs" do
        of "Re" do
        of "Im" do
        of DOM_RAT do
        of DOM_INT do
        of DOM_FLOAT do
          return( [] );
        of "_power" do
          if op(xpr,2)=-1 then
            /* For speed advance we say 1/x in R_ <=> x in R_ */
            xpr := op(xpr,1);
            ready := FALSE;
          end_if;
          break;
        of "_mult" do
          s := split( xpr, testtype, Type::Real );
          assert( s[3]=1 );
          xpr := s[2];
          if s[1]<>1 and type(xpr)<>"_mult" then ready := FALSE; end_if;
          break;
        of "_plus" do
          s := split( xpr, testtype, Type::Real );
          assert( s[3]=0 );
          xpr := s[2];
          if s[1]<>1 and type(xpr)<>"_plus" then ready := FALSE; end_if;
          break;
      end_case;
    until ready end_repeat;
    return( reduce_X_in_set( xpr, R_, target ) );
  end_proc;

  case type(cond)
    of "_or" do
      v := map( [op(cond)], X->[property::_cond2set(X, ident)] );
      res := [];
      for i in v do
        if contains( i, FAIL )>0 then return( FAIL ); end_if;
        res := res.[ _intersect(op(i)) ];
      end_for;
      if ( nops(res)=0 ) then return( FAIL ); end_if;
      res := _union( op(res) );
      return(res);
    of "_not" do
      /* If the input is "not x in Y" this is equivalent to "x in C_ minus Y" */
      case type(op(cond,1))
        of "_in" do
          return(property::_cond2set(op(cond,[1,1]) in C_ minus op(cond,[1,2]), ident, constant, setlookup));
        of "_less" do
          v := property::_cond2set(op(cond,[1,1])>=op(cond,[1,2]), ident, constant, setlookup);
          if v<>FAIL then
            return(_intersect(v) union C_ minus R_);
          end_if;
          break;
        of "_leequal" do
          v := property::_cond2set(op(cond,[1,1])>op(cond,[1,2]), ident, constant, setlookup);
          if v<>FAIL then
            return(_intersect(v) union C_ minus R_);
          end_if;
          break;
      end_case;
      return( FAIL );
    of "_less" do
      /* TODO: check solve_real is only needed for
       * PROPERTY/TEST/assume, PROPERTY/TEST/getprop (gives better result)
       * STDLIB/TEST/limit.dev, STDLIB/TEST/simplify
       */
      res := solve_less( cond, ident ).solve_real( op(cond,1), ident ).solve_real( op(cond,2), ident );
      if res=[] then return(FAIL); else res:=op(res); end_if;
      break;
    of "_leequal" do
      /* TODO: check solve_real is only needed for
       * PROPERTY/TEST/assume, PROPERTY/TEST/getprop (gives better result)
       * STDLIB/TEST/limit.dev, STDLIB/TEST/simplify
       */
      res := solve_leequal( cond, ident ).solve_real( op(cond,1), ident ).solve_real( op(cond,2), ident );
      if res=[] then return(FAIL); else res:=op(res); end_if;
      break;
    of "_equal" do
      A := op(cond,1)-op(cond,2);
      res := solve_equal( A, ident );
      if constant and indets( res ) minus Type::ConstantIdents <> {} then
        if type(op(res))=DOM_SET /*and */ then
          if nops(setlookup)>0 then
            res := [_union( op( map( op(res), property::_getprop, "SetLookup"=setlookup, "Constant"=TRUE ) ) ) ];
          end;
        else
          return( FAIL );
        end_if;
      end_if;
      if res=[] then return(FAIL); else res:=op(res); end_if;
      break;
    of "_unequal" do
      A := op(cond,1)-op(cond,2);
      if constant and indets( cond ) minus Type::ConstantIdents <> {ident} then return( FAIL ); end_if;
      res := solve_equal( A, ident );
      if res=[] then return(FAIL); else res:=_intersect(op(res)); end_if;
      res := C_ minus res;
      break;
    of "_in" do
      if op(cond,1)=ident then
        if has(cond, hold(solve)) then
          return(FAIL)
        end_if;
        res := op(cond,2);
      else
        p := poly( op(cond,1), [ident] );
        if p=FAIL or not contains(indets(op(cond,1)), ident ) then
          if expr2text(type( op(cond,2) ))="Dom::Interval" then
            lb := Dom::Interval::left( op(cond,2) );
            rb := Dom::Interval::right( op(cond,2) );
            if not Dom::Interval::isleftopen( op(cond,2) ) and not Dom::Interval::isrightopen( op(cond,2) ) then
              mb := solve_leequal( lb<=rb, ident );
            else
              mb := solve_less( lb<rb, ident );
            end_if;
            if not Dom::Interval::isleftopen( op(cond,2) ) then
              lb := solve_leequal( lb<=op(cond,1), ident );
            else
              lb := solve_less( lb<op(cond,1), ident );
            end_if;
            if not Dom::Interval::isrightopen( op(cond,2) ) then
              rb := solve_leequal( op(cond,1)<=rb, ident );
            else
              rb := solve_less( op(cond,1)<rb, ident );
         end_if;
            mb := select( mb.rb.lb, _unequal, FAIL );
            if nops(mb)=0 then return(FAIL);end_if;
            return( op(mb) );
          end_if;
        end_if;
        if degree(p)=0 then return(FAIL); end_if;
        if degree(p)=1 then
          if freeIndets([coeff(p)])<>{} then return(FAIL); end_if;
          A := ( op(cond,2) - coeff(p,0) ) / coeff(p,1);
          if freeIndets(A)<>{} then return(FAIL); end_if;
          return( A );
        end_if;
        res := FAIL;
      end_if;
      break;
    otherwise
      res := FAIL;
      break;
  end_case;

  return(res);
end_proc:
