/*  */

property::_convertSet := proc( set, options=table() )
  local check, left, right, v, i;
  save MAXEFFORT;
begin
  check := proc(set)
  begin
    if options["Constant"]=TRUE and freeIndets(set)<>{} then return( FALSE ); end_if;
    if options["Blocked"] intersect freeIndets(set) <> {} then return( FALSE ); end_if;
    /* DisAllowed Testen */
    if contains( options["DisAllowed"], type(set) ) then return( FALSE ); end_if;

    /* Auf Targets testen */
    if not contains( options["Targets"], type(set) ) then
      if options["Targets"]={} then
        return(UNKNOWN);
      end_if;
      return(bool(options["StrictTargets"]<>TRUE and UNKNOWN));
    end_if;

    /* _union, _intersect mappen */
    if contains( {"_union", "_intersect"}, type(set) ) then return( _lazy_and( map( op(set), check ) ) ); end_if;
    return ( TRUE );
  end_proc;

  if check(set)=TRUE then return(set); end_if;

  case expr2text(type(set))
    of "Dom::Interval" do
      if options["Blocked"] intersect freeIndets(set) <> {} then
        left := Dom::Interval::leftB(set);
        if options["Blocked"] intersect freeIndets(left) <> {} then left := -infinity; end_if;
        right := Dom::Interval::rightB(set);
        if options["Blocked"] intersect freeIndets(right) <> {} then right := infinity; end_if;
        set := Dom::Interval( left, right );
      end_if;

      if options[ "Constant" ] = TRUE and freeIndets(set)<>{} then
        left := Dom::Interval::left(set);
        if freeIndets(left)<>{} then
          v := property::_getpropRec(left, options, "Targets"={Dom::Interval}, "StrictTargets"=TRUE, "Blocked"=freeIndets(set) union options["Blocked"] );
          if type(v)=Dom::Interval then
            left := Dom::Interval::leftB(v);
          else
            left := -infinity;
          end_if;
        else
          left := Dom::Interval::leftB(set);
        end_if;

        right := Dom::Interval::right(set);
        if freeIndets(right)<>{} then
          v := property::_getpropRec(right, options, "Targets"={Dom::Interval}, "StrictTargets"=TRUE, "Blocked"=freeIndets(right) union options["Blocked"] );
          if type(v)=Dom::Interval then
            right := Dom::Interval::rightB(v);
          else
            right := infinity;
          end_if;
        else
          right := Dom::Interval::rightB(set);
        end_if;
        set := Dom::Interval( left, right );
      end_if;
      break;

    of "\"_union\"" do
      set := map( set, property::_convertSet, table(options, "StrictTargets"=FALSE) );
      break;

    of "\"_intersect\"" do
      if options["Blocked"]<>{} then
        set := select( {op(set)}, X->options["Blocked"] intersect freeIndets(X) = {} );
        if set={} then return(C_); end_if;
      end_if;
      set := _intersect( op(map( {op(set)}, property::_convertSet, table(options, "StrictTargets"=TRUE) )) );
      break;

    of "Dom::ImageSet" do
      if MAXEFFORT<15000 then break; end_if;
      MAXEFFORT := MAXEFFORT/nops(Dom::ImageSet::sets(set));
      while type(set)=Dom::ImageSet and ( i := contains( map( Dom::ImageSet::sets(set), type ), "_intersect" ) )>0 do
        v := nops(Dom::ImageSet::sets(set));
        set := _intersect( op(map( [op(op(Dom::ImageSet::sets(set),i))],
          X->property::_convertSet(Dom::ImageSet( Dom::ImageSet::expr(set), Dom::ImageSet::variables(set),
            subsop(Dom::ImageSet::sets(set), i=X ) ), table(options, "StrictTargets"=TRUE)))));
        // make sure that result changed or decreased in number of variable/sets
        if type(set)=Dom::ImageSet and nops(Dom::ImageSet::sets(set))>=v then break; end_if;
      end_while;
      if type(set)<>Dom::ImageSet then return( property::_convertSet(set,options) ); end_if;
      break;

    of "piecewise" do
      /* Since the expression may contain indets depending on the conditions the union
       * can create endless recursions. To prevend this we use "Constant"=TRUE.
       * Example creating endless recursion without "Constant"=TRUE:
       *  assume(t <> (2*PI)/om and (2*PI)/om <> t and t in Dom::Interval((2*PI)/om - 1/10000000, (2*PI)/om + 1/10000000)):
       *  property::_getpropRec(1/om);
       */
      set := property::_convertSet(_union(op(map([op(set)], X->property::_convertSet(op(X, 2), table(options, "StrictTargets"=TRUE, "Constant"=TRUE))))), options);
      break;

    of "solvelib::BasicSet" do
      if set=C_ then return( C_ ); end_if;
      if contains( options["Targets"], Dom::Interval ) then return( Dom::Interval(-infinity,infinity) ); end_if;
      break;

    of "\"_minus\"" do
      if check( op(set,2) )=FALSE then return( C_ ); end_if;
      set := property::_convertSet( op(set,1), table(options, "StrictTargets"=FALSE) ) minus op(set,2);
      break;
  end_case;

  if check(set)=FALSE then return( C_ ); end_if;
  set;
end_proc:
