/*  */

/* property::_getPropertyList( set )
 * Liefert alle properties von Bezeichnern in set zurck.
 * Rckgabe: [ indets, conditions, backtab ], wobei
 *  - indets die tangierten Bezeichner sind
 *  - conditions die Bedingungen sind, die gefunden wurden
 *  - backtab die Bedingungen, die nicht vollstndig gltig sind
 */

property::_getPropertyList := proc(set)
  local idents_set, s, ind, conds, condTab, condBackTab, v, c, i;
begin
  if (nops(set)= 0) then return([{},{},{}]); end_if;
  /* Select all indets containing properties */
  s := select(set, X->properties(X)<>FAIL);
  /* in the fifth position is the list of all depending identifiers */
  s := _union(op(map(s, X->properties(X)[5])), set);
  /* none found? then quit */
  idents_set := s;

  conds := {};
  condTab := table();
  condBackTab := table();

  /* loop through alle identifiers and build condTab and condBackTab */
  for ind in s do
    if (v:= properties(ind))<>FAIL then
      assert(type(op(v,3))=DOM_SET);
      condTab[ind] := op(v,3);
      conds := conds union op(v,3);
      condBackTab[ind] := op(v,4);
    else
      condTab[ind] := {};
      condBackTab[ind] := {};
    end_if;
  end_for;

  /* check if some conditions have to be removed */
  for c in conds do
    i := property::freeIndets(c);
    v := select(i,X->contains(condTab[X],c) or contains(condBackTab[X],c));
    if v<>i then
      conds := conds minus  {c};
      for i in v do
        condBackTab[i] := condBackTab[i] union {c};
      end_for;
    end_if;
  end_for;

  return([idents_set,conds,condBackTab]);
end_proc:
