/*  */
alias(MAXEFFORT_BOUND=50.0):
alias(MAXEFFORT_HARD_BOUND=5.0):

property::_getpropRec := proc(xpr, options)
  local s1, res, _t, s, v, i, j, global,
    inds, sets, p, fact, modulo, insertMod,
    A;
  save MAXEFFORT;
begin
  if MAXEFFORT<MAXEFFORT_HARD_BOUND then return(C_); end_if;
  /* if properties have changed then check data */
  if stdlib::propertiesChanged()<>{} then
    property::_checkSanity(freeIndets(xpr));
  end_if;
  options[ "Blocked" ] := options[ "Blocked" ] union freeIndets(xpr);
  global := C_;
 
  /* insertMod
   * Inserts values and calculates a result set modulo the value "modulo"
   * Input:
   *  xpr: The mathematical expression, containing indets
   *  inds: The indets that are to be replaced
   *  modulo: The modulo to be calculated
   * Output:
   *  FAIL if the calculation doesn't work
   *  In any other case a set of integers
   */
  insertMod := proc(xpr, inds, modulo)
    local ind, i, subxpr, res, tmp;
  begin
    res := {};
    ind := op(inds,1);
    inds := [op(inds,2..nops(inds))];
    for i from 0 to modulo-1 do
      subxpr := subs(xpr, ind=i);
      if type(subxpr)=DOM_INT then
        res := res union {subxpr mod modulo};
        if nops(res)=modulo then return(res); end_if;
        next;
      end_if;
      if nops(inds)>0 then
        tmp := insertMod(subxpr, inds, modulo);
        if tmp=FAIL then return(FAIL); end_if;
        res := res union tmp;
        if nops(res)=modulo then return(res); end_if;
        next;
      end_if;
      return(FAIL);
    end_for;
    return(res);
  end_proc:

  /* Mengen bestimmen */
  res := FAIL;
  _t := eval( op(xpr,0) );
  if domtype(_t) = DOM_FUNC_ENV and ( s := _t::getprop )<>FAIL then
    res := _t::getprop( xpr, options );
    assert( res=FAIL or testtype(res,Type::Set) );
  elif xpr::dom::getprop<>FAIL then
    res := xpr::dom::getprop( xpr );
    assert( res=FAIL or testtype(res,Type::Set) );
  else
    case type(xpr)
      of "_mod" do
        inds := map(property::freeIndets(op(xpr,1)), X->[X,property::_getpropRec(X, options)]);
        if map(inds,X->X[2] subset Z_)={TRUE} then
          p := poly(op(xpr,1), [op(map(inds,op,1))], Dom::Rational);
          if p<>FAIL and not has(coeff(p,[0$nops(inds)]), inds) then
            /* Hauptnenner berechnen */
            fact := ilcm(op(map([coeff(p)], denom)));
            modulo := op(xpr,2);
            /* Mit Hauptnenner erweitern */
            if fact<>1 then
              p := mapcoeffs(p, _mult, fact);
              modulo := modulo*fact;
            end_if;
            /* Polynom erzeugen und Werte einsetzen */
            p := poly(p, IntMod(modulo));
            res := insertMod(expr(p), inds, modulo);
            /* Hauptnenner aus Ergebnis rausdividieren */
            if fact<>1 then
              if map(res,_mod, fact)<>{0} then
                res := FAIL;
              else
                res := map(res, _mult, 1/fact);
              end_if;
            end_if;
            /* Wenn ein Ergebnis gefunden wurde, keine weiteren Heuristiken ausfhren */
            if res<>FAIL then break; end_if;
          end_if;
        end_if;
        if type(op(xpr,2))<>DOM_INT then break; end_if;
        i := op(xpr,2);
        v := property::_getpropRec( op(xpr,1), table(options, "Target"={Dom::ImageSet}) );
        if v=Z_ then
          res := { i$i=0..(op(xpr,2)-1) };
        end_if;
        if type(v)<>Dom::ImageSet then break; end_if;
        if (A := Dom::ImageSet::isisetLinear(v) )<>FALSE and (Dom::ImageSet::sets(v)[1] subset Z_)=TRUE and type(A[1])=DOM_INT and type(A[2])=DOM_INT then
          /* Wir suchen A1*Z_ + A2 mod i */
//           if type(i/A[1])=DOM_INT then res := {A[2]}; break; end_if;
          if type(A[1]/i)=DOM_INT then res := {A[2] mod i}; break; end_if;
          res := {};
          A[2] := A[2] mod i;
          repeat
            res := res union {A[2]};
            A[2] := (A[2] + A[1]) mod i;
          until contains( res, A[2] ) end_repeat;
        end_if;
        break;
      of "sin" do
        res := property::_getpropRec( op(xpr,1), table(options, "Targets"={Dom::Interval, "_union", DOM_SET}, "StrictTargets"=TRUE) );
        if res<>C_ then
          res := sin(res);
        end_if;
        break;
      of "cos" do
        res := property::_getpropRec( op(xpr,1), table(options, "Targets"={Dom::Interval, "_union", DOM_SET}, "StrictTargets"=TRUE) );
        if res<>C_ then
          res := cos(res);
        end_if;
        break;
      of "tan" do
        res := property::_getpropRec( op(xpr,1), table(options, "Targets"={Dom::Interval, "_union", DOM_SET}, "StrictTargets"=TRUE) );
        if res<>C_ then
          res := tan(res);
        end_if;
        break;
      of "_plus" do
        s := split( [op(xpr)], X->contains( {DOM_RAT,DOM_FLOAT,DOM_INT}, type(X) ) );
        MAXEFFORT := MAXEFFORT/(nops(s[2])+1);
        if MAXEFFORT<MAXEFFORT_BOUND then break; end_if;
        res := [];
        for i in s[2] do
          j := property::_getpropRec( i, table(options, "DisAllowed"={"piecewise"}) );
          if j=C_ then res := FAIL; break; end_if;
          res := res.[j];
        end_for;
        if res = FAIL then break; end_if;
        if res = [] then return( {_plus(op(s[1])) } ); end_if;
        res :=_plus( op(res), op(s[1]));
        if not testtype(res,Type::Set) then res := C_; end_if;
        if nops(s[2])=1 then return( res ); end_if;
        break;
      of "_mult" do
        s := split( [op(xpr)], X->contains( {DOM_RAT,DOM_FLOAT,DOM_INT}, type(X) ) );
        MAXEFFORT := MAXEFFORT/(nops(s[2])+1);
        if MAXEFFORT<MAXEFFORT_BOUND then break; end_if;
        res := [];
        for i in s[2] do
          j := property::_getpropRec( i, table(options, "DisAllowed"={"piecewise"}) );
          if j=C_ then res := FAIL; break; end_if;
          res := res.[j];
        end_for;
        if res = FAIL then break; end_if;
        if res = [] then return( {_mult(op(s[1])) } ); end_if;
        res :=_mult( op(res), op(s[1]) );
        if not testtype(res,Type::Set) then res := C_; end_if;
        if nops(s[2])=1 then return( res ); end_if;
        break;
      of "_power" do
        if contains( {DOM_INT,DOM_RAT}, type( op(xpr,2) ) ) then
          s1 := property::_getpropRec( op(xpr,1), table(options, "Targets"={Dom::Interval, "_union", DOM_SET, solvelib::BasicSet}, "StrictTargets"=TRUE) );
          if type(s1) = "_union" then
            res := _union( map( op(s1), X->_power(X, op(xpr,2) ) ) );
          else
            res := _power(s1, op(xpr,2) );
          end_if;
        else
          s1 := property::_getpropRec(op(xpr,2), table(options, "Targets"={Dom::Interval}, "StrictTargets"=TRUE));
          if s1=FAIL then break; end_if;
          if _subset(s1, Dom::Interval([0],infinity))<>TRUE then break; end_if;
          s := property::_getpropRec(op(xpr,1), table(options, "Targets"={Dom::Interval}, "StrictTargets"=TRUE));
          if s=FAIL then break; end_if;
          if _subset(s, Dom::Interval([1],infinity))=TRUE then
            res := s^s1;
          end_if;
        end_if;
        break;
      of DOM_IDENT do
        if contains(Type::ConstantIdents,xpr) then return( {xpr} ); end_if;
        res := global;
        break;
      of DOM_RAT do
      of DOM_COMPLEX do
      of DOM_INT do
        res := { xpr };
        break;
    end_case;
  end_if;

  if res=FAIL then res := global; end_if;

  if contains( PROPERTIES["set_lookup"], xpr ) then
    if res=C_ then
      res := property::_convertSet(PROPERTIES["set_lookup"][xpr], options);
      return( res );
    else
      res := res intersect property::_convertSet( PROPERTIES["set_lookup"][xpr], options);
    end_if;
  end_if;

  if contains( options["SetLookup"], xpr ) then
    if res=C_ then
      res := property::_convertSet( _intersect(op(options["SetLookup"][xpr])), options);
      return( res );
    else
      res := res intersect property::_convertSet( _intersect(op(options["SetLookup"][xpr])), options);
    end_if;
  end_if;

  if not options["Constant"] or type(xpr)<>DOM_IDENT then
    s := {};
    for i in freeIndets( xpr ) do
      if contains( PROPERTIES["cond_lookup"], i ) and has(PROPERTIES["cond_lookup"][i], xpr) then
        s := s union select( PROPERTIES["cond_lookup"][i], has, xpr );
      end_if;
    end_for;
//     s := select( s, X->( freeIndets(X) minus freeIndets(xpr) ) intersect options["Blocked"] = {} );
    if ( nops(s)>0 ) then
      v := map( s, proc(X) local v; begin
        v := property::_cond2set( X, xpr, options["Constant"] );
        if v=FAIL then return(C_); end_if;
        if type(v)="_exprseq" then v:=_intersect(v); end_if;
        property::_convertSet( v, options );
      end_proc );
      if nops(v)>1 then
        res := _intersect( res, op(v) );
      elif nops(v)=1 then
        res := res intersect op(v);
      end_if;
    end_if;
  end_if;

  if type(xpr)<>DOM_IDENT and res=global
    and not contains( options["DisAllowed"], Dom::ImageSet )
    and ( /*options["StrictTargets"]=FALSE or */ contains( options ["Targets"], Dom::ImageSet ) ) then
    inds := [op(freeIndets( xpr ))];
    sets := [];
    for i in inds do
      if contains( PROPERTIES["set_lookup"], i ) then
        if freeIndets(PROPERTIES["set_lookup"][i]) intersect {op(inds)} = {} then
          sets := append( sets, PROPERTIES["set_lookup"][i] );
        else
          sets := C_;
        end_if;
      else
        sets := append( sets, C_ );
      end_if;
    end_for:

    res := Dom::ImageSet( xpr, inds, sets );
  end_if;

  property::_convertSet( res, options );
end_proc: