//   

alias(hasBit(X, k) = bool((X mod 2^(k + 1)) div 2^k <> 0)):

/* property::_rewrite_cond()
 * Bedingung fr is() umschreiben.
 */
property::_rewrite_cond := proc( ex, prop = FAIL, goal =UNKNOWN, level=0 )
  local res, x, y, err, A, val;
begin
/* (Un-)Gleichungsketten umschreiben */
  if has({"_less", "_leequal", "_equal", "_unequal"}, type(ex)) then
    [ x, y ] := [op( ex )];
      if has({"_equal", "_leequal", "_less", "_unequal"}, type(x)) then
        ex := _and(property::_rewrite_cond(x, FAIL, goal, level+1),
          property::_rewrite_cond(op(ex, 0)(op(x, 2), y), FAIL, goal, level+1));
      end_if;
      if has({"_equal", "_leequal", "_less", "_unequal"}, type(y)) then
        ex := _and(property::_rewrite_cond(op(ex, 0)(x, op(y, 1)), FAIL, goal, level+1),
          property::_rewrite_cond(y, FAIL, goal, level+1));
      end_if;
  end_if;

  if ( prop<>FAIL and type(ex)=DOM_IDENT and not (op(ex,1) in Type::ConstantIdents) and property::hasprop(ex)=FALSE ) then
    return( UNKNOWN );
  end_if:
  if (prop=FAIL and type(ex)="_in" and type(op(ex,1))=DOM_IDENT  and not (op(ex,1) in Type::ConstantIdents) and property::hasprop(op(ex,1))=FALSE and not hastype(ex,Dom::ImageSet) and level=0) then
    if ( op(ex,2)=C_ ) then
      return( TRUE );
    else
      return( UNKNOWN );
    end_if:
  end_if:
  err := traperror(
  ( case ( prop )
    of FAIL do
      case type(ex)
        of "_in" do
          if op(ex,2)=R_ then
            res := property::rewrite_cond_type_real( op(ex,1), goal, level );
          elif expr2text(type(op(ex,2)))="Dom::ImageSet" then
            if  (A := Dom::ImageSet::isisetLinear( op(ex,2) ) )<>FALSE and _subset(Dom::ImageSet::sets( op(ex,2) )[1], Z_) = TRUE and type(A[1])=DOM_INT and type(A[2])=DOM_INT then
              val := property::_typeresidue( op(ex,1), A[2], A[1] );
              if val=FALSE then
                res := FALSE;
              elif val=TRUE then
                res := property::_rewrite_cond((op(ex,1)-A[2])/A[1] in Dom::ImageSet::sets( op(ex,2) )[1], prop, goal, level);
              else
                if goal=TRUE then
                  res := FALSE;
                else
                  res := ex;
                end_if;
              end_if;
            else
              res := ex;
            end_if;
          else
            res := ex;
          end_if;
          break;
        of "_and" do
        of "_or" do
          res := map(ex, property::_rewrite_cond, prop, goal, level+1);
          break;
        of "_not" do
          res := not property::_rewrite_cond(op(ex), prop, goal, level);
          break;
        of "_equal" do
          res := property::_rewrite_cond_equality(ex, goal, level );
          break;
        of "_leequal" do
        of "_less" do
          res := property::_rewrite_cond_inequality(ex, goal, level );
          break;
        otherwise
          res := ex;
      end_case;
      break;
    of Type::PosInt do
      res := property::_rewrite_cond_inequality(ex > 0, goal, level+1) and property::rewrite_cond_type_integer(ex);
      break;
    of Type::Positive do
      res := property::_rewrite_cond_inequality(ex > 0, goal, level);
      break;
    of Type::Negative do
      res := property::_rewrite_cond_inequality(ex < 0, goal, level);
      break;
    of Type::NonNegative do
      res := property::_rewrite_cond_inequality(ex >= 0, goal, level);
      break;
    of Type::NonNegInt do
      res := property::_rewrite_cond_inequality(ex >= 0, goal, level+1) and property::rewrite_cond_type_integer(ex);
      break;
    of Type::Real do
      res := property::rewrite_cond_type_real( ex, goal, level );
      break;
    of Type::Rational do
      res := property::rewrite_cond_type_rational(ex);
      break;
    of Type::Zero do
      res := property::_rewrite_cond_inequality(ex = 0, goal, level);
      break;
    of Type::Imaginary do
      res := property::rewrite_cond_type_imaginary(ex);
      break;
    of Type::Integer do
      res := property::rewrite_cond_type_integer(ex);
      break;
    otherwise
      case type( prop )
        of "Residue" do
          if ( op(extop(prop, 3), 2)=0 ) then
            res := ex = op(extop(prop, 3), 1);
          else
            res := property::_typeresidue(ex, op(extop(prop, 3), 1), op(extop(prop, 3), 2));
            if res=UNKNOWN then
              res := ( ex - op(extop(prop, 3), 1) ) / op(extop(prop, 3), 2) in Z_;
            end_if;
          end_if;
          break;
        of "Interval" do
          res:= ex in Dom::Interval::convert(prop);
          break
        otherwise
          res := ex in property::prop2set( prop );
          break;
      end_case;
      break;
  end_case )
  );
  if err<>0 then res := UNKNOWN; end_if;
  return( res );
end_proc: /* property::_rewrite_cond */

property::rewrite_cond_type_imaginary := proc(ex)
begin
  if property::_typereal(ex)=TRUE then
    return( ex=0 );
  end_if;
//  return( UNKNOWN );
  return( ex*I in R_ );
end_proc:

property::rewrite_cond_type_real := proc(ex, goal=UNKNOWN, level=0 )
  local v;
begin
    case type(ex)
      of DOM_COMPLEX do
        return( FALSE );
      of DOM_INT do
      of DOM_RAT do
        return( TRUE );
      of DOM_IDENT do
        if contains( {CATALAN, EULER, PI}, ex ) then return( TRUE ); end_if;
        if ( v:= properties(ex) )<>FAIL and hasBit( op(v,1), 1) then
          return( TRUE );
        else
          if goal=TRUE and level=0 then
            return( FALSE );
          end_if;
          return( ex in R_ );
        end_if;
      otherwise
        return( ex in R_ );
    end_case;
end_proc:

property::rewrite_cond_type_integer := proc(ex, goal=UNKNOWN, level=0 )
  local v;
begin
    case type(ex)
      of DOM_COMPLEX do
      of DOM_RAT do
        return( FALSE );
      of DOM_INT do
        return( TRUE );
      of DOM_IDENT do
        if contains( {CATALAN, EULER, PI}, ex ) then return( FALSE ); end_if;
        if ( v:= properties(ex) )<>FAIL and hasBit( op(v,1), 5) then
          return( TRUE );
        else
          if goal=TRUE and level=0 then
            return( FALSE );
          end_if;
          return( ex in Z_ );
        end_if;
      otherwise
        return( ex in Z_ );
    end_case;
end_proc:

property::rewrite_cond_type_rational  := proc(ex, goal=UNKNOWN, level=0 )
  local v;
begin
    case type(ex)
      of DOM_COMPLEX do
        return( FALSE );
      of DOM_RAT do
      of DOM_INT do
        return( TRUE );
      of DOM_IDENT do
        if contains( {CATALAN, EULER, PI}, ex ) then return( FALSE ); end_if;
        if ( v:= properties(ex) )<>FAIL and hasBit( op(v,1), 5) then
          return( TRUE );
        else
          if goal=TRUE and level=0 then
            return( FALSE );
          end_if;
          return( ex in Q_ );
        end_if;
      otherwise
        return( ex in Q_ );
    end_case;
end_proc: