/*  */

/* property::_setgroup( list )
  * Setzt die Properties fr eine Abhngigkeits-Gruppe
  */
property::_setgroup := proc( list: DOM_LIST )
  local indset, i, v, j, s,
    ind, cond, inds,
    loc_set_lookup,
    loc_cond_in,
    loc_sysprop_lookup,
    loc_cond_lookup,
    back_set, ncond;
begin
  indset := list[1];
  loc_cond_in := list[2];

  /* Zuerst wird aufgerumt. Alle Properties und Lookup-Tabellen, die mit indset zu tun haben, werden bereinigt
    * Dies ist notwendig, da einige Library-Funktionen die Properties
    * beeinflussen und sonst Inkonsistenzen erzeugen wrden.
    */
    /* System-Properties entfernen */
  for ind in indset do
    if properties(ind)<>FAIL then
      properties(ind, FAIL);
    end_if;
    if contains(PROPERTIES[ "set_lookup" ],ind) then
      sysdelete(PROPERTIES[ "set_lookup" ][ind]);
    end_if;
    if contains( PROPERTIES[ "cond_lookup" ], ind ) then
      sysdelete(PROPERTIES[ "cond_lookup" ][ind]):
    end_if;
    if contains( PROPERTIES[ "checklist" ], ind ) then
      sysdelete(PROPERTIES[ "checklist" ][ind]);
    end_if;
  end_for;
  stdlib::propertiesChanged(stdlib::propertiesChanged() minus indset);

  /* Bedingungen vereinfachen */
  // cond := simplify::simplifyCondition( _and( op(loc_cond_in) ), UseSolver=FALSE );
  cond := _and( op(loc_cond_in) );

  if type(cond)=DOM_BOOL then
    /* properties sichern, die wiederhergestellt werden knnen */
    for ind in indset do
      back_set := list[3][ind] union list[2];
      if back_set <> {} then
        properties(ind, [0, 0, {}, back_set, indset]);
      end_if;
      sysassign(PROPERTIES["checklist"][ind], indset);
    end_for;
    return(cond);
  end_if;
  if type(cond)="_and" then
    ncond := [ op(cond) ];
  else
    ncond := [ cond ];
  end_if;

  /* Nach Enthaltensein der Bezeichner sortieren */
  ncond := sort(ncond, proc(x,y)
      local a,b;
    begin
      a := indets(x); b := indets(y);
      if a<>b then return(a minus b = {}); end_if;
      return(type(y)="_or" or type(y)="_not");
    end_proc);

  loc_set_lookup := table();
  loc_sysprop_lookup := table();
  loc_cond_lookup := table();

  /* Bedingungen nach Identifiern sortieren */
  i := 0;
  while i<nops( ncond ) do
    i := i+1;
    cond := op(ncond,i);
    if ( type(cond)="_in" and type( op(cond,2) )="solve" ) then cond := expand(cond); end_if;

    /* {a,b,c} subset SET auflsen */
    if type(cond)="_subset" and type(op(cond,1))=DOM_SET then
      ncond := ncond.[op( map( op(cond,1), X->X in op(cond,2) ) )];
      next;
    end_if;
    inds := freeIndets(cond);

    /* Bedingungen einsortieren */
    for ind in inds do
      if contains( loc_cond_lookup, ind ) then
        loc_cond_lookup[ ind ] := loc_cond_lookup[ ind ] union { cond };
      else
        loc_cond_lookup[ ind ] := { cond };
      end_if;
      if ( v := property::_cond2set( cond, ind, TRUE, loc_set_lookup ) )<>FAIL then

        if contains( loc_set_lookup, ind ) then
          loc_set_lookup[ ind ] := loc_set_lookup[ ind ] union {v};
        else
          loc_set_lookup[ ind ] := { v };
        end_if;
      end_if;
    end_for;
  end_while;

  for ind in indset  do
    if contains(loc_set_lookup,ind) then
        s := split( loc_set_lookup[ ind ], X->testtype( X, Type::Constant ) );
      if nops(s[1])>1 then
        s[1] := solvelib::solve_intersect/*_intersect*/( op(op(s, 1)) );
        if s[1]={} and not property::flignoreInconsistentAssumptions then error( "Inconsistent assumptions detected." ); end_if;
        if type(s[1])="_intersect" then
          s[1] := {op(s[1])};
        else
          s[1] := {s[1]};
        end_if;
      end_if;

      if nops(op(s,1)) + nops(op(s,2)) > 1 then
        loc_set_lookup[ ind ] := hold(_intersect)( op(op(s,1)), op(op(s,2)) );
      else
        loc_set_lookup[ ind ] := op(op(s,1)), op(op(s,2));
      end_if;

      /* System-Propertys berechnen */
      j := property::_set2sysprop( loc_set_lookup[ind] );
      v := 0;
      for i from nops(j) downto 1 do
        v := 2*v;
        v := v+j[i];
      end_for;
    else
      v := 0;
    end_if;
    loc_sysprop_lookup[ ind ] := v;
  end_for;

  for ind  in indset do
    if contains(PROPERTIES[ "set_lookup" ],ind) then
      sysdelete(PROPERTIES[ "set_lookup" ][ind]);
    end_if;
    if contains(loc_set_lookup,ind) then
      sysassign(PROPERTIES[ "set_lookup" ][ ind ], loc_set_lookup[ ind ]);
    end_if;

    /* properties sichern, die wiederhergestellt werden knnen */
    back_set := list[3][ind];

    v := loc_sysprop_lookup[ind];
    /* Propertys eintragen */
    properties( ind, [v, 0, select(loc_cond_in,
                                    X->contains(freeIndets(X), ind)),
                back_set, indset ] );

    /* Checkliste eintragen */
    sysassign(PROPERTIES["checklist"][ind], indset);
    sysassign(PROPERTIES["cond_lookup"][ind], loc_cond_lookup[ind]);
  end_for;

  return( TRUE );
end_proc: /* property::_setgroup */
