//   

property::_typerational := proc( xpr, options=table() )
  local haveFalse, i, exponent, ispow;
begin
  case type(xpr)
    of DOM_IDENT do
      if contains(Type::ConstantIdents, xpr) then
        return(FALSE);
      end_if;
      if getprop(xpr) subset Q_ = TRUE then
        return(TRUE);
      end_if;
      break;
    of DOM_COMPLEX do
      return(FALSE);
    of DOM_INT do
    of DOM_RAT do
      return(TRUE);
    of "_power" do
      // check if base and exponent are of type integer
      exponent:= op(xpr, 2);
      if type(op(xpr, 1)) = DOM_INT and type(exponent) = DOM_RAT then
        ispow:= numlib::ispower(op(xpr, 1));
        if ispow <> FALSE and op(ispow, 2) mod op(exponent, 2) = 0 then
          return(TRUE)
        else
          return(FALSE)
        end_if
      end_if;
      if property::_typeinteger(op(xpr,2), options)=TRUE then
        return(property::_typerational(op(xpr,1), options));
      end_if;
      break;
    of "_plus" do
      /* check cases:
        * 1) all summands integer => sum is integer
        * 2) any summand cant be decided => UNKNOWN
        * 3) only one summand is not integer => sum is not integer
        */
      haveFalse := FALSE;
      for i in [op(xpr)] do
        if type(i)=DOM_INT then next; end;
        case property::_typerational(i, options)
          of TRUE do break;
          of UNKNOWN do return( UNKNOWN );
          of FALSE do
            if options["seek"]=TRUE then return( UNKNOWN ); end_if;
            if haveFalse then return( UNKNOWN ); end_if;
            haveFalse := TRUE;
        end_case;
      end_for;
      return( not haveFalse );
    of "_mult" do
      /* check cases:
        * 1) all factors integer => product is integer
        * 2) any factors cant be decided or is not integer => UNKNOWN
        */
      haveFalse := FALSE;
      for i in [op(xpr)] do
        if type(i)=DOM_INT then next; end;
        case property::_typerational(i, options)
          of TRUE do
            break;
          of UNKNOWN do
          of FALSE do
            haveFalse := TRUE;
            break;
        end_case;
        if haveFalse then break; end_if;
      end_for;
      if not haveFalse then
        return(TRUE);
      end_if;
  end_case;
  return(property::_typeinteger(xpr, options) or property::_typereal( xpr, options ) and UNKNOWN);
end_proc: /* property::_typerational */
