//   

alias(hasBit(X, k) = bool((X mod 2^(k + 1)) div 2^k <> 0)):

/* property::_typereal( xpr )
  * Checks whether xpr is real or not
  * Returns TRUE, FALSE or UNKNOWN
  */
property::_typereal := proc( xpr, options=table() )
  local s, i, v, haveFalse, orv;
begin
  case expr2text(type(xpr))
    of "Dom::Interval" do  
    of "DOM_INT" do
    of "DOM_RAT" do
    of "DOM_FLOAT" do
      return(TRUE);
    of "solvelib::BasicSet" do
      if xpr = R_ then
        return(TRUE)
      end_if
  end_case;

  if not contains( {DOM_LIST,DOM_SET}, type(xpr) ) and indets(xpr) minus Type::ConstantIdents={} then
    v := property::isConstReal( xpr );
    if type(v)=DOM_BOOL and v<>UNKNOWN then return( v ); end_if;
  end_if;
  case type(xpr)
    of "exp" do
      return(property::_typereal(op(xpr), table(options, "seek"=TRUE)) or UNKNOWN);
    of "ln" do
      return( property::_decide( op(xpr)>=0 ) );
    of "fact" do
    of "arg" do
    of "Re" do
    of "Im" do
    of "abs" do
      return( TRUE );
    of "sign" do
    of "sin" do
    of "tan" do
    of "cos" do
    of "sinh" do
    of "tanh" do
    of "cosh" do
      if property::_typereal(op(xpr), table(options, "seek"=TRUE))=TRUE then return(TRUE); end_if;
      break;
    of "_mult" do
      s := split( xpr, X->indets(X) minus Type::ConstantIdents={} );
      haveFalse := not property::isConstReal( s[1] );
      if haveFalse=UNKNOWN then return( UNKNOWN ); end_if;
      if type(s[2])<>"_mult" then
        if haveFalse=TRUE then
          case property::_decide( s[2]=0, options )
            of TRUE do
              return( TRUE );
            of FALSE do
              if property::_typereal(s[2], table(options, "seek"=TRUE))=TRUE then
                return( FALSE );
              end_if;
          end_case;
          return( UNKNOWN );
        else
          return( property::_typereal( s[2], options ) );
        end_if;
      end_if;
      /* check cases:
        * 1) all factors real => product is real
        * 2) any factor cant be property::_decided => UNKNOWN
        * 3) only one factor is imaginary and the others not 0 => product is imaginary
        */
      for i in [op(s[2])] do
        if contains( {DOM_INT,DOM_RAT,DOM_FLOAT},type(i) ) then next; end;
        case property::_typereal(i, options)
          of TRUE do break;
          of UNKNOWN do return( UNKNOWN );
          of FALSE do
            if options["seek"]=TRUE then return( UNKNOWN ); end_if;
            if haveFalse then return( UNKNOWN ); end_if;
            if property::_decide( xpr/i=0, options )<>FALSE then return( UNKNOWN ); end_if;
            haveFalse := TRUE;
        end_case;
      end_for;
      return( not haveFalse );
    of "_plus" do
      /* check cases:
        * 1) all summands real => sum is real
        * 2) any summand cant be property::_decided => UNKNOWN
        * 3) only one summand is imaginary => sum is imaginary
        */
      haveFalse := FALSE;
      for i in [op(xpr)] do
        if contains( {DOM_INT,DOM_RAT,DOM_FLOAT},type(i) ) then next; end;
        if type(i) = stdlib::Infinity then return(FALSE) end_if;
        case property::_typereal(i, options)
          of TRUE do break;
          of UNKNOWN do return( UNKNOWN );
          of FALSE do
            if options["seek"]=TRUE then return( UNKNOWN ); end_if;
            if haveFalse then return( UNKNOWN ); end_if;
            haveFalse := TRUE;
        end_case;
      end_for;
      return( not haveFalse );
    of "_power" do
      if property::_typereal(op(xpr,2), table(options, "seek"=TRUE))=TRUE then
        if op(xpr,2)=1/2 then
          return( property::_decide( op(xpr,1)>=0, options ) );
        end_if;
        if property::_typeinteger( op(xpr,2), options) =TRUE then
          return( property::_typereal(op(xpr,1), table(options, "seek"=TRUE)) or UNKNOWN );
        end_if;
        if property::_decide( op(xpr,1)>=0, options  )=TRUE then
          return( TRUE );
        end_if;
      end_if:
      break;
    of DOM_IDENT do
      if contains( {PI,EULER,CATALAN}, xpr ) then return(TRUE); end_if;
      if ( v:=properties(xpr) )<>FAIL and hasBit(op(v,1),1) then return(TRUE); end_if;
      if contains( options, "realvars" ) and contains( options["realvars"], xpr ) then return(TRUE); end_if;
      if contains( options, "unrealvars" ) and contains( options["unrealvars"], xpr ) then return(FALSE); end_if;
//      return ( property::_decide( 0 in getprop(hold(Im)(xpr)), options ) and UNKNOWN );
      break;
    of DOM_INT do
    of DOM_RAT do
      return(TRUE);
    of "_range" do
    of DOM_LIST do
    of DOM_SET do
      return( _and( op( map( [op(xpr)], property::_typereal, options ) ) ) );
    of DOM_COMPLEX do
      return( FALSE );
    of "int" do
      if type(op(xpr,2))="_equal" and type(op(xpr,[2,2]))="_range" then
        if contains( options, "realvars" ) then orv := options["realvars"]; else orv := {}; end_if;
        v := FALSE;
        if map( [op(op(xpr,[2,2]))], X->property::_typereal(X, options) or bool(X=-infinity) or bool(X=infinity) )=[TRUE,TRUE] then
          if type( op(xpr,[2,1]) )=DOM_IDENT then orv := orv union { op(xpr,[2,1])  }; end_if:
          options[ "realvars" ] := orv;
          v := property::_typereal(op(xpr,1), table(options, "seek"=TRUE));
        end_if:
        if v = TRUE then return( TRUE ); end_if;
      end_if:
      break;
      
  end_case:
  UNKNOWN;
end_proc:  /* property::_typereal */

/* Eintrge fr die Remember-Tafel */
property::_typereal( infinity ) := FALSE:
property::_typereal( -infinity ) := FALSE:
