//   

// property::constRel
// entscheide konstante Relationen
property::constRel:=
proc(ex)
  local
  x: Type::Arithmetical,
  y: Type::Arithmetical,
  types: DOM_SET;
begin
  if testargs() then
    if not contains({"_equal", "_unequal", "_less", "_leequal"}, type(ex)) then
      error("Argument has wrong type")
    end_if;
    if freeIndets(ex) <> {} then
      error("Argument is not constant")
    end_if
  end_if;

  /* units ersetzen */
  if expr2text(val(unit))="unit" then
    if hastype(ex,unit) then
      ex := unit::convert2SIunits(ex);
      ex := subs( ex, unit::m=1, unit::kg=1, unit::sec=1 );
    end_if;
  end_if;

  x:= op(ex, 1);
  y:= op(ex, 2);
  if not testtype( x, Type::Arithmetical ) or not testtype( y, Type::Arithmetical ) then return( UNKNOWN ) end_if;

  case type(ex)
    of "_less" do
    of "_leequal" do

      // first, we handle the cases involving infinity
      // (some are also handled by values in the remember table)

      if has(ex, complexInfinity) then
        return(FALSE)
      end_if;


      // use numeric::isreal to decide whether one side is not real

      if numeric::isreal(x) = FALSE or numeric::isreal(y) = FALSE then
        return(FALSE)
      end_if;

      if y = infinity then // infinity < infinity solved by remember value
        return(TRUE)
      end_if;
      if y = -infinity then
        return(FALSE)
      end_if;
      if x = -infinity then
        return(TRUE)
      end_if;
      if x = infinity then
        return(FALSE)
      end_if;
      // this should have been all, except for cases like I*infinity etc. !?
      if has(ex, infinity) then
        return(FALSE)
      end_if;




  //------------------------------------------------
  // numeric::less provides a reasonably safe float
  // check: it returns TRUE/FALSE or UNKNOWN.
  // TRUE means a safe x < y, both x and y real
  // FALSE means
  //          safe x > y, both x and y real
  //       or safe Im(x) <> 0
  //       or safe Im(y) <> 0
  // For 'UNKNOWN', we need to check further down
  // below via the property mechanism.
  //------------------------------------------------

      case numeric::isless(x, y)
        of TRUE do
          return(TRUE)
        of FALSE do
          if type(ex) = "_less" then
            return(FALSE)
          else
            return(bool(numeric::isnonzero(x-y) <> TRUE))
          end_if
        of UNKNOWN do
          if traperror((
                        types:= map({op(ex)}, type@float)
                        )) <> 0 then
            return(UNKNOWN)
          end_if;
          if types
            minus {DOM_FLOAT, DOM_COMPLEX} = {} then
          // heuristic conclusion: x = y
            if type(ex) = "_leequal" then
              return(TRUE)
            else
              if numeric::isnonzero(x-y) <> TRUE then
                return(FALSE)
              else
                return(TRUE)
              end_if
            end_if;
          else
            return(UNKNOWN)
          end_if;
      end_case

    of "_equal" do
    of "_unequal" do

  //------------------------------------------------
  // numeric::isnonzero provides a reasonably safe
  // float check: it returns TRUE or UNKNOWN.
  // TRUE means x - y <> 0, both x and y may be complex.
  // Heuristcally, UNKNOWN is taken as FALSE
  //------------------------------------------------

      x:= op(ex, 1):
      y:= op(ex, 2):

      if numeric::isnonzero(x - y) = TRUE then
        if type(ex) = "_equal" then
          return(FALSE)
        else
          return(TRUE)
        end_if;
      else // UNKNOWN or FALSE
        if traperror((
        types:= {op(map(ex, type@float))}
                      )) <> 0 then
          return(UNKNOWN)
        end_if;
        if has(ex, infinity) then
          if(type(ex) = "_equal") then
            return(FALSE)
          else
            return(TRUE)
          end_if
        elif types
          minus {DOM_FLOAT, DOM_COMPLEX} = {} then
          if(type(ex) = "_equal") then
            return(TRUE)
          else
            return(FALSE)
          end_if
        else
          return(UNKNOWN)
        end_if
      end_if
  end_case;

      // NOT REACHED

  assert(FALSE)

end_proc:

// some values for the rememeber table
property::constRel(-infinity <= -infinity):= TRUE:
property::constRel(infinity < infinity):= FALSE:
property::constRel(-infinity < -infinity):= FALSE:
property::constRel(infinity <= infinity):= TRUE:
property::constRel(-infinity < -infinity):= FALSE:
property::constRel(-infinity <= infinity):= TRUE:
property::constRel(-infinity < infinity):= TRUE:
property::constRel(-infinity <= -infinity):= TRUE:
property::constRel(infinity <= -infinity):= FALSE:
property::constRel(-infinity < -infinity):= FALSE:
