//   

// 09.04.2002
// - new version: indets(expr, All) returns _all_ identifiers (also 0th operands)
// - recursive calls are not further necessary
// - EXCEPT: indexed identifiers are not identified, until the new concept is
//           realized

property::hasprop:=
proc(ex)
begin
  if domtype(ex) = DOM_IDENT then
    return(bool(properties(ex) <> FAIL and op(properties(ex),3)<>{} ))
  elif domtype(ex) = DOM_EXPR then
    if type(ex) = "_index" and domtype(op(ex, 1)) = DOM_IDENT then
      return(FALSE)
    elif domtype(eval(op(ex, 0))) = DOM_FUNC_ENV
        and slot(eval(op(ex, 0)), "minprop") <> FAIL then
      return(TRUE)
    else
      // without libary procedure
      ex:= eval(indets(ex, All)); // extract all identifiers, also inspect 0th operands
      if map(select(ex, testtype, DOM_IDENT), properties) <> {FAIL} then
        return(TRUE)
      elif map(select(ex, testtype, DOM_FUNC_ENV), slot, "minprop") <> {FAIL} then
        return(TRUE)
      else
        return(FALSE)
      end_if
    end_if
  else
    return(FALSE)
  end_if
end_proc:
