
/* 
property::isConstInteger(ex) 

checks whether ex represents an integer
returns TRUE, FALSE, or UNKNOWN 
ex must be a constant expression

*/
property::isConstInteger:=
proc(ex)
  local isreal, digex, fracex;
  save DIGITS;
begin
  case type(ex) 
    of DOM_INT do
      return(TRUE)
    of DOM_RAT do
    of DOM_COMPLEX do
      return(FALSE)
  end_case;
  if (isreal:= property::isConstReal(ex)) = FALSE then
    FALSE 
  else
    // how many digits does ex have in front of the decimal point?
    digex:= Re(float(ex, 5));
    if iszero(digex) then
       return(property::constRel(ex = 0))
    end_if;   
    digex:= Re(log(10, digex));
    if type(digex) <> DOM_FLOAT or digex = RD_NAN or digex > 1000 then 
      // give up
      UNKNOWN
    else 
      DIGITS:= max(ceil(digex) + 10, 10);
      fracex:= float(ex);
      if type(fracex) <> DOM_FLOAT and type(fracex) <> DOM_COMPLEX then
        return(UNKNOWN)
      else 
        fracex:= Re(fracex);
        fracex:= frac(fracex);
        if fracex > 0.5 then fracex:= 1 - fracex end_if;
      end_if;  
      DIGITS:= 10;
      bool(fracex < 1e-9) and isreal
    end_if  
  end_if
end_proc: /* property::isConstInteger */
