//   

//property::isConstReal
// entscheide, ob geg. Konstante reell ist
property::isConstReal:=
proc(ex)
  local z, fl;
begin
   //-------------------------------------------------
  // ex = a number
  //-------------------------------------------------
  case domtype(ex)
    of DOM_INT do
    of DOM_RAT do
    of DOM_IDENT do // all of PI, EULER, CATALAN are real
      return(TRUE)
    of DOM_FLOAT do
      return(not contains({RD_INF, RD_NINF, RD_NAN}, ex))
    of DOM_COMPLEX do
      return(FALSE)
  end_case;

  //-------------------------------------------------
  // Test constant numerical expressions by a
  // float check.
  // numeric::isreal(x) yields TRUE/FLOAT/UNKNOWN.
  // TRUE is absolutely safe; this happens only for exact
  //         numerical types of the kernel
  // FALSE is absolutely safe for exact numerical types
  //       of the kernel. For constant algebraic expressions,
  //       it is heuristically ok with high probability
  // UNKNOWN does not provide any information; this happens
  //         if Im(float(x)) = 0 or if x contains
  //         symbolic objects.
  //-------------------------------------------------
  z:= numeric::isreal(ex);
  if z <> UNKNOWN then
    return(z)
  end_if;
  if traperror((fl:= float(ex))) <> 0
    or not contains({DOM_FLOAT, DOM_COMPLEX}, type(fl)) then
    return(UNKNOWN)
  end_if;
  if has(ex, infinity) then
    return(FALSE)
  else
    // not safe ! But let's do it
    return(TRUE)
  end_if
end_proc:
