/* property::reduceZPolyModPrime
 * Input:
 *  f: Ein Ausdruck/ Polynom in einer oder mehrerer Variablen
 *  modulo: Eine ganze (Prim-)Zahl, modulo der gerechnet werden soll
 *  ind: Die unbekannten, ber die reduziert werden soll. Wenn nicht angegeben, werden alle unbekannten genommen
 * Output:
 *  Ein Polynom g vom Typ DOM_POLY, das in Z_moduls[inds] die gleichen Nullstellen hat wie f mit degree(g)<modulo
 */
property::reduceZPolyModPrime := proc(f, modulo, ind:DOM_SET)
  local reduceDeg;
begin
  /* reduceDeg
   * Decrements an exponent in the way that x^modulo => x^1
   * Input:
   *  deg: DOM_INT the exponent
   * Output:
   *  DOM_INT, the smaller exponent with exponent<modulo
   */
  reduceDeg := proc(deg)
  begin
    while deg>=modulo do
      deg := (deg div modulo) + (deg mod modulo);
    end_while;
    deg;
  end_proc;

  /* Reduce all power, since we known X^modulo=x^1
   * This is a heuristic is sufficient, since all calls to this function
   * use expressions from a poly().
   */
  f := misc::maprec(f, {"_power"}=proc(X)
    begin
      if contains(ind, op(X,1)) and type(op(X,2))=DOM_INT then
        X := op(X,1)^reduceDeg(op(X,2));
      end_if;
      X;
    end_proc);

  f;
end_proc: