/*
   property::subsIdent(ident, xpr)

   Modifies the assumptions under which the current procedure works by
   replacing ident by xpr in all assumptions made so far.
   The effect lasts until the calling procedure is left;
   then the old assumptions are restored.

*/

property::subsIdent :=
proc(ident: DOM_IDENT, xpr)
  local props; 
begin
  if protected(ident) = Error then
    error("Cannot overwrite properties of protected variable")
  end_if;
    
  props := showprop(ident);

  if nops(props) > 0 then
    traperror(context(hold(_save)(ident)));
    props := _and(op(subs(props, ident=xpr)));
    context(hold(_delete)(ident));
    context(hold(assumeAlso)(props))
  end_if;
  
  return()
end_proc:

