/*--
 Ei/Series -- the function attribut "series" for Ei
--*/

Ei::series := proc(m,f,x,n,dir,opt) // series(Ei(f),x=0,n) 
    local s,t,i,k,tt,a,fm,r;
begin
  if args(0) = 5 then
    //-----------------------------------------------------
    //-----------------------------------------------------
    // this is the call series(Ei(f(x)), x, n, dir, opt)
    //-----------------------------------------------------
    //-----------------------------------------------------
    [f, x, n, dir, opt]:= [m, f, x, n, dir];
    if f = x then // expansion of Ei(x) for x = 0 
       if iszero(n) then
         Series::error("order too small")
       end_if;
       // 5.1.11
       return(Series::Puiseux::create(1, 0, n, [ln(x)/2 - ln(1/x)/2 + EULER] . 
                                      Series::gen["Ei"](n), x, 0, dir)
             );
    else // f <> x
       t := Series::series(f, x, n, dir);
       if domtype(t) = Series::Puiseux then
         k := Series::Puiseux::ldegree(t);
         if k = FAIL then // t = O(..)
           Series::error("order too small");
         elif k > 0 then // f goes to zero 
           if n = 0 then
             Series::error("order too small")
           end_if;
           // 5.1.11
           s := Series::Puiseux::create(1, 1, n, Series::gen["Ei"](n),
                                        x, 0, dir);
           return((s @ t)
                  + Series::series(EULER + ln(f)/2 - ln(1/f)/2, x, n + 1, dir))
         elif k < 0 then // f goes to +/-infinity 
           // 5.1.51
           tt := 1;
           s:=Series::Puiseux::create(1,1,n+1,[1,(tt:=tt*i)$i=1..n-1],x,0,dir);
           s:=Series::Puiseux::_fconcat(s, 1/t);
           a:= lcoeff(t);
           if is(a, Type::Real) = TRUE then
              if is(a > 0) = TRUE then
                 return(s * Series::series(exp(f), x, n, dir))
              elif is(a < 0) = TRUE then
                 return( (signIm(f) - signIm(conjugate(f)))*PI/2*I
                        + s * Series::series(exp(f), x, n, dir)
                       );
              end_if:
           elif is(a/I, Type::Real) = TRUE then
              return(signIm(a)*PI*I +s*Series::series(exp(f), x, n, dir))
           end_if:
         elif k = 0 then // expansion around a finite point <> 0
           a := lcoeff(t);
           if is(a < 0) = TRUE then
             // expansion on the branch cut
             return(Series::Puiseux::const((signIm(f) - signIm(conjugate(f)))*PI/2*I, x, n, dir)
                  + Series::unknown(Ei(f),x,n,dir))
           end_if
         end_if;
         Series::unknown(Ei(f),x,n,dir)
       else
         userinfo(2, "unable to compute series expansion");
         FAIL
       end_if;
    end_if;
  else 
    //-----------------------------------------------------
    //-----------------------------------------------------
    // this is the call series(Ei(m, f(x)), x, n, dir, opt)
    //-----------------------------------------------------
    //-----------------------------------------------------
    if iszero(frac(m)) then 
       m:= round(m);
    end_if:
    if f = x then // expansion of Ei(m, x) for x = 0 
       if iszero(n) then
         Series::error("order too small")
       end_if;
       // 5.1.11
       if domtype(m) = DOM_INT then
          r:= null():
          for i from 0 to n - 1 do
            if iszero(i - m + 1) then 
              r:= r, (-ln(x) + psi(m))*(-1)^(m-1)/gamma(m);
            else
              r:= r, (-1)^(i+1)/i!/(i - m + 1);
            end_if:
          end_for:
          if m >= 0 then
             return(Series::Puiseux::create(1, 0, n, [r], x, 0, dir));
          else
             return( Series::series(gamma(1-m)*x^(m-1), x, n, dir)
                    +Series::Puiseux::create(1, 0, n, [r], x, 0, dir));
          end_if:
       elif domtype((fm:= float(m))) = DOM_FLOAT then
          if fm >= n + 1 then
             r:= (-1)^(i+1)/i!/(i - m + 1) $ i = 0..n-1;
             return(Series::Puiseux::create(1, 0, n, [r], x, 0, dir));
          elif fm > n then
             r:= [[(-1)^(i+1)/(i - m + 1)/i!, x^i] $ i = 0.. n-1];
             return(Series::gseries::create(r, x^(m-1), x));
          elif fm <= 0 then
             r:= [ [gamma(1-m), x^(m-1)], 
                  ([(-1)^(i+1)/(i - m + 1)/i!, x^i] $ i = 0.. n-2)] ; 
             return(Series::gseries::create(r, x^(n-1), x));
          elif fm <= n then
             r:= [([(-1)^(i+1)/(i - m + 1)/i!, x^i] $ i = 0.. trunc(fm)-1),
                   [gamma(1-m), x^(m-1)], 
                  ([(-1)^(i+1)/(i - m + 1)/i!, x^i] $ i = trunc(fm).. n-2)
                 ] ; 
             return(Series::gseries::create(r, x^(n-1), x));
          end_if:
       end_if:
    else // expansion of Ei(m, f(x))
       t := Series::series(f, x, n, dir);
       if domtype(t) = Series::Puiseux then
         k := Series::Puiseux::ldegree(t);
         if k = FAIL then // t = O(..)
           Series::error("order too small");
         elif k > 0 then // f goes to zero 
           if iszero(n) then
             Series::error("order too small")
           end_if;
           if domtype(m) = DOM_INT then
             r:= null():
             for i from 0 to n - 1 do
               if iszero(i - m + 1) then
                 r:= r, 0;
               else
                 r:= r, (-1)^(i+1)/i!/(i - m + 1);
               end_if:
             end_for:
             s:= Series::Puiseux::create(1, 0, n, [r], x, 0, dir);
             if m > 0 then
                return((s @ t)
                       + Series::series( (-1)^(m-1)/(m-1)!*f^(m-1)
                                        *(-ln(f) + psi(m)),
                                         x,max(1, n-m+1),dir));
             else
                return((s @ t)
                       + Series::series(gamma(1-m)*f^(m-1),x,n,dir));
             end_if;
           elif domtype((fm:= float(m))) = DOM_FLOAT then
             r:= (-1)^(i+1)/i!/(i - m + 1) $ i = 0..n-1;
             s:=   Series::series(gamma(1 - m)*f^(m - 1), x, n, dir, opt)
                 + Series::Puiseux::create(1, 0, n, [r], x, 0, dir)@t;
             return(s);
           end_if:

         elif k < 0 then // f goes to +/-infinity 
           // 5.1.51
           tt := 1;
           s:=Series::Puiseux::create(1,1,n+1,[1,(tt:=-tt*(i + m - 1))$i=1..n-1],x,0,dir);
           s:=Series::Puiseux::_fconcat(s, 1/t);
           return(s * Series::series(exp(-f), x, n, dir))
         elif k = 0 then // expansion around a finite point <> 0
           a := lcoeff(t); // the expansion point
           // Expansion on the branch cut around the point a.
           // There is no branch cut if m is a negative integer.
           // Otherwise, Ei(m, x) is continuous from above with
           // a jump of height -2*PI*I *a^(m-1)/gamma(m)*(-1)^m
           // when crossing the negative real axis from the upper
           // half plane to the lower half plane at the point a.
           // Note signmIm(f) - 1 = -2 if f is in the lower plane,
           // whereas signIm(f) - 1 = 0 if f is on the real axis or 
           // above:
           if is(a < 0) = TRUE then
             // build the jump along the branch cut into the expansion:
             if domtype(m) <> DOM_INT then
                  return(
                      Series::series(
                         (exp(PI*I*m*(signIm(f) - 1)) - 1)*
                         _plus((-1)^k*a^(m-k-1)*gamma(1+k-m)*(f-a)^k/k! $ k = 0 .. n),
                         x, n, dir)
                    + Series::unknown(Ei(m, f),x,n,dir)
                     )
             end_if;
             if domtype(m) = DOM_INT and m > 0 then
                  // use the formula above with the limit
                  // (exp(PI*I*m*(signIm(f) -1))-1)/sin(PI*(k-m)) 
                  //      -->  (-1)^k* PI*I*(1 - signIm(f))
                  return(
                      Series::series(
                         _plus((-1)^m*PI*I*(signIm(f) - 1)*
                               a^(m-k-1)/gamma(m-k)*(f-a)^k/k! $ k = 0 .. min(m-1,n))
                       + _plus((exp(PI*I*m*(signIm(f) - 1)) - 1)*
                               (-1)^k*a^(m-k-1)*gamma(1+k-m)*(f-a)^k/k! $ k = m .. n)
                        , x, n, dir)
                    + Series::unknown(Ei(m, f),x,n,dir)
                     )
             end_if;
             // otherwise: just return the Taylor expansion below
           end_if
         end_if;
         // return the Taylor expansion:
         Series::unknown(Ei(m, f),x,n,dir)
       else
         userinfo(2, "unable to compute series expansion");
         FAIL
       end_if;
    end_if;
  end_if:
end_proc:

// ensure that the domain Series is loaded
Series:

// expansion of Ei(x) - EULER - ln(x) around x = 0, formula 5.1.11
// =  x/1*1! + x^2/2*2! + x^3/3*3! +- ...
Series::gen["Ei"] := proc(n)
  local t, i;
begin
  [(t := 1), (t := t*(i - 1)/i^2) $ i = 2..(n - 1)]
end_proc:
Series::gen["Ei"](1):=[]:
Series::gen["Ei"](2):=[1]:

// end of file 
